    

    <?php $__env->startSection('content'); ?>
        <!-- Display success message -->
        <br>
        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <h4 class="page-title">Rekod</h4>
                </div>
            </div>
        </div>
        <!-- end page title -->

        <div class="row">
            <!-- Plant Types by Category -->
            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-6 col-xl-4">
                    <?php if($category->name == 'Kelapa'): ?>
                        <div class="card widget-flat bg-info text-white">
                            <div class="card-body">
                                <div class="float-right">
                                    <i class=" mdi mdi-fruit-cherries widget-icon bg-light text-info"></i>
                                </div>
                                <h5 class="text-uppercase mt-0" title="Growth"> <?php echo e($category->name); ?></h5>
                                <h3 class="mt-3 mb-3"><?php echo e($plantTypeCountByCategory[$category->id] ?? 0); ?> Pokok</h3>
                            </div>
                        </div>
                    <?php elseif($category->name == 'Pisang'): ?>
                        <div class="card widget-flat bg-warning text-white">
                            <div class="card-body">
                                <div class="float-right">
                                    <i class="mdi mdi-flower-poppy widget-icon bg-light text-warning"></i>
                                </div>
                                <h5 class="text-uppercase mt-0" title="Growth"> <?php echo e($category->name); ?></h5>
                                <h3 class="mt-3 mb-3"><?php echo e($plantTypeCountByCategory[$category->id] ?? 0); ?> Pokok</h3>
                            </div>
                        </div>
                    <?php endif; ?>
                </div> <!-- end col-->
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <!-- Overall Total Plant Types -->
            <div class="col-lg-6 col-xl-4">
                <div class="card widget-flat bg-success text-white">
                    <div class="card-body">
                        <div class="float-right">
                            <i class="mdi mdi-dresser widget-icon bg-light text-success"></i>
                        </div>
                        <h5 class="text-uppercase mt-0" title="Growth">Jumlah Keseluruhan</h5>
                        <h3 class="mt-3 mb-3"><?php echo e($totalPlantTypes); ?> Pokok</h3>
                    </div>
                </div>
            </div> <!-- end col-->
        </div>
        <!-- end row-->

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <h4 class="header-title">Pokok</h4>
                            <a href="javascript: void(0);" data-toggle="modal" data-target="#add-modal"
                                class="btn btn-info btn-sm" style="position: absolute; right:2%;">+Tambah Pokok</a>
                            <br><br>
                        </div>

                        <table id="basic-datatable" class="table dt-responsive nowrap w-100">
                            <thead>
                                <tr>
                                    <th>Bil</th>
                                    <th>Nama Pokok</th>
                                    <th>Kategori Pokok</th>
                                    <th>Tindakan</th>
                                </tr>
                            </thead>


                            <tbody>
                                <?php $__currentLoopData = $plantDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plantDetail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($loop->index + 1); ?>.</td>
                                        <td><?php echo e($plantDetail->plant_type); ?></td>
                                        <td>
                                            <?php if($plantDetail->category->name == 'Kelapa'): ?>
                                                <span class="badge badge-warning">Kelapa</span>
                                            <?php else: ?>
                                                <span class="badge badge-info"><?php echo e($plantDetail->category->name); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td class="table-action">
                                            <a href="javascript: void(0);" class="action-icon" data-toggle="modal"
                                                data-target="#view-modal-<?php echo e($plantDetail->id); ?>"> <i
                                                    class="mdi mdi-eye-check text-primary"></i></a>
                                            <a href="javascript: void(0);" class="action-icon" data-toggle="modal"
                                                data-target="#edit-modal-<?php echo e($plantDetail->id); ?>"> <i
                                                    class="mdi mdi-file-document-edit text-info"></i></a>
                                            <a href="javascript: void(0);" class="action-icon" data-toggle="modal"
                                                data-target="#delete-modal-<?php echo e($plantDetail->id); ?>"
                                                data-id="<?php echo e($plantDetail->id); ?>">
                                                <i class="mdi mdi-delete text-danger"></i>
                                            </a>

                                        </td>
                                    </tr>

                                    <!-- Add modal -->
                                    <div id="add-modal" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
                                        <div class="modal-dialog ">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h4 class="modal-title" id="addModalLabel">Maklumat Pokok</h4>
                                                    <button type="button" class="close" data-dismiss="modal"
                                                        aria-hidden="true">×</button>
                                                </div>
                                                <div class="modal-body">
                                                    <form role="form" action="<?php echo e(route('plant.store')); ?>" method="POST"
                                                        enctype="multipart/form-data">
                                                        <?php echo csrf_field(); ?>
                                                        <div class="form-row">
                                                            <div class="form-group col-md-8">
                                                                <label for="inputState" class="col-form-label">Kategori
                                                                    Pokok</label>
                                                                <select name="plant_category" id="plant_category"
                                                                    class="form-control">
                                                                    <option selected>Sila Pilih</option>
                                                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($category->id); ?>">
                                                                            <?php echo e($category->name); ?></option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>

                                                            <div class="form-group col-md-4">
                                                                <label for="inputEmail4" class="col-form-label">Nama
                                                                    Pokok</label>
                                                                <input type="text" name="plant_type" class="form-control"
                                                                    id="plant_type" placeholder="Eg: Emas">
                                                            </div>

                                                        </div>

                                                        <div class="form-group ">
                                                            <label for="inputState" class="col-form-label">Tempoh Kematangan
                                                                (Bulan)
                                                            </label>
                                                            <input type="text" name="plant_maturity"
                                                                class="form-control" id="plant_maturity"
                                                                placeholder="Eg: 19 Bulan">
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-light"
                                                                data-dismiss="modal">Batal</button>
                                                            <button type="submit" class="btn btn-info">Simpan</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div><!-- /.modal-content -->
                                        </div><!-- /.modal-dialog -->
                                    </div><!-- /.modal -->

                                    <!-- Edit modal -->
                                    <div id="edit-modal-<?php echo e($plantDetail->id); ?>" class="modal fade" tabindex="-1"
                                        role="dialog" aria-hidden="true">
                                        <div class="modal-dialog ">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h4 class="modal-title" id="editModalLabel">Kemaskini Maklumat Pokok
                                                    </h4>
                                                    <button type="button" class="close" data-dismiss="modal"
                                                        aria-hidden="true">×</button>
                                                </div>
                                                <div class="modal-body">
                                                    <form action="<?php echo e(route('plant.update', $plantDetail->id)); ?>"
                                                        method="POST" enctype="multipart/form-data">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('PUT'); ?>
                                                        <div class="form-row">
                                                            <div class="form-group col-md-8">
                                                                <label for="inputState" class="col-form-label">Kategori
                                                                    Pokok</label>
                                                                <input type="text" name="plant_category"
                                                                    class="form-control"
                                                                    value="<?php echo e($plantDetail->category->name); ?>" readonly>
                                                            </div>

                                                            <div class="form-group col-md-4">
                                                                <label for="inputEmail4" class="col-form-label">Nama
                                                                    Pokok</label>
                                                                <input type="text" name="plant_type"
                                                                    class="form-control"
                                                                    value="<?php echo e($plantDetail->plant_type); ?>" readonly>
                                                            </div>
                                                        </div>

                                                        <div class="form-group ">
                                                            <label for="inputState" class="col-form-label">Tempoh
                                                                Kematangan (Bulan)</label>
                                                            <input type="number" name="plant_maturity"
                                                                class="form-control"
                                                                value="<?php echo e($plantDetail->plant_maturity); ?>" required>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-light"
                                                                data-dismiss="modal">Batal</button>
                                                            <button type="submit" class="btn btn-info">Kemaskini</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div><!-- /.modal-content -->
                                        </div><!-- /.modal-dialog -->
                                    </div><!-- /.modal -->

                                    <!-- View modal -->
                                    <div id="view-modal-<?php echo e($plantDetail->id); ?>" class="modal fade" tabindex="-1"
                                        role="dialog" aria-hidden="true">
                                        <div class="modal-dialog ">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h4 class="modal-title" id="viewModalLabel">Maklumat Pokok</h4>
                                                    <button type="button" class="close" data-dismiss="modal"
                                                        aria-hidden="true">×</button>
                                                </div>
                                                <div class="modal-body">
                                                    <form>
                                                        <div class="form-row">
                                                            <div class="form-group col-md-8">
                                                                <label for="inputState" class="col-form-label">Kategori
                                                                    Pokok</label>
                                                                <input type="text" name="plant_category"
                                                                    class="form-control"
                                                                    value="<?php echo e($plantDetail->category->name); ?>" readonly>
                                                            </div>

                                                            <div class="form-group col-md-4">
                                                                <label for="inputEmail4" class="col-form-label">Nama
                                                                    Pokok</label>
                                                                <input type="text" name="plant_type"
                                                                    class="form-control"
                                                                    value="<?php echo e($plantDetail->plant_type); ?>" readonly>
                                                            </div>
                                                        </div>

                                                        <div class="form-group ">
                                                            <label for="inputState" class="col-form-label">Tempoh
                                                                Kematangan (Bulan)</label>
                                                            <input type="number" name="plant_maturity"
                                                                class="form-control"
                                                                value="<?php echo e($plantDetail->plant_maturity); ?>" readonly>
                                                        </div>
                                                    </form>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-info"
                                                        data-dismiss="modal">Tutup</button>
                                                </div>
                                            </div><!-- /.modal-content -->
                                        </div><!-- /.modal-dialog -->
                                    </div><!-- /.modal -->


                                    <!-- Delete modal -->
                                    <div id="delete-modal-<?php echo e($plantDetail->id); ?>" class="modal fade" tabindex="-1"
                                        role="dialog" aria-hidden="true">
                                        <div class="modal-dialog ">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h4 class="modal-title" id="deleteModalLabel">Padam Maklumat Pokok
                                                    </h4>
                                                    <button type="button" class="close" data-dismiss="modal"
                                                        aria-hidden="true">×</button>
                                                </div>
                                                <div class="modal-body">
                                                    <p>Adakah anda mahu memadam maklumat ini?</p>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-light btn-sm"
                                                        data-dismiss="modal">Tidak, Batal</button>
                                                    <form method="POST"
                                                        action="<?php echo e(route('plant.destroy', $plantDetail->id)); ?>">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <input type="hidden" name="plant_id"
                                                            value="<?php echo e($plantDetail->id); ?>">
                                                        <button type="submit" class="btn btn-danger btn-sm">Betul,
                                                            Padam</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div><!-- /.modal -->
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div> <!-- end card body-->
                </div> <!-- end card -->
            </div><!-- end col-->
        </div>
        <!-- end row-->
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\desa-grow-farm\resources\views/plant/index.blade.php ENDPATH**/ ?>