<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Plantation extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'farm_id',
        'plant_detail_id',
        'tumbesaran_id',
        'akar_id',
        'buah_id',
        'matang_id',
        'pengait_id',
        'penanam_id',
        'plant_date',
        'harvest_date',
        'quantity_plant',
        'status',
        'image_tanam',
        'image_kait',
        'tumbesaran_date',
        'akar_date',
        'buah_date',
        'matang_date',
    ];

    //set string, get as array
    protected $casts = [
        'tumbesaran_date' => 'array',
        'akar_date' => 'array',
        'buah_date' => 'array',
        'matang_date' => 'array',
    ];

    public function farm()
    {
        return $this->belongsTo(Farm::class);
    }

    public function plantDetail()
    {
        return $this->belongsTo(PlantDetail::class);
    }

    public function tumbesaran()
    {
        return $this->belongsTo(Fertilizer::class, 'tumbesaran_id'); // Adjust 'tumbesaran_id' to the foreign key in Fertilizer table
    }

    public function akar()
    {
        return $this->belongsTo(Fertilizer::class, 'akar_id'); // Adjust 'akar_id' to the foreign key in Fertilizer table
    }

    public function buah()
    {
        return $this->belongsTo(Fertilizer::class, 'buah_id'); // Adjust 'buah_id' to the foreign key in Fertilizer table
    }

    public function matang()
    {
        return $this->belongsTo(Fertilizer::class, 'matang_id'); // Adjust 'matang_id' to the foreign key in Fertilizer table
    }

    public function pengait()
    {
        return $this->belongsTo(User::class, 'pengait_id'); // Adjust 'pengait_id' to the foreign key in User table
    }

    public function penanam()
    {
        return $this->belongsTo(User::class, 'penanam_id'); // Adjust 'penanam_id' to the foreign key in User table
    }

    public function harvest()
    {
        return $this->hasOne(Harvest::class); // Relationship for harvest
    }

    public function damage()
    {
        return $this->hasMany(Damage::class); // Relationship for Damage
    }
}
