<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PlantDetail extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'categories_id',
        'plant_type',
        'plant_maturity',
    ];
    protected $dates = ['deleted_at'];

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function harvest()
    {
        return $this->hasMany(Harvest::class);
    }
}
