<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\PestCategory;
use App\Models\PestControlDetail;
use Illuminate\Support\Facades\Storage;
use Illuminate\Http\Request;

class PestControlDetailController extends Controller
{
    public function index()
    {
        $pestDetail = PestControlDetail::orderBy('created_at','desc')->get();

        $categories = Category::all();
        $pest_categories = PestCategory::all();


        $totalPesticides = PestControlDetail::count();
        $totalPestCategories = PestControlDetail::distinct('pest_category_id')->count('pest_category_id');

        
        return view('pest-detail.index', compact('pestDetail', 'categories', 'pest_categories','totalPesticides','totalPestCategories'))->with('success', session('success'));
    }

    public function create()
    {
        $categories = Category::all();
        $pestCategory = PestCategory::all();
        return view('pest-detail.create', compact('categories', 'pestCategory'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'plant_category' => 'required|exists:categories,id',
            'pest_category' => 'required|exists:pest_categories,id',
            'pest_name' => 'required|string',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
        ]);


        $pestDetail = new PestControlDetail();

        $pestDetail->category_id = $request->plant_category;
        $pestDetail->pest_category_id = $request->pest_category;
        $pestDetail->pest_name = $request->pest_name;

        // Check if the request has an image file
        if ($request->hasFile('image') && isset($request->image)) {
            // Get the original file name
            $originalFileName = $request->file('image')->getClientOriginalName();

            // Store the image in the 'public/banner' directory with the original name
            $imagePath = $request->file('image')->storeAs('public/banner', $originalFileName);

            // Save the path to the database
            $pestDetail->image = $imagePath; // Save the path to the database
        }


        $pestDetail->save();


        return redirect()->route('pest-detail.index')->with('success', 'Maklumat Baja Berjaya Disimpan.');
    }



    public function show($id)
    {
        $pestDetail = PestControlDetail::find($id);
        return view('pest-detail.index', compact('pestDetail'));
    }

    public function edit($id)
    {
        $pestDetail = PestControlDetail::findOrFail($id);
        $categories = Category::all();
        $pest_categories = Category::all();


        return view('pest-detail.index', compact('pestDetail', 'categories', 'pest_categories'));
    }

    public function update(Request $request, $id)
    {

        $request->validate([
            'plant_category' => 'required|exists:categories,id',
            'pest_category' => 'required|exists:pest_categories,id',
            'pest_name' => 'required|string',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
        ]);

        // Find the farm by ID
        $pestDetail = PestControlDetail::findOrFail($id);

        // Update the farm's attributes
        $pestDetail->category_id = $request->plant_category;
        $pestDetail->pest_category_id = $request->pest_category;
        $pestDetail->pest_name = $request->pest_name;

        // Handle PDF upload if a new file is provided
        if ($request->hasFile('image')) {
            // Delete the old PDF file if it exists
            if ($pestDetail->image) {
                Storage::delete($pestDetail->image);
            }


            $originalFileName = $request->file('image')->getClientOriginalName();
            $imagePath = $request->file('image')->storeAs('public/banner', $originalFileName);
            $pestDetail->image = $imagePath; // Save the new path to the database
        }


        $pestDetail->save();


        return redirect()->route('pest-detail.index')->with('success', 'Kebun Berjaya Dikemaskini.');
    }


    public function destroy($id)
    {
        $pestDetail = PestControlDetail::findOrFail($id);
        $pestDetail->delete();

        return redirect()->route('pest-detail.index')->with('success', 'Maklumat Pokok Berjaya Dipadam.');
    }
}
