<?php

namespace App\Http\Controllers;

use App\Models\PestControl;
use App\Models\PestCategory;
use App\Models\PestControlDetail;
use App\Models\Category;
use App\Models\PlantDetail;
use Illuminate\Http\Request;

class PestControlController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $pestControls = PestControl::with(['plantDetail' => function ($query) {
            $query->withTrashed();
        }, 'pestControlDetail' => function ($query) {
            $query->withTrashed();
        }])->get();
        return view('pest.index', compact('pestControls'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $categories = Category::all();
        $pestCategories = PestCategory::All();
        $plantDetails = PlantDetail::with('category')->get()->groupBy('category_id'); // Assuming you have a category_id in plant_details
        $pestControlDetails = PestControlDetail::with(['category', 'pestCategory'])
            ->get()
            ->groupBy('category_id');
        return view('pest.create', compact('pestCategories', 'categories', 'plantDetails', 'pestControlDetails'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StorePestControlRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'plant_category' => 'required|exists:categories,id',
            'plant_type' => 'required|exists:plant_details,id',
            'pest_name' => 'required|exists:pest_control_details,id',
            'amount' => 'required|integer',
            'amount_type' => 'required|string',
            'description' => 'required|string',
        ]);

        $pestControl = new PestControl();
        $pestControl->plant_detail_id = $request->plant_type;
        $pestControl->pest_control_detail_id = $request->pest_name;
        $pestControl->amount = $request->amount;
        $pestControl->amount_type = $request->amount_type;
        $pestControl->description = $request->description;


        $pestControl->save();

        return redirect()->route('pest.index')->with('success', 'Maklumat Racun Berjaya Disimpan');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\PestControl  $pestControl
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $pestControls = PestControl::with(['plantDetail' => function ($query) {
            $query->withTrashed();
        }, 'pestControlDetail' => function ($query) {
            $query->withTrashed();
        }])->findOrFail($id);
        // $categories = Category::all();
        return view('pest.show', compact('pestControls'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\PestControl  $pestControl
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $pestControls = PestControl::with(['plantDetail' => function ($query) {
            $query->withTrashed();
        }, 'pestControlDetail' => function ($query) {
            $query->withTrashed();
        }])->findOrFail($id);
        return view('pest.edit', compact('pestControls'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdatePestControlRequest  $request
     * @param  \App\Models\PestControl  $pestControl
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'amount' => 'required|integer',
            'amount_type' => 'required|string',
            'description' => 'required|string',
        ]);

        $pestControl = PestControl::findOrFail($id);
        $pestControl->amount = $request->amount;
        $pestControl->amount_type = $request->amount_type;
        $pestControl->description = $request->description;
        $pestControl->save();

        return redirect()->route('pest.index')->with('success', 'Maklumat Racun Berjaya Dikemaskini');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\PestControl  $pestControl
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $pestControl = PestControl::findOrFail($id);
        $pestControl->delete();

        return redirect()->route('pest.index')->with('success', 'Maklumat Racun Berjaya Dipadam.');
    }
}
