<?php

namespace App\Http\Controllers;
use App\Models\Customer;
use Illuminate\Http\Request;

class CustomerController extends Controller
{
    public function index()
    {
        $customers = Customer::orderBy('created_at', 'desc')->get();
        $totalCustomer = Customer::count();
        return view('customer.index', compact('customers','totalCustomer'))->with('success', session('success'));
    }

    public function create()
    {
        $customer = Customer::all();
        return view('customer.create', compact('customer'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'customer_name' => 'required|string|max:255',
            'company_name' => 'required|string|max:255',
            'phone_number' => 'required|string|max:255',
            'address' => 'required|string|max:255',
        ]);


        $customer = new Customer();

        $customer->customer_name = $request->customer_name;
        $customer->company_name = $request->company_name;
        $customer->phone_number = $request->phone_number;
        $customer->address = $request->address;

        $customer->save();


        return redirect()->route('customer.index')->with('success', 'Maklumat Pelanggan Berjaya Disimpan.');
    }

    public function show($id)
    {
        $customer = Customer::find($id);
        return view('customer.show', compact('customer'));
    }

    public function edit($id)
    {
        $customer = Customer::find($id);
        return view('customer.edit', compact('customer'));
    }

    public function update(Request $request, $id)
    {

        $request->validate([
            'customer_name' => 'nullable|string|max:255',
            'company_name' => 'nullable|string|max:255',
            'phone_number' => 'nullable|string|max:255',
            'address' => 'nullable|string|max:255',
        ]);

        // Find the customer by ID
        $customer = Customer::findOrFail($id);

        // Update the customer's attributes
        $customer->customer_name = $request->customer_name;
        $customer->company_name = $request->company_name;
        $customer->phone_number = $request->phone_number;
        $customer->address = $request->address;

      

        // Save the updated customer details
        $customer->save();

        // Redirect back to the index page with a success message
        return redirect()->route('customer.index')->with('success', 'Maklumat Pelanggan Berjaya Dikemaskini.');
    }

    public function destroy(Customer $customer)
    {
        // Delete the customer record
        $customer->delete();

        // Redirect back with a success message
        return redirect()->route('customer.index')->with('success', 'Maklumat Pelanggan Berjaya Dipadam.');
    }
}
