

<?php $__env->startSection('content'); ?>
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <h4 class="page-title">Rekod</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card widget-inline">
                <div class="card-body p-0">
                    <div class="row no-gutters">
                        <!-- Jumlah Tanaman -->
                        <div class="col">
                            <div class="card shadow-none m-0">
                                <div class="card-body bg-secondary text-center">
                                    <i class="mdi mdi-flower-tulip-outline text-white" style="font-size: 24px;"></i>
                                    <h3 class="text-white"><span><?php echo e($jumlahTanaman); ?></span></h3>
                                    <p class="text-white font-15 mb-0">Jumlah Tanaman</p>
                                </div>
                            </div>
                        </div>
                         <!-- Kebun Kosong -->
                         <?php if(auth()->user()->role === 'Tuan_Kebun'): ?>
                         <div class="col">
                             <div class="card shadow-none m-0 border-left">
                                 <div class="card-body bg-success text-center">
                                     <i class="mdi mdi-basket-unfill text-white" style="font-size: 24px;"></i>
                                     <h3 class="text-white"><span><?php echo e($kebunKosong); ?></span></h3>
                                     <p class="text-white font-15 mb-0">Kebun Kosong</p>
                                 </div>
                             </div>
                         </div>
                         <?php endif; ?>
    
                        <!-- Baru -->
                        <div class="col">
                            <div class="card shadow-none m-0 border-left">
                                <div class="card-body bg-primary text-center">
                                    <i class="mdi mdi-cannabis text-white" style="font-size: 24px;"></i>
                                    <h3 class="text-white"><span><?php echo e($baru); ?></span></h3>
                                    <p class="text-white font-15 mb-0">Baru</p>
                                </div>
                            </div>
                        </div>
    
                        <!-- Tanam -->
                        <div class="col">
                            <div class="card shadow-none m-0 border-left">
                                <div class="card-body bg-info text-center">
                                    <i class=" mdi mdi-data-matrix text-white" style="font-size: 24px;"></i>
                                    <h3 class="text-white"><span><?php echo e($tanam); ?></span></h3>
                                    <p class="text-white font-15 mb-0">Tanam</p>
                                </div>
                            </div>
                        </div>
                    </div> <!-- end row -->
                </div>
            </div> <!-- end card-box-->
        </div> <!-- end col-->
    </div>
    <!-- end row-->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <h4 class="header-title">Tanaman</h4>
                        <?php if(auth()->user()->role === 'Tuan_Kebun'): ?>
                            <a href="<?php echo e(route('plantation.create')); ?>" class="btn btn-info btn-sm"
                                style="position: absolute; right:2%;">+Tambah Tanaman</a>
                            <br><br>
                        <?php endif; ?>

                    </div>


                    <table id="basic-datatable" class="table dt-responsive nowrap w-100">
                        <thead>
                            <tr>
                                <th>Bil.</th>
                                <th>Kebun</th>
                                <th>Kategori</th>
                                <th>Nama</th>
                                <th>Jumlah Tanam</th>
                                <?php if(auth()->user()->role === 'Tuan_Kebun' || auth()->user()->job_type === 'Penanam'): ?>
                                    <th>Tarikh Menanam</th>
                                <?php endif; ?>
                                <?php if(auth()->user()->role === 'Tuan_Kebun' || auth()->user()->job_type === 'Pengait'): ?>
                                    <th>Tarik Menuai</th>
                                <?php endif; ?>
                                <th>Status</th>
                                <th>Tindakan</th>
                            </tr>
                        </thead>


                        <tbody>
                            <?php $__currentLoopData = $filteredPlantations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plantation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($loop->index + 1); ?></td>
                                    <td><?php echo e($plantation->farm->name); ?></td>
                                    <td>
                                        <?php if($plantation->farm->category->name == 'Kelapa'): ?>
                                            <span class="badge badge-warning">Kelapa</span>
                                        <?php else: ?>
                                            <span class="badge badge-info"><?php echo e($plantation->farm->category->name); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($plantation->plantDetail->plant_type); ?></td>
                                    <td><?php echo e($plantation->quantity_plant); ?> Batang</td>
                                    <?php if(auth()->user()->role === 'Tuan_Kebun' || auth()->user()->job_type === 'Penanam'): ?>
                                        <td> <?php echo e(\Carbon\Carbon::parse($plantation->plant_date)->format('d F Y')); ?></td>
                                    <?php endif; ?>
                                    <?php if(auth()->user()->role === 'Tuan_Kebun' || auth()->user()->job_type === 'Pengait'): ?>
                                        <td> <?php echo e(\Carbon\Carbon::parse($plantation->harvest_date)->format('d F Y')); ?></td>
                                    <?php endif; ?>


                                    <td>
                                        <?php if($plantation->status == 'Baru'): ?>
                                        <span class="badge badge-danger">Baru</span>
                                    <?php elseif($plantation->status == 'Proses Tanam' || $plantation->status == 'Proses Tuai'): ?>
                                        <span class="badge badge-warning">Dalam Kerja</span>
                                    <?php elseif($plantation->status == 'Tanam'): ?>
                                        <?php if(Carbon\Carbon::now()->isSameDay($plantation->harvest_date)): ?>
                                            <span class="badge badge-danger">Menuai</span>
                                        <?php else: ?>
                                            <span class="badge badge-info">Tanam</span>
                                        <?php endif; ?>
                                    <?php elseif($plantation->status == 'Tuai Hasil'): ?>
                                        <span class="badge badge-success">Tuai Hasil</span>
                                    <?php elseif($plantation->status == 'Kira Hasil'): ?>
                                        <span class="badge badge-light">Kira Hasil</span>
                                    <?php elseif($plantation->status == 'Selesai'): ?>
                                        <span class="badge badge-secondary">Selesai</span>
                                    <?php endif; ?>
                                    </td>
                                    <td class="table-action">
                                        <a href="<?php echo e(route('plantation.show', $plantation->id)); ?>" class="action-icon"> <i
                                                class="mdi mdi-eye-check text-primary"></i></a>
                                        
                                        <?php if(auth()->user()->role === 'Tuan_Kebun' && $plantation->status === 'Baru'): ?>
                                            <a href="<?php echo e(route('plantation.edit', $plantation->id)); ?>" class="action-icon">
                                                <i class="mdi mdi-file-document-edit text-info"></i></a>
                                            <a href="javascript: void(0);" class="action-icon" data-toggle="modal"
                                                data-target="#delete-modal-<?php echo e($plantation->id); ?>"> <i
                                                    class="mdi mdi-delete text-danger"></i></a>
                                        <?php endif; ?>
                                        
                                        <?php if(auth()->user()->job_type === 'Penanam' && $plantation->status === 'Baru' && now()->greaterThanOrEqualTo($plantation->plant_date)): ?>
                                            <a href="javascript: void(0);" class="action-icon" data-toggle="modal"
                                                data-target="#statusTanamModal-<?php echo e($plantation->id); ?>"> <i
                                                    class="mdi mdi-file-document-edit text-info"></i></a>
                                        <?php elseif(auth()->user()->job_type === 'Penanam' && $plantation->status === 'Proses Tanam' ): ?>
                                            <a href="javascript: void(0);" class="action-icon" data-toggle="modal"
                                                data-target="#kemaskiniTanaman-modal-<?php echo e($plantation->id); ?>"> <i
                                                    class="mdi mdi-checkbox-multiple-marked text-success"></i></a>
                                        <?php endif; ?>
                                        
                                        <?php if(auth()->user()->job_type === 'Pengait' && $plantation->status === 'Tanam' && now()->greaterThanOrEqualTo($plantation->harvest_date)): ?>
                                            <a href="javascript: void(0);" class="action-icon" data-toggle="modal"
                                                data-target="#statusTuaiModal-<?php echo e($plantation->id); ?>"> <i
                                                    class="mdi mdi-file-document-edit text-info"></i></a>
                                        <?php elseif(auth()->user()->job_type === 'Pengait' && $plantation->status === 'Proses Tuai' ): ?>
                                            <a href="javascript: void(0);" class="action-icon" data-toggle="modal"
                                                data-target="#kemaskiniTuai-modal-<?php echo e($plantation->id); ?>"> <i
                                                    class="mdi mdi-checkbox-multiple-marked text-success"></i></a>
                                        <?php endif; ?>
                                    </td>
                                </tr>

                                <!-- Status Tanam Modal -->
                                <div class="modal fade" id="statusTanamModal-<?php echo e($plantation->id); ?>" tabindex="-1"
                                    role="dialog" aria-labelledby="statusModalLabel-<?php echo e($plantation->id); ?>"
                                    aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="statusModalLabel-<?php echo e($plantation->id); ?>">
                                                    Kemaskini Status <?php echo e($plantation->farm->name); ?></h5>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">

                                                Anda Pasti Mahu Kemaskini Status Penanaman <?php echo e($plantation->farm->name); ?>

                                                kepada <b>Dalam Kerja</b>?
                                                <br>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary"
                                                    data-dismiss="modal">Batal</button>
                                                <form method="POST"
                                                    action="<?php echo e(route('plantation.tanam', $plantation->id)); ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('PATCH'); ?>
                                                    <button type="submit" class="btn btn-primary">Betul</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- KemaskiniTanam modal -->
                                <div id="kemaskiniTanaman-modal-<?php echo e($plantation->id); ?>" class="modal fade" tabindex="-1"
                                    role="dialog" aria-hidden="true">
                                    <div class="modal-dialog ">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title" id="editModalLabel">Kemaskini Status Tanaman
                                                </h4>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-hidden="true">×</button>
                                            </div>
                                            <div class="modal-body">
                                                <form action="<?php echo e(route('plantation.kemaskiniTanam', $plantation->id)); ?>"
                                                    method="POST" enctype="multipart/form-data">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('PUT'); ?>
                                                    <div class="form-row">
                                                        <div class="form-group col-md-12">
                                                            <label for="inputState" class="col-form-label">Nama
                                                                Kebun</label>
                                                            <input type="text" name="plant_category"
                                                                class="form-control"
                                                                value="<?php echo e($plantation->farm->name); ?>" readonly>
                                                        </div>

                                                        <div class="form-group col-md-6">
                                                            <label for="inputEmail4" class="col-form-label">Jenis
                                                                Pokok</label>
                                                            <input type="text" name="plant_type" class="form-control"
                                                                value="<?php echo e($plantation->farm->category->name); ?>" readonly>
                                                        </div>
                                                        <div class="form-group col-md-6">
                                                            <label for="inputEmail4" class="col-form-label">Nama
                                                                Pokok</label>
                                                            <input type="text" name="plant_type" class="form-control"
                                                                value="<?php echo e($plantation->plantDetail->plant_type); ?>" readonly>
                                                        </div>
                                                        <div class="form-group col-md-6">
                                                            <label for="inputEmail4" class="col-form-label">Bilangan
                                                                Tanam</label>
                                                            <input type="text" name="plant_type" class="form-control"
                                                                value="<?php echo e($plantation->quantity_plant); ?> Batang" readonly>
                                                        </div>
                                                        <div class="form-group col-md-6">
                                                            <label for="inputEmail4" class="col-form-label">Tarikh
                                                                Penanaman</label>
                                                            <input type="text" name="plant_type" class="form-control"
                                                                value="<?php echo e($plantation->plant_date); ?>" readonly>
                                                        </div>
                                                        <div class="form-group col-md-12">
                                                            <label for="pdf" class="col-form-label">Muat Naik
                                                                Gambar</label>
                                                            <input type="file" name="image_tanam" class="form-control"
                                                                accept="image/" required>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-light"
                                                            data-dismiss="modal">Batal</button>
                                                        <button type="submit" class="btn btn-primary">Kemaskini</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div><!-- /.modal-content -->
                                    </div><!-- /.modal-dialog -->
                                </div><!-- /.modal -->

                                <!-- Status Tuai Modal -->
                                <div class="modal fade" id="statusTuaiModal-<?php echo e($plantation->id); ?>" tabindex="-1"
                                    role="dialog" aria-labelledby="statusModalLabel-<?php echo e($plantation->id); ?>"
                                    aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="statusModalLabel-<?php echo e($plantation->id); ?>">
                                                    Kemaskini Status <?php echo e($plantation->farm->name); ?></h5>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">

                                                Anda Pasti Mahu Kemaskini Status Penuaian <?php echo e($plantation->farm->name); ?>

                                                kepada <b>Dalam Kerja</b>?
                                                <br>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary"
                                                    data-dismiss="modal">Batal</button>
                                                <form method="POST"
                                                    action="<?php echo e(route('plantation.tuai', $plantation->id)); ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('PATCH'); ?>
                                                    <button type="submit" class="btn btn-primary">Betul</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- KemaskiniTanam modal -->
                                <div id="kemaskiniTuai-modal-<?php echo e($plantation->id); ?>" class="modal fade" tabindex="-1"
                                    role="dialog" aria-hidden="true">
                                    <div class="modal-dialog ">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title" id="editModalLabel">Kemaskini Status Tanaman
                                                </h4>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-hidden="true">×</button>
                                            </div>
                                            <div class="modal-body">
                                                <form action="<?php echo e(route('plantation.kemaskiniTuai', $plantation->id)); ?>"
                                                    method="POST" enctype="multipart/form-data">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('PUT'); ?>
                                                    <div class="form-row">
                                                        <div class="form-group col-md-12">
                                                            <label for="inputState" class="col-form-label">Nama
                                                                Kebun</label>
                                                            <input type="text" name="plant_category"
                                                                class="form-control"
                                                                value="<?php echo e($plantation->farm->name); ?>" readonly>
                                                        </div>

                                                        <div class="form-group col-md-6">
                                                            <label for="inputEmail4" class="col-form-label">Jenis
                                                                Pokok</label>
                                                            <input type="text" name="plant_type" class="form-control"
                                                                value="<?php echo e($plantation->farm->category->name); ?>" readonly>
                                                        </div>
                                                        <div class="form-group col-md-6">
                                                            <label for="inputEmail4" class="col-form-label">Nama
                                                                Pokok</label>
                                                            <input type="text" name="plant_type" class="form-control"
                                                                value="<?php echo e($plantation->plantDetail->plant_type); ?>" readonly>
                                                        </div>
                                                        <div class="form-group col-md-6">
                                                            <label for="inputEmail4" class="col-form-label">Bilangan
                                                                Tandan</label>
                                                            <input type="text" name="plant_type" class="form-control"
                                                                value="<?php echo e($plantation->quantity_plant); ?> Tandan" readonly>
                                                        </div>
                                                        <div class="form-group col-md-6">
                                                            <label for="inputEmail4" class="col-form-label">Tarikh
                                                                Penuaian</label>
                                                            <input type="text" name="plant_type" class="form-control"
                                                                value="<?php echo e($plantation->harvest_date); ?>" readonly>
                                                        </div>
                                                        <div class="form-group col-md-12">
                                                            <label for="pdf" class="col-form-label">Muat Naik
                                                                Gambar</label>
                                                            <input type="file" name="image_kait" class="form-control"
                                                                accept="image/" required>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-light"
                                                            data-dismiss="modal">Batal</button>
                                                        <button type="submit" class="btn btn-primary">Kemaskini</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div><!-- /.modal-content -->
                                    </div><!-- /.modal-dialog -->
                                </div><!-- /.modal -->

                                <!-- Delete modal -->
                                <div id="delete-modal-<?php echo e($plantation->id); ?>" class="modal fade" tabindex="-1"
                                    role="dialog" aria-hidden="true">
                                    <div class="modal-dialog ">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title" id="deleteModalLabel">Padam Maklumat Tanaman</h4>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-hidden="true">×</button>
                                            </div>
                                            <div class="modal-body">
                                                <p>Adakah anda mahu memadam maklumat ini?</p>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-light btn-sm" data-dismiss="modal">
                                                    Tidak, Batal
                                                </button>
                                                <form method="POST"
                                                    action="<?php echo e(route('plantation.destroy', $plantation->id)); ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <input type="hidden" name="plantation_id"
                                                        value="<?php echo e($plantation->id); ?>">
                                                    <button type="submit" class="btn btn-danger btn-sm">Betul,
                                                        Padam</button>
                                                </form>
                                            </div>

                                        </div>
                                    </div>
                                </div><!-- /.modal -->
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>
    <!-- end row-->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\desa-grow-farm\resources\views/plantation/index.blade.php ENDPATH**/ ?>