

<?php $__env->startSection('content'); ?>
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">Tanaman</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('plantation.index')); ?>">Tanaman</a></li>
                        <li class="breadcrumb-item active">Kemaskini Tanaman</li>
                    </ol>
                </div>
                <h4 class="page-title">Pengurusan Tanaman</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->



    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <!-- header farm detail -->
                    <div class="nav nav-pills nav-justified form-wizard-header mb-1 bg-info text-white"
                        style="padding-left:2%; padding-top:1%; padding-bottom:1%;">
                        <div class="row">
                            <div class="media">
                                <i class="uil uil-trees text-white font-weight-bold font-12 text-uppercase"></i> &nbsp;
                                <div class="media-body">
                                    <h5 class="mt-1 font-14">
                                        Maklumat Kebun
                                    </h5>
                                </div>
                            </div>
                        </div> <!-- end row -->
                    </div>
                    <!-- end header farm detail -->

                    <form role="form" method="POST" action="<?php echo e(route('plantation.update', $plantation->id)); ?>"
                        enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="id" value="<?php echo e($plantation->id); ?>">
                        <?php echo method_field('PUT'); ?>
                        <br>
                        <p class="text-muted mb-4">Sila Kemaskini Maklumat Dibawah.</p>
                        <div class="row">
                            <div class="col-12">
                                
                                <div class="form-row">
                                    <div class="form-group col-md-12">
                                        <label for="inputKebun" class="col-form-label">Nama Kebun</label>
                                        <select id="inputKebun" class="form-control" name="farm_id"
                                            onchange="updateFarmDetails()" disabled>
                                            <?php $__currentLoopData = $farms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $farm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($farm->id); ?>"
                                                    data-category="<?php echo e($farm->category->name); ?>"
                                                    data-category-id="<?php echo e($farm->category_id); ?>"
                                                    data-size="<?php echo e($farm->size); ?>"
                                                    <?php echo e($plantation->farm_id == $farm->id ? 'selected' : ''); ?>>
                                                    <?php echo e($farm->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="inputKategoriKebun" class="col-form-label">Kategori Kebun</label>
                                        <input type="text" class="form-control" id="inputKategoriKebun"
                                            name="plant_category" value="<?php echo e($plantation->farm->category->name); ?>" readonly>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="inputSaizKebun" class="col-form-label">Saiz Kebun</label>
                                        <input type="text" class="form-control" id="inputSaizKebun" name="farm_size"
                                            value="<?php echo e($plantation->farm->size); ?>" readonly>
                                    </div>
                                </div>
                            </div> <!-- end col -->
                        </div> <!-- end row -->

                        <!-- header plant detail -->
                        <div class="nav nav-pills nav-justified form-wizard-header mb-1 bg-info text-white"
                            style="padding-left:2%; padding-top:1%; padding-bottom:1%;">
                            <div class="row">
                                <div class="media">
                                    <i class="uil uil-trees text-white font-weight-bold font-12 text-uppercase"></i> &nbsp;
                                    <div class="media-body">
                                        <h5 class="mt-1 font-14">
                                            Maklumat Pokok
                                        </h5>
                                    </div>
                                </div>
                            </div> <!-- end row -->
                        </div>
                        <!-- end header plant detail -->

                        
                        <div class="row">
                            <div class="col-12">
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label for="inputNamaPokok" class="col-form-label">Nama Pokok</label>
                                        <select id="inputNamaPokok" id="plant_type" name="plant_detail_id" 
                                            class="form-control" required
                                            onchange="clearFertilizerDates(); clearPlantingDate(); updateMaturityPeriod(); updateFertilizerTypes();">
                                        </select>
                                        <input type="hidden" id="hiddenCategoryId" name="category_id">
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="inputTempohKematangan" class="col-form-label">Tempoh
                                            Kematangan (Bulan)</label>
                                        <input type="text" id="inputTempohKematangan" class="form-control"
                                            name="plant_maturity" value="<?php echo e($plantation->plantDetail->plant_maturity); ?>"
                                            readonly>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="inputTarikhPenanaman" class="col-form-label">Tarikh Penanaman</label>
                                        <input type="date" id="inputTarikhPenanaman" class="form-control"
                                            name="plant_date" value="<?php echo e($plantation->plant_date); ?>"
                                            onchange="calculateHarvestDate()">
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="inputTarikhMenuai" class="col-form-label">Tarikh Menuai</label>
                                        <input type="date" id="inputTarikhMenuai" class="form-control"
                                            name="harvest_date" value="<?php echo e($plantation->harvest_date); ?>" readonly>
                                    </div>
                                </div>
                            </div> <!-- end col -->
                        </div> <!-- end row -->
                        

                        <!-- header pekerja detail -->
                        <div class="nav nav-pills nav-justified form-wizard-header mb-1 bg-info text-white"
                            style="padding-left:2%; padding-top:1%; padding-bottom:1%;">
                            <div class="row">
                                <div class="media">
                                    <i class="uil uil-trees text-white font-weight-bold font-12 text-uppercase"></i> &nbsp;
                                    <div class="media-body">
                                        <h5 class="mt-1 font-14">
                                            Serah Tugas
                                        </h5>
                                    </div>
                                </div>
                            </div> <!-- end row -->
                        </div>
                        <!-- end header pekerja detail -->

                        
                        <div class="row">
                            <div class="col-12">
                                <div class="form-row">
                                    <div class="form-group col-md-12">
                                        <label for="inputBilanganPokok" class="col-form-label">Bilangan Tanam
                                            (Batang)</label>
                                        <input type="number" name="quantity_plant" class="form-control"
                                            id="inputBilanganPokok" value="<?php echo e($plantation->quantity_plant); ?>">
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="penanam_id" class="col-form-label">Penanam</label>
                                        <select id="penanam_id" name="penanam_id" class="form-control">
                                            <option value="">Sila Pilih</option>
                                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($user->job_type == 'Penanam'): ?>
                                                    <!-- Only include Penanam users -->
                                                    <option value="<?php echo e($user->id); ?>"
                                                        <?php echo e($user->id == $plantation->penanam_id ? 'selected' : ''); ?>>
                                                        <?php echo e($user->name); ?>

                                                    </option>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="pengait_id" class="col-form-label">Pengait</label>
                                        <select id="pengait_id" name="pengait_id" class="form-control">
                                            <option value="">Sila Pilih</option>
                                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($user->job_type == 'Pengait'): ?>
                                                    <!-- Only include Pengait users -->
                                                    <option value="<?php echo e($user->id); ?>"
                                                        <?php echo e($user->id == $plantation->pengait_id ? 'selected' : ''); ?>>
                                                        <?php echo e($user->name); ?>

                                                    </option>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </select>
                                    </div>

                                </div>


                            </div> <!-- end col -->
                        </div> <!-- end row -->
                        

                        <!-- header tumbesaran detail -->
                        <div class="nav nav-pills nav-justified form-wizard-header mb-1 bg-info text-white"
                            style="padding-left:2%; padding-top:1%; padding-bottom:1%;">
                            <div class="row">
                                <div class="media">
                                    <i class="uil uil-trees text-white font-weight-bold font-12 text-uppercase"></i> &nbsp;
                                    <div class="media-body">
                                        <h5 class="mt-1 font-14">
                                            Maklumat Baja Tumbesaran
                                        </h5>
                                    </div>
                                </div>
                            </div> <!-- end row -->
                        </div>
                        <!-- end header tumbesaran detail -->

                        
                        <div class="row">
                            <div class="col-12">
                                <p class="text-muted font-14">Maklumat Baja 1 (Tumbesaran)</p>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label for="inputKategoriBajaTumbesaran" class="col-form-label">Kategori
                                            Baja</label>
                                        <select id="inputKategoriBajaTumbesaran" class="form-control"
                                            name="fertilizer_type" disabled>
                                            <!-- Options will be populated by JavaScript -->
                                        </select>
                                    </div>


                                    <div class="form-group col-md-6">
                                        <label for="inputNamaBajaTumbesaran" class="col-form-label">Nama Baja</label>
                                        <select id="inputNamaBajaTumbesaran" class="form-control" name="tumbesaran_id">
                                            <option value="">Sila Pilih</option>
                                        </select>

                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="inputQuantitiBajaTumbesaran" class="col-form-label">Quantiti
                                            Baja</label>
                                        <input type ="number" name="amount" class="form-control"
                                            id="inputQuantitiBajaTumbesaran" readonly>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="inputJenisKuantitiTumbesaran" class="col-form-label">Jenis
                                            Kuantiti</label>
                                        <input type ="text" name="amount_type" class="form-control"
                                            id="inputJenisKuantitiTumbesaran" readonly>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="inputTempohMembajaTumbesaran" class="col-form-label">Tempoh
                                            Membaja</label>
                                        <input type ="text" name="duration" class="form-control"
                                            id="inputTempohMembajaTumbesaran" readonly>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="inputKekerapanBajaTumbesaran" class="col-form-label">Kekerapan
                                            Baja(1 Bulan)</label>
                                        <input type ="number" name="frequency" class="form-control"
                                            id="inputKekerapanBajaTumbesaran" readonly>
                                    </div>
                                    <div class="form-group col-md-12">
                                        <label for="tumbesaranDates" class="col-form-label">Tarikh Baja</label>
                                        <input type="text" id="tumbesaranDates" name="tumbesaran_date"
                                            class="form-control" value="<?php echo e($plantation->tumbesaran_date); ?>">
                                    </div>

                                </div>
                            </div>
                        </div>
                        

                        <!-- Maklumat Baja Akar -->
                        <div class="nav nav-pills nav-justified form-wizard-header mb-1 bg-info text-white"
                            style="padding-left:2%; padding-top:1%; padding-bottom:1%;">
                            <div class="row">
                                <div class="media">
                                    <i class="uil uil-trees text-white font-weight-bold font-12 text-uppercase"></i> &nbsp;
                                    <div class="media-body">
                                        <h5 class="mt-1 font-14">Maklumat Baja Akar</h5>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <p class="text-muted font-14">Maklumat Baja 2 (Akar)</p>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label for="inputKategoriBajaAkar" class="col-form-label">Kategori Baja</label>
                                        <select id="inputKategoriBajaAkar" class="form-control"
                                            name="fertilizer_type_akar" disabled>
                                            <!-- Options will be populated by JavaScript -->
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="inputNamaBajaAkar" class="col-form-label">Nama Baja</label>
                                        <select id="inputNamaBajaAkar" class="form-control" name="akar_id">
                                            <option value="">Sila Pilih</option>
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="inputQuantitiBajaAkar" class="col-form-label">Quantiti Baja</label>
                                        <input type="number" name="amount_akar" class="form-control"
                                            id="inputQuantitiBajaAkar" readonly>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="inputJenisKuantitiAkar" class="col-form-label">Jenis Kuantiti</label>
                                        <input type="text" name="amount_type_akar" class="form-control"
                                            id="inputJenisKuantitiAkar" readonly>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="inputTempohMembajaAkar" class="col-form-label">Tempoh Membaja</label>
                                        <input type="text" name="duration_akar" class="form-control"
                                            id="inputTempohMembajaAkar" readonly>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="inputKekerapanBajaAkar" class="col-form-label">Kekerapan Baja (1
                                            Bulan)</label>
                                        <input type="number" name="frequency_akar" class="form-control"
                                            id="inputKekerapanBajaAkar" readonly>
                                    </div>
                                    <div class="form-group col-md-12">
                                        <label for="akarDates" class="col-form-label">Tarikh Baja</label>
                                        <input type="text" id="akarDates" name="akar_date" class="form-control"
                                            value="<?php echo e($plantation->akar_date); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Maklumat Baja Buah -->
                        <div class="nav nav-pills nav-justified form-wizard-header mb-1 bg-info text-white"
                            style="padding-left:2%; padding-top:1%; padding-bottom:1%;">
                            <div class="row">
                                <div class="media">
                                    <i class="uil uil-trees text-white font-weight-bold font-12 text-uppercase"></i> &nbsp;
                                    <div class="media-body">
                                        <h5 class="mt-1 font-14">Maklumat Baja Buah</h5>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <p class="text-muted font-14">Maklumat Baja 3 (Buah)</p>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label for="inputKategoriBajaBuah" class="col-form-label">Kategori Baja</label>
                                        <select id="inputKategoriBajaBuah" class="form-control"
                                            name="fertilizer_type_buah" disabled>
                                            <!-- Options will be populated by JavaScript -->
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="inputNamaBajaBuah" class="col-form-label">Nama Baja</label>
                                        <select id="inputNamaBajaBuah" class="form-control" name="buah_id">
                                            <option value="">Sila Pilih</option>
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="inputQuantitiBajaBuah" class="col-form-label">Quantiti Baja</label>
                                        <input type="number" name="amount_buah" class="form-control"
                                            id="inputQuantitiBajaBuah" readonly>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="inputJenisKuantitiBuah" class="col-form-label">Jenis Kuantiti</label>
                                        <input type="text" name="amount_type_buah" class="form-control"
                                            id="inputJenisKuantitiBuah" readonly>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="inputTempohMembajaBuah" class="col-form-label">Tempoh Membaja</label>
                                        <input type="text" name="duration_buah" class="form-control"
                                            id="inputTempohMembajaBuah" readonly>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="inputKekerapanBajaBuah" class="col-form-label">Kekerapan Baja (1
                                            Bulan)</label>
                                        <input type="number" name="frequency_buah" class="form-control"
                                            id="inputKekerapanBajaBuah" readonly>
                                    </div>
                                    <div class="form-group col-md-12">
                                        <label for="buahDates" class="col-form-label">Tarikh Baja</label>
                                        <input type="text" id="buahDates" name="buah_date" class="form-control"
                                            value="<?php echo e($plantation->buah_date); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Maklumat Baja Matang -->
                        <div class="nav nav-pills nav-justified form-wizard-header mb-1 bg-info text-white"
                            style="padding-left:2%; padding-top:1%; padding-bottom:1%;">
                            <div class="row">
                                <div class="media">
                                    <i class="uil uil-trees text-white font-weight-bold font-12 text-uppercase"></i> &nbsp;
                                    <div class="media-body">
                                        <h5 class="mt-1 font-14">Maklumat Baja Matang</h5>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <p class="text-muted font-14">Maklumat Baja 4 (Matang)</p>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label for="inputKategoriBajaMatang" class="col-form-label">Kategori Baja</label>
                                        <select id="inputKategoriBajaMatang" class="form-control"
                                            name="fertilizer_type_matang" disabled>
                                            <!-- Options will be populated by JavaScript -->
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="inputNamaBajaMatang" class="col-form-label">Nama Baja</label>
                                        <select id="inputNamaBajaMatang" class="form-control" name="matang_id">
                                            <option value="">Sila Pilih</option>
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="inputQuantitiBajaMatang" class="col-form-label">Quantiti Baja</label>
                                        <input type="number" name="amount_matang" class="form-control"
                                            id="inputQuantitiBajaMatang" readonly>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="inputJenisKuantitiMatang" class="col-form-label">Jenis
                                            Kuantiti</label>
                                        <input type="text" name="amount_type_matang" class="form-control"
                                            id="inputJenisKuantitiMatang" readonly>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="inputTempohMembajaMatang" class="col-form-label">Tempoh
                                            Membaja</label>
                                        <input type="text" name="duration_matang" class="form-control"
                                            id="inputTempohMembajaMatang" readonly>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="inputKekerapanBajaMatang" class="col-form-label">Kekerapan Baja (1
                                            Bulan)</label>
                                        <input type="number" name="frequency_matang" class="form-control"
                                            id="inputKekerapanBajaMatang" readonly>
                                    </div>
                                    <div class="form-group col-md-12">
                                        <label for="matangDates" class="col-form-label">Tarikh Baja</label>
                                        <input type="text" id="matangDates" name="matang_date" class="form-control"
                                            value="<?php echo e($plantation->matang_date); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="text-center mt-2">
                            <button type="button" onclick="history.back()" class="btn btn-light mr-3">Batal</button>
                            <button type="submit" class="btn btn-info">Kemaskini</button>
                        </div>
                    </form>
                </div> <!-- end card-body -->
            </div> <!-- end card-->
        </div> <!-- end col -->
    </div>


    <script>
        const plantDetails = <?php echo json_encode($plantDetails, 15, 512) ?>;
        const fertilizers = <?php echo json_encode($fertilizers, 15, 512) ?>;
        const fertilizerCategories = <?php echo json_encode($fertilizerCategories, 15, 512) ?>;

        // Function to update farm details
        function updateFarmDetails() {
            const farmSelect = document.getElementById('inputKebun');
            const selectedOption = farmSelect.options[farmSelect.selectedIndex];

            // Get the category and size from the selected option's data attributes
            const category = selectedOption.getAttribute('data-category');
            const categoryId = selectedOption.getAttribute('data-category-id');
            const size = selectedOption.getAttribute('data-size');

            // Update the category and size input fields
            document.getElementById('inputKategoriKebun').value = category || '';
            document.getElementById('inputSaizKebun').value = size || '';
            document.getElementById('hiddenCategoryId').value = categoryId || '';

            // Call the function to update Nama Pokok
            updatePlantTypes(categoryId);
        }

        // Function to update plant types
        function updatePlantTypes(categoryId) {
            const plantSelect = document.getElementById('inputNamaPokok');

            // Clear previous options
            plantSelect.innerHTML = '<option value="">Sila Pilih</option>';

            // Check if categoryId is valid and if plant details exist for it
            if (categoryId && plantDetails[categoryId]) {
                plantDetails[categoryId].forEach(plant => {
                    const option = document.createElement('option');
                    option.value = plant.id; // Use plant ID as value
                    option.textContent = plant.plant_type; // Display plant type as text
                    option.setAttribute('data-maturity', plant.plant_maturity); // Store maturity as data attribute

                    // Select the plant type if it matches the plantation's plant_detail_id
                    if (plant.id == '<?php echo e($plantation->plant_detail_id); ?>') {
                        option.selected = true;
                    }

                    plantSelect.appendChild(option);
                });
            } else {
                console.warn('No plant details found for the selected category.');
            }

            // Call updateFertilizerTypes function after plant types are populated
            updateFertilizerTypes('<?php echo e($plantation->plant_detail_id); ?>');
        }

        // Function to update maturity period
        function updateMaturityPeriod() {
            const plantSelect = document.getElementById('inputNamaPokok');
            const selectedOption = plantSelect.options[plantSelect.selectedIndex];

            // Retrieve maturity from data attribute
            const maturity = selectedOption.getAttribute('data-maturity');

            // Update maturity input field
            document.getElementById('inputTempohKematangan').value = maturity || '';
            // Trigger harvest date calculation
            calculateHarvestDate();
        }

        // Function to calculate harvest date
        function calculateHarvestDate() {
            const plantingDateInput = document.getElementById('inputTarikhPenanaman');
            const maturityInput = document.getElementById('inputTempohKematangan');
            const harvestDateInput = document.getElementById('inputTarikhMenuai');

            // Get planting date and maturity period
            const plantingDate = plantingDateInput.value; // Format: YYYY-MM-DD
            const maturityPeriod = parseInt(maturityInput.value); // Maturity in months

            if (plantingDate && !isNaN(maturityPeriod)) {
                // Convert planting date to Date object
                const plantingDateObj = new Date(plantingDate);

                // Add maturity period (months) to planting date
                plantingDateObj.setMonth(plantingDateObj.getMonth() + maturityPeriod);

                // Format new date as YYYY-MM-DD
                const harvestDate = plantingDateObj.toISOString().split('T')[0];

                // Update the harvest date field
                harvestDateInput.value = harvestDate;

                // Validate both dates
                validateDates(plantingDate, harvestDate);
            } else {
                // Clear harvest date if inputs are invalid
                harvestDateInput.value = '';
            }
        }

        function clearPlantingDate() {
            const plantingDateInput = document.getElementById('inputTarikhPenanaman');
            const harvestDateInput = document.getElementById('inputTarikhMenuai');

            // Clear the planting date and harvest date fields
            plantingDateInput.value = '';
            harvestDateInput.value = '';
        }

        function clearFertilizerDates() {
            // Clear Tumbesaran dates
            const tumbesaranDates = document.getElementById('tumbesaranDates');
            if (tumbesaranDates._flatpickr) {
                tumbesaranDates._flatpickr.clear(); // Clear Flatpickr instance
            }
            tumbesaranDates.value = ''; // Clear input value

            // Clear Akar dates
            const akarDates = document.getElementById('akarDates');
            if (akarDates._flatpickr) {
                akarDates._flatpickr.clear(); // Clear Flatpickr instance
            }
            akarDates.value = ''; // Clear input value

            // Clear Buah dates
            const buahDates = document.getElementById('buahDates');
            if (buahDates._flatpickr) {
                buahDates._flatpickr.clear(); // Clear Flatpickr instance
            }
            buahDates.value = ''; // Clear input value

            // Clear Matang dates
            const matangDates = document.getElementById('matangDates');
            if (matangDates._flatpickr) {
                matangDates._flatpickr.clear(); // Clear Flatpickr instance
            }
            matangDates.value = ''; // Clear input value
        }

        // Add event listener to recalculate when planting date changes
        document.getElementById('inputTarikhPenanaman').addEventListener('change', calculateHarvestDate);

        // Function to update fertilizer types
        function updateFertilizerTypes(plantDetailId) {
            const fertilizerTypeSelectTumbesaran = document.getElementById('inputKategoriBajaTumbesaran');
            const fertilizerTypeSelectAkar = document.getElementById('inputKategoriBajaAkar');
            const fertilizerTypeSelectBuah = document.getElementById('inputKategoriBajaBuah');
            const fertilizerTypeSelectMatang = document.getElementById('inputKategoriBajaMatang');

            // Clear previous options
            fertilizerTypeSelectTumbesaran.innerHTML = '<option value="">Sila Pilih</option>';
            fertilizerTypeSelectAkar.innerHTML = '<option value="">Sila Pilih</option>';
            fertilizerTypeSelectBuah.innerHTML = '<option value="">Sila Pilih</option>';
            fertilizerTypeSelectMatang.innerHTML = '<option value="">Sila Pilih</option>';

            // Ensure fertilizers exist for the selected plantDetailId
            if (plantDetailId && fertilizers[plantDetailId]) {
                const fertilizerList = fertilizers[plantDetailId];

                // Filter fertilizers for each category
                const tumbesaranFertilizers = fertilizerList.filter(
                    fertilizer => fertilizer.fertilizer_detail.fertilizer_category_id == 1 // Tumbesaran
                );
                const akarFertilizers = fertilizerList.filter(
                    fertilizer => fertilizer.fertilizer_detail.fertilizer_category_id == 2 // Akar
                );
                const buahFertilizers = fertilizerList.filter(
                    fertilizer => fertilizer.fertilizer_detail.fertilizer_category_id == 3 // Buah
                );
                const matangFertilizers = fertilizerList.filter(
                    fertilizer => fertilizer.fertilizer_detail.fertilizer_category_id == 4 // Matang
                );

                // Populate Tumbesaran category
                if (tumbesaranFertilizers.length > 0) {
                    const category = fertilizerCategories.find(cat => cat.id == 1); // Tumbesaran
                    if (category) {
                        const option = document.createElement('option');
                        option.value = category.id;
                        option.textContent = category.name;
                        fertilizerTypeSelectTumbesaran.appendChild(option);
                    }
                    fertilizerTypeSelectTumbesaran.value = 1; // Automatically select Tumbesaran
                }

                // Populate Akar category
                if (akarFertilizers.length > 0) {
                    const category = fertilizerCategories.find(cat => cat.id == 2); // Akar
                    if (category) {
                        const option = document.createElement('option');
                        option.value = category.id;
                        option.textContent = category.name;
                        fertilizerTypeSelectAkar.appendChild(option);
                    }
                    fertilizerTypeSelectAkar.value = 2; // Automatically select Akar
                }

                // Populate Buah category
                if (buahFertilizers.length > 0) {
                    const category = fertilizerCategories.find(cat => cat.id == 3); // Buah
                    if (category) {
                        const option = document.createElement('option');
                        option.value = category.id;
                        option.textContent = category.name;
                        fertilizerTypeSelectBuah.appendChild(option);
                    }
                    fertilizerTypeSelectBuah.value = 3; // Automatically select Buah
                }

                // Populate Matang category
                if (matangFertilizers.length > 0) {
                    const category = fertilizerCategories.find(cat => cat.id == 4); // Matang
                    if (category) {
                        const option = document.createElement('option');
                        option.value = category.id;
                        option.textContent = category.name;
                        fertilizerTypeSelectMatang.appendChild(option);
                    }
                    fertilizerTypeSelectMatang.value = 4; // Automatically select Matang
                }
            } else {
                console.warn('No fertilizers found for the selected plant detail ID:', plantDetailId);
            }

            // Update fertilizer names for all categories
            updateTumbesaranNames();
            updateAkarNames();
            updateBuahNames();
            updateMatangNames();
        }

        // Function to update fertilizer names for Tumbesaran
        function updateTumbesaranNames() {
            const plantDetailId = document.getElementById('inputNamaPokok').value;
            const fertilizerCategoryId = document.getElementById('inputKategoriBajaTumbesaran').value;
            const fertilizerNameSelect = document.getElementById('inputNamaBajaTumbesaran');

            fertilizerNameSelect.innerHTML = '<option value="">Sila Pilih</option>'; // Clear previous options

            if (plantDetailId && fertilizerCategoryId && fertilizers[plantDetailId]) {
                const fertilizerList = fertilizers[plantDetailId].filter(
                    fertilizer => fertilizer.fertilizer_detail.fertilizer_category_id == fertilizerCategoryId
                );

                // Populate the select with fertilizer names
                fertilizerList.forEach(fertilizer => {
                    const option = document.createElement('option');
                    option.value = fertilizer.fertilizer_detail.id; // Fertilizer ID
                    option.textContent = fertilizer.fertilizer_detail.fertilizer_name; // Fertilizer name
                    option.dataset.amount = fertilizer.amount; // Additional data
                    option.dataset.amountType = fertilizer.amount_type;
                    option.dataset.duration = fertilizer.duration;
                    option.dataset.frequency = fertilizer.frequency;

                    // Select the fertilizer if it matches the plantation's tumbesaran_id
                    if (option.value == '<?php echo e($plantation->tumbesaran_id); ?>') {
                        option.selected = true;
                    }

                    fertilizerNameSelect.appendChild(option);
                });
                fertilizerNameSelect.dispatchEvent(new Event('change'));
            }
        }

        // Function to update fertilizer types for Akar
        function updateAkarNames() {
            const plantDetailId = document.getElementById('inputNamaPokok').value;
            const fertilizerCategoryId = document.getElementById('inputKategoriBajaAkar').value;
            const fertilizerNameSelect = document.getElementById('inputNamaBajaAkar');

            fertilizerNameSelect.innerHTML = '<option value="">Sila Pilih</option>'; // Clear previous options

            if (plantDetailId && fertilizerCategoryId && fertilizers[plantDetailId]) {
                const fertilizerList = fertilizers[plantDetailId].filter(
                    fertilizer => fertilizer.fertilizer_detail.fertilizer_category_id == fertilizerCategoryId
                );

                // Populate the select with fertilizer names
                fertilizerList.forEach(fertilizer => {
                    const option = document.createElement('option');
                    option.value = fertilizer.fertilizer_detail.id; // Fertilizer ID
                    option.textContent = fertilizer.fertilizer_detail.fertilizer_name; // Fertilizer name
                    option.dataset.amount = fertilizer.amount; // Additional data
                    option.dataset.amountType = fertilizer.amount_type;
                    option.dataset.duration = fertilizer.duration;
                    option.dataset.frequency = fertilizer.frequency;

                    // Select the fertilizer if it matches the plantation's akar_id
                    if (option.value == '<?php echo e($plantation->akar_id); ?>') {
                        option.selected = true;
                    }

                    fertilizerNameSelect.appendChild(option);
                });
                fertilizerNameSelect.dispatchEvent(new Event('change'));
            }
        }

        // Function to update fertilizer types for Buah
        function updateBuahNames() {
            const plantDetailId = document.getElementById('inputNamaPokok').value;
            const fertilizerCategoryId = document.getElementById('inputKategoriBajaBuah').value;
            const fertilizerNameSelect = document.getElementById('inputNamaBajaBuah');

            fertilizerNameSelect.innerHTML = '<option value="">Sila Pilih</option>'; // Clear previous options

            if (plantDetailId && fertilizerCategoryId && fertilizers[plantDetailId]) {
                const fertilizerList = fertilizers[plantDetailId].filter(
                    fertilizer => fertilizer.fertilizer_detail.fertilizer_category_id == fertilizerCategoryId
                );

                // Populate the select with fertilizer names
                fertilizerList.forEach(fertilizer => {
                    const option = document.createElement('option');
                    option.value = fertilizer.fertilizer_detail.id; // Fertilizer ID
                    option.textContent = fertilizer.fertilizer_detail.fertilizer_name; // Fertilizer name
                    option.dataset.amount = fertilizer.amount; // Additional data
                    option.dataset.amountType = fertilizer.amount_type;
                    option.dataset.duration = fertilizer.duration;
                    option.dataset.frequency = fertilizer.frequency;

                    // Select the fertilizer if it matches the plantation's buah_id
                    if (option.value == '<?php echo e($plantation->buah_id); ?>') {
                        option.selected = true;
                    }

                    fertilizerNameSelect.appendChild(option);
                });
                fertilizerNameSelect.dispatchEvent(new Event('change'));
            }
        }

        // Function to update fertilizer types for Matang
        function updateMatangNames() {
            const plantDetailId = document.getElementById('inputNamaPokok').value;
            const fertilizerCategoryId = document.getElementById('inputKategoriBajaMatang').value;
            const fertilizerNameSelect = document.getElementById('inputNamaBajaMatang');

            fertilizerNameSelect.innerHTML = '<option value="">Sila Pilih</option>'; // Clear previous options

            if (plantDetailId && fertilizerCategoryId && fertilizers[plantDetailId]) {
                const fertilizerList = fertilizers[plantDetailId].filter(
                    fertilizer => fertilizer.fertilizer_detail.fertilizer_category_id == fertilizerCategoryId
                );

                // Populate the select with fertilizer names
                fertilizerList.forEach(fertilizer => {
                    const option = document.createElement('option');
                    option.value = fertilizer.fertilizer_detail.id; // Fertilizer ID
                    option.textContent = fertilizer.fertilizer_detail.fertilizer_name; // Fertilizer name
                    option.dataset.amount = fertilizer.amount; // Additional data
                    option.dataset.amountType = fertilizer.amount_type;
                    option.dataset.duration = fertilizer.duration;
                    option.dataset.frequency = fertilizer.frequency;

                    // Select the fertilizer if it matches the plantation's matang_id
                    if (option.value == '<?php echo e($plantation->matang_id); ?>') {
                        option.selected = true;
                    }

                    fertilizerNameSelect.appendChild(option);
                });
                fertilizerNameSelect.dispatchEvent(new Event('change'));
            }
        }



        // Event listeners for dropdown changes
        document.getElementById('inputNamaPokok').addEventListener('change', function() {
            const plantDetailId = this.value; // Get the selected plant detail ID
            updateFertilizerTypes(plantDetailId); // Update fertilizer types
        });

        document.getElementById('inputKategoriBajaTumbesaran').addEventListener('change', function() {
            updateTumbesaranNames(); // Trigger fertilizer name update on category selection
        });

        document.getElementById('inputKategoriBajaAkar').addEventListener('change', function() {
            updateAkarNames(); // Trigger fertilizer name update for Akar
        });

        document.getElementById('inputKategoriBajaBuah').addEventListener('change', function() {
            updateBuahNames(); // Trigger fertilizer name update for Buah
        });

        document.getElementById('inputKategoriBajaMatang').addEventListener('change', function() {
            updateMatangNames(); // Trigger fertilizer name update for Matang
        });

        document.getElementById('inputNamaBajaTumbesaran').addEventListener('change', function() {
            const selectedOption = this.options[this.selectedIndex];
            document.getElementById('inputQuantitiBajaTumbesaran').value = selectedOption.dataset.amount || '';
            document.getElementById('inputJenisKuantitiTumbesaran').value = selectedOption.dataset.amountType || '';
            document.getElementById('inputTempohMembajaTumbesaran').value = selectedOption.dataset.duration || '';
            document.getElementById('inputKekerapanBajaTumbesaran').value = selectedOption.dataset.frequency || '';
        });

        document.getElementById('inputNamaBajaAkar').addEventListener('change', function() {
            const selectedOption = this.options[this.selectedIndex];
            document.getElementById('inputQuantitiBajaAkar').value = selectedOption.dataset.amount || '';
            document.getElementById('inputJenisKuantitiAkar').value = selectedOption.dataset.amountType || '';
            document.getElementById('inputTempohMembajaAkar').value = selectedOption.dataset.duration || '';
            document.getElementById('inputKekerapanBajaAkar').value = selectedOption.dataset.frequency || '';
        });

        document.getElementById('inputNamaBajaBuah').addEventListener('change', function() {
            const selectedOption = this.options[this.selectedIndex];
            document.getElementById('inputQuantitiBajaBuah').value = selectedOption.dataset.amount || '';
            document.getElementById('inputJenisKuantitiBuah').value = selectedOption.dataset.amountType || '';
            document.getElementById('inputTempohMembajaBuah').value = selectedOption.dataset.duration || '';
            document.getElementById('inputKekerapanBajaBuah').value = selectedOption.dataset.frequency || '';
        });

        document.getElementById('inputNamaBajaMatang').addEventListener('change', function() {
            const selectedOption = this.options[this.selectedIndex];
            document.getElementById('inputQuantitiBajaMatang').value = selectedOption.dataset.amount || '';
            document.getElementById('inputJenisKuantitiMatang').value = selectedOption.dataset.amountType || '';
            document.getElementById('inputTempohMembajaMatang').value = selectedOption.dataset.duration || '';
            document.getElementById('inputKekerapanBajaMatang').value = selectedOption.dataset.frequency || '';
        });

        // Initialize the form when the page loads
        document.addEventListener('DOMContentLoaded', function() {
            // Pre-fill fields based on the selected farm
            updateFarmDetails();
            // Pre-fill maturity and harvest date if plant is already selected
            updateMaturityPeriod();
            // Pre-fill fertilizer details
            updateFertilizerTypes('<?php echo e($plantation->plant_detail_id); ?>');
        });
    </script>




    <script>
        
        document.addEventListener('DOMContentLoaded', function() {
            flatpickr("#matangDates", {
                mode: "multiple", // Enables multi-date selection
                dateFormat: "Y-m-d", // Format of the dates
                defaultDate: [], // Optional: Prepopulate dates
                allowInput: true,
                locale: {
                    firstDayOfWeek: 1 // Start the week on Monday
                }
            });

            flatpickr("#buahDates", {
                mode: "multiple",
                dateFormat: "Y-m-d",
                defaultDate: [],
                allowInput: true,
                locale: {
                    firstDayOfWeek: 1
                }
            });

            flatpickr("#tumbesaranDates", {
                mode: "multiple",
                dateFormat: "Y-m-d",
                defaultDate: [],
                allowInput: true,
                locale: {
                    firstDayOfWeek: 1
                }
            });

            flatpickr("#akarDates", {
                mode: "multiple",
                dateFormat: "Y-m-d",
                defaultDate: [],
                allowInput: true,
                locale: {
                    firstDayOfWeek: 1
                }
            });
        });
    </script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\desa-grow-farm\resources\views/plantation/edit.blade.php ENDPATH**/ ?>