

<?php $__env->startSection('content'); ?>
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('damage.index')); ?>">Aduan</a></li>
                        <li class="breadcrumb-item active">Serah Tugas</li>
                    </ol>
                </div>
                <h4 class="page-title">Pengurusan Tugas</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    <h4 class="header-title">Serah Tugas</h4>
                    <br>

                    <div class="nav nav-pills nav-justified form-wizard-header mb-1 bg-info text-white"
                        style="padding-left:2%; padding-top:1%; padding-bottom:1%;">
                        <div class="row">
                            <!-- header plant detail -->
                            <div class="media">
                                <i class="uil uil-trees text-white font-weight-bold font-12 text-uppercase"></i> &nbsp;
                                <div class="media-body">
                                    <h5 class="mt-1 font-14">
                                        Maklumat Aduan
                                    </h5>
                                </div>
                            </div>
                            <!-- end header plant detail -->
                        </div> <!-- end row -->
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label for="inputNamaKebun" class="col-form-label">Nama Kebun</label>
                            <input type="text" class="form-control" id="inputNamaKebun"
                                value="<?php echo e($damage->plantation->farm->name); ?>" readonly>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="inputJenisKebun" class="col-form-label">Jenis Kebun</label>
                            <input type="text" class="form-control" name="plant_detail_id" id="inputJenisKebun"
                                value="<?php echo e($damage->plantation->plantDetail->plant_type); ?>" readonly>
                        </div>
                        <input type="hidden" id="inputPlantDetailId" value="<?php echo e($damage->plantation->plant_detail_id); ?>">
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label for="inputPengadu" class="col-form-label">Nama Pengadu</label>
                            <input type="text" class="form-control" id="inputPengadu" value="<?php echo e($damage->worker->name); ?>"
                                readonly>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="inputJenisAduan" class="col-form-label">Jenis Aduan</label>
                            <input type="text" class="form-control" id="inputJenisAduan"
                                value="<?php echo e($damage->damage_category); ?>" readonly>
                        </div>
                        <div class="form-group col-md-12">
                            <label for="inputKeteranganAduan" class="col-form-label">Keterangan Aduan</label>
                            <textarea class="form-control" name="address" id="example-textarea" rows="5" readonly><?php echo e($damage->damage_description); ?> </textarea>
                        </div>
                    </div>



                    <div class="nav nav-pills nav-justified form-wizard-header mb-1 bg-info text-white"
                        style="padding-left:2%; padding-top:1%; padding-bottom:1%;">
                        <div class="row">
                            <!-- header plant detail -->
                            <div class="media">
                                <i class="uil uil-trees text-white font-weight-bold font-12 text-uppercase"></i> &nbsp;
                                <div class="media-body">
                                    <h5 class="mt-1 font-14">
                                        Maklumat Penyelesaian
                                    </h5>
                                </div>
                            </div>
                            <!-- end header plant detail -->
                        </div> <!-- end row -->
                    </div>
                    <form action="<?php echo e(route('damage.update', $damage->id)); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="inputTarikhPenyelesaian" class="col-form-label">Tarikh Tugasan</label>
                                <input class="form-control" id="example-date" type="date" name="assign_date">
                            </div>
                            <div class="form-group col-md-6">
                                <label for="inputKategoriPenyelesaian" class="col-form-label">Kategori Penyesaian</label>
                                <select id="inputKategoriPenyelesaian" class="form-control" name="solution_category"
                                    required>
                                    <option selected>Sila Pilih</option>
                                    <?php $__currentLoopData = $solutionCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category); ?>"><?php echo e($category); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        <div id="sectionTuanKebun" class="form-group" style="display: none;">
                            <label for="project-overview">Keterangan Penyelesaian</label>
                            <textarea class="form-control" id="project-overview" name="solution_description" rows="5"
                                placeholder="Eg: Letak penghadang dekat sekeliling pokok"></textarea>
                        </div>

                        <div id="sectionMeracun" class="form-row" style="display: none;">
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="inputKategoriRacun" class="col-form-label">Jenis Racun</label>
                                    <select id="inputKategoriRacun" name="pest_category_id" class="form-control" onchange="updateNamaRacun()">
                                        <option value="">Sila Pilih</option>
                                        <?php $__currentLoopData = $pestControls->where('plant_detail_id', $damage->plantation->plant_detail_id)->groupBy('pestControlDetail.pestCategory.id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoryId => $pestControlsGroup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($categoryId); ?>">
                                                <?php echo e($pestControlsGroup->first()->pestControlDetail->pestCategory->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="inputNamaRacun" class="col-form-label">Nama Racun</label>
                                    <select id="inputNamaRacun" name="pest_id" class="form-control">
                                        <option value="">Sila Pilih</option>
                                        <!-- Options will be populated by JavaScript -->
                                    </select>
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="inputQuantitiRacun" class="col-form-label">Quantiti Racun</label>
                                    <input type="number" name="amount" class="form-control" id="inputQuantitiRacun">
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="inputJenisKuantiti" class="col-form-label">Jenis Kuantiti</label>
                                    <input type="text" name="amount_type" class="form-control"
                                        id="inputJenisKuantiti">

                                </div>
                                <div class="form-group col-md-12">
                                    <label for="inputKeteranganRacun">Keterangan</label>
                                    <textarea class="form-control" name="description" id="inputKeteranganRacun" rows="5"></textarea>
                                </div>
                            </div>
                        </div>



                        <div class="text-center mt-2">
                            <button type="button" onclick="history.back()" class="btn btn-light mr-3">Batal</button>
                            <button type="submit" class="btn btn-info">Simpan</button>
                        </div>
                    </form>
                </div><!-- end card-body-->
            </div><!-- end card-->
        </div><!-- end col-->
    </div> <!-- end row-->



<script>
    const pestControls = <?php echo json_encode($pestControls, 15, 512) ?>;

function updateNamaRacun() {
    const kategoriRacunSelect = document.getElementById('inputKategoriRacun');
    const namaRacunSelect = document.getElementById('inputNamaRacun');
    const selectedCategoryId = kategoriRacunSelect.value;
    const selectedPlantDetailId = document.getElementById('inputPlantDetailId').value; // Get the plant_detail_id

    // Clear previous options
    namaRacunSelect.innerHTML = '<option value="">Sila Pilih</option>';

    if (selectedCategoryId && selectedPlantDetailId) {
        // Filter pest controls that match the selected category ID and plant_detail_id
        const matchingPests = pestControls.filter(
            pestControl =>
                pestControl.pest_control_detail &&
                pestControl.pest_control_detail.pest_category &&
                pestControl.pest_control_detail.pest_category.id == selectedCategoryId &&
                pestControl.plant_detail_id == selectedPlantDetailId // Check for plant_detail_id
        );

        // Populate the pest name dropdown
        matchingPests.forEach(pestControl => {
            const option = document.createElement('option');
            option.value = pestControl.id; // Use pest_control_id
            option.textContent = pestControl.pest_control_detail.pest_name || 'Unknown Name';
            option.dataset.amount = pestControl.amount; // Add amount data
            option.dataset.amount_type = pestControl.amount_type; // Add amount type data
            option.dataset.description = pestControl.description; // Add description data
            namaRacunSelect.appendChild(option);
        });
    }
}

// Attach event listener
document.getElementById('inputKategoriRacun').addEventListener('change', updateNamaRacun);

// Populate fields when "Nama Racun" is selected
document.getElementById('inputNamaRacun').addEventListener('change', function() {
    const selectedOption = this.options[this.selectedIndex]; // Get the selected option

    // Populate the fields with data attributes
    document.getElementById('inputQuantitiRacun').value = selectedOption.dataset.amount;
    document.getElementById('inputJenisKuantiti').value = selectedOption.dataset.amount_type;
    document.getElementById('inputKeteranganRacun').value = selectedOption.dataset.description;
});
</script>



    <script>
        document.getElementById('inputKategoriPenyelesaian').addEventListener('change', function() {
            const selectedValue = this.value;
            const sectionTuanKebun = document.getElementById('sectionTuanKebun');
            const sectionMeracun = document.getElementById('sectionMeracun');

            // Reset all sections
            sectionTuanKebun.style.display = 'none';
            sectionMeracun.style.display = 'none';

            // Show the corresponding section based on selected value
            if (selectedValue === 'Jumpa Tuan Kebun') {
                sectionTuanKebun.style.display = 'block';
            } else if (selectedValue === 'Meracun') {
                sectionMeracun.style.display = 'block';
            }
        });
    </script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\desa-grow-farm\resources\views/damage/edit.blade.php ENDPATH**/ ?>