@extends('layouts.base')

@section('content')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">Pengurusan</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('farm.index') }}">Kebun</a></li>
                        <li class="breadcrumb-item active">Tambah Kebun</li>
                    </ol>
                </div>
                <h4 class="page-title">Pengurusan Kebun</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title">Tambah Kebun</h4>
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form role="form" method="POST" action="{{ route('farm.store') }}" enctype="multipart/form-data">
                        @csrf
                        <div class="form-row">
                            <div class="form-group col-md-8">
                                <label for="inputEmail4" class="col-form-label">Nama Kebun</label>
                                <input type="name" name="name" class="form-control" id="inputEmail4"
                                    placeholder="Eg: Kebun Gerobok Lama">
                            </div>
                            <div class="form-group col-md-4 ">
                                <label for="inputEmail4" class="col-form-label">Saiz Kebun</label>
                                <input type="number" name="size" class="form-control" id="inputEmail4"
                                    placeholder="Eg: 2.78 ha" min="1" max="5000" step="0.01">
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="inputState" class="col-form-label">Kategori Kebun</label>
                                <select id="plant_category" name="plant_category" class="form-control">
                                    <option value="">Sila Pilih</option>
                                    @foreach ($categories as $category)
                                        <option value="{{ $category->id }}">{{ $category->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="inputState" class="col-form-label">Jenis Kebun</label>
                                <select name="type" id="type" class="form-control">
                                    <option selected>Sila Pilih</option>
                                    <option value="Baris">Baris</option>
                                    <option value="Terbuka">Terbuka</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="example-textarea">Alamat Kebun</label>
                            <textarea class="form-control" name="address" id="example-textarea" rows="5"></textarea>

                            <div class="form-group ">
                                <label for="pdf" class="col-form-label">Upload Dokumen</label>
                                <input type="file" name="pdf" class="form-control" id="pdf" accept=".pdf">
                            </div>

                            <div class="text-center mt-2">
                                <button type="button" onclick="history.back()" class="btn btn-light mr-3">Batal</button>
                                <button type="submit" class="btn btn-info">Simpan</button>
                            </div>
                        </div> <!-- end card body-->
                    </form>
                </div> <!-- end card -->
            </div><!-- end col-->
        </div>
        <!-- end row-->
    </div>
@endsection
