<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('plantations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('farm_id'); // Foreign key to farm
            $table->foreignId('plant_detail_id'); // Foreign key to plant details
            
            // Foreign keys to fertilizers
            $table->foreignId('tumbesaran_id')->nullable(); // Foreign key to fertilizer (Tumbesaran)
            $table->json('tumbesaran_date')->nullable();
            
            $table->foreignId('akar_id')->nullable(); // Foreign key to fertilizer (Akar Pokok)
            $table->json('akar_date')->nullable();
            
            $table->foreignId('buah_id')->nullable(); // Foreign key to fertilizer (Buah)
            $table->json('buah_date')->nullable();
            
            $table->foreignId('matang_id')->nullable(); // Foreign key to fertilizer (Matang)
            $table->json('matang_date')->nullable();
            
            // Foreign keys to users (for pengait and penanam)
            $table->foreignId('pengait_id')->nullable(); // Foreign key to user (pengait)
            $table->foreignId('penanam_id')->nullable(); // Foreign key to user (penanam)
            
            // Additional fields
            $table->date('plant_date')->nullable(); // End date column
            $table->date('harvest_date')->nullable(); // Harvest date
            $table->integer('quantity_plant')->nullable(); // Quantity of plants
            $table->enum('status', ['Baru', 'Proses Tanam', 'Tanam','Proses Tuai', 'Tuai Hasil','Kira Hasil', 'Selesai'])->default('Baru'); // Status of the plantation

            $table->string('image_tanam')->nullable();
            $table->string('image_kait')->nullable();
            $table->timestamps(); // Created at and updated at timestamps
            $table->softDeletes();
        });


        // Schema::create('plantations', function (Blueprint $table) {
        //     $table->id();
        //     $table->foreignId('farm_id')->constrained()->onDelete('cascade'); // Foreign key to farm
        //     $table->foreignId('plant_detail_id')->constrained()->onDelete('cascade'); // Foreign key to plant details
            
        //     // Foreign keys to fertilizers
        //     $table->foreignId('tumbesaran_id')->nullable()->constrained('fertilizer_details')->onDelete('cascade'); // Foreign key to fertilizer (Tumbesaran)
        //     $table->json('tumbesaran_date')->nullable();
            
        //     $table->foreignId('akar_id')->nullable()->constrained('fertilizer_details')->onDelete('cascade'); // Foreign key to fertilizer (Akar Pokok)
        //     $table->json('akar_date')->nullable();
            
        //     $table->foreignId('buah_id')->nullable()->constrained('fertilizer_details')->onDelete('cascade'); // Foreign key to fertilizer (Buah)
        //     $table->json('buah_date')->nullable();
            
        //     $table->foreignId('matang_id')->nullable()->constrained('fertilizer_details')->onDelete('cascade'); // Foreign key to fertilizer (Matang)
        //     $table->json('matang_date')->nullable();
            
        //     // Foreign keys to users (for pengait and penanam)
        //     $table->foreignId('pengait_id')->nullable()->constrained('users')->onDelete('cascade'); // Foreign key to user (pengait)
        //     $table->foreignId('penanam_id')->nullable()->constrained('users')->onDelete('cascade'); // Foreign key to user (penanam)
            
        //     // Additional fields
        //     $table->date('plant_date')->nullable(); // End date column
        //     $table->date('harvest_date')->nullable(); // Harvest date
        //     $table->integer('quantity_plant')->nullable(); // Quantity of plants
        //     $table->enum('status', ['Baru', 'Proses Tanam', 'Tanam','Proses Tuai', 'Tuai Hasil','Kira Hasil', 'Selesai'])->default('Baru'); // Status of the plantation

        //     $table->string('image_tanam')->nullable();
        //     $table->string('image_kait')->nullable();
        //     $table->timestamps(); // Created at and updated at timestamps
        //     $table->softDeletes();
        // });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('plantations');
    }
};
