<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Harvest extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'plantation_id',
        'harvest_date',
        'grade_a_quantity',
        'grade_b_quantity',
        'grade_c_quantity',
        'grade_reject_quantity',
        'grade_a_weight',
        'grade_b_weight',
        'grade_c_weight',
        'grade_reject_weight',
        'total_weight',
        'grade_a_available',
        'grade_b_available',
        'grade_c_available',
        'status'
    ];



    public function plantation()
    {
        return $this->belongsTo(Plantation::class);
    }

    public function sale()
    {
        return $this->hasMany(Sale::class); // Relationship for sale
    }
}
