<?php $__env->startSection('title', 'Tempahan'); ?>

<?php $__env->startSection('content'); ?>

    <!-- Nucleo Icons -->
    <link href="<?php echo e(asset('assets/css/nucleo-icons.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/css/nucleo-svg.css')); ?>" rel="stylesheet" />
    <!-- Font Awesome Icons -->
    <script src="https://kit.fontawesome.com/42d5adcbca.js" crossorigin="anonymous"></script>
    <link href="<?php echo e(asset('assets/css/nucleo-svg.css')); ?>" rel="stylesheet" />
    <!-- CSS Files -->
    <link id="pagestyle" href="<?php echo e(asset('assets/css/soft-ui-dashboard.css?v=1.0.3')); ?>" rel="stylesheet" />


    <!-- Page Title -->
    <div class="page-title" data-aos="fade" style="background-image: url(<?php echo e(asset('assets/img/page-title-bg.jpg')); ?>);">
        <div class="container position-relative">
            <h1 class="text-white">Kemaskini Maklumat Servis</h1>
            <nav class="breadcrumbs">
                <ol>
                    <li><a href="/" style="color: #feb900">Laman Utama</a></li>
                    <li><a href="<?php echo e(route('booking.index')); ?>" style="color: #feb900">Servis</a></li>
                    <li class="current">Kemaskini</li>
                </ol>
            </nav>
        </div>
    </div><!-- End Page Title -->

    <!-- Starter Section Section -->
    <section style="background: #f6f9ff;">

        <div class="container center-container">
            <div class="row justify-content-center w-100">
                <div class="card m-4 medium-card">
                    <div class="card-header pb-0 p-3">
                        <h3>Maklumat Servis</h3>
                    </div>
                    <div class="card-body p-4">
                        <form method="POST" action="<?php echo e(route('booking.update', $booking->id)); ?>">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?> <!-- This specifies that the request should be treated as an update (PUT) -->
                    
                            

                            <div class="row">
                                <div class="col">
                                    <div class="form-group">
                                        <label>Servis</label>
                                        <select class="form-control form-control-lg" name="service" required>
                                            <option value="">Select Service</option>
                                            <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $serviceOption): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($serviceOption->id); ?>" 
                                                    <?php echo e($booking->service_id == $serviceOption->id ? 'selected' : ''); ?>>
                                                    <?php echo e($serviceOption->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                    
                             <!-- Sub Service Dropdown -->
                            <div class="row">
                                <div class="col">
                                    <div class="form-group">
                                        <label>Pilihan Servis</label>
                                        <select class="form-control form-control-lg" name="sub_service" required>
                                            <option value="">Select Sub Service</option>
                                            <?php $__currentLoopData = $sub_services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subServiceOption): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($subServiceOption->id); ?>" 
                                                    <?php echo e($booking->sub_service_id == $subServiceOption->id ? 'selected' : ''); ?>>
                                                    <?php echo e($subServiceOption->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                    
                            <div class="row">
                                <div class="col">
                                    <label>Adakah anda sudah mempunyai alat ganti?</label>
                                    <select name="parts" id="parts" class="form-control form-control-lg">
                                        <option value="Ya" <?php echo e((old('parts', $booking->parts) == 'Ya') ? 'selected' : ''); ?>>Ya</option>
                                        <option value="Tidak" <?php echo e((old('parts', $booking->parts) == 'Tidak') ? 'selected' : ''); ?>>Tidak</option>
                                    </select>
                                </div>                                

                                <div class="col">
                                    <div class="form-group">
                                        <label>Bilangan Unit</label>
                                        <input type="number" class="form-control form-control-lg" id="unit" name="unit" value="<?php echo e(old('unit', $booking->unit)); ?>">
                                    </div>
                                </div>
                            </div>
                    
                            <div class="row">
                                <div class="col">
                                    <div class="form-group">
                                        <label>Tarikh Pilihan</label>
                                        <input class="form-control form-control-lg" name="date" id="date" type="date"
                                            value="<?php echo e(old('date', isset($booking->date) ? $booking->date->format('Y-m-d') : '')); ?>">
                                    </div>
                                </div>
                                <div class="col">
                                    <div class="form-group">
                                        <label for="time">Masa Pilihan</label>
                                        <select class="form-control form-control-lg" name="time" id="time" required>
                                            <option value="" disabled <?php echo e(old('time', $booking->time->format('H:i')) ? '' : 'selected'); ?>>Pilih Masa</option>
                                            <?php if(old('time') || $booking->time): ?>
                                                <option value="<?php echo e(old('time', $booking->time->format('H:i'))); ?>" selected>
                                                    <?php echo e(old('time', $booking->time->format('H:i'))); ?>

                                                </option>
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col">
                                    <div class="form-group">
                                        <label>Tarikh Alternatif</label>
                                        <input class="form-control form-control-lg" name="alt_date" id="alt_date" type="date"
                                            value="<?php echo e(old('alt_date', isset($booking->alt_date) ? $booking->alt_date->format('Y-m-d') : '')); ?>">
                                    </div>
                                </div>
                                <div class="col">
                                    <div class="form-group">
                                        <label for="alt_time">Masa Alternatif</label>
                                        <select class="form-control form-control-lg" name="alt_time" id="alt_time">
                                            <option value="" disabled <?php echo e(old('alt_time', $booking->alt_time->format('H:i')) ? '' : 'selected'); ?>>Pilih Masa</option>
                                            <?php if(old('alt_time') || $booking->alt_time): ?>
                                                <option value="<?php echo e(old('alt_time', $booking->alt_time->format('H:i'))); ?>" selected>
                                                    <?php echo e(old('alt_time', $booking->alt_time->format('H:i'))); ?>

                                                </option>
                                            <?php endif; ?>
                                        </select>
                                    </div>                                    
                                </div> 
                                                               
                            </div>
                                                                          
                            <div class="row">
                                <div class="col">
                                    <div class="form-group">
                                        <label>Alamat Baris 1</label>
                                        <input type="text" class="form-control form-control-lg" name="address_line1" value="<?php echo e(old('address_line1', $address->address_line1)); ?>" required>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col">
                                    <div class="form-group">
                                        <label>Alamat Baris 2</label>
                                        <input type="text" class="form-control form-control-lg" name="address_line2" value="<?php echo e(old('address_line2', $address->address_line2)); ?>">
                                    </div>
                                </div>
                            </div>
                    
                            <div class="row">
                                <div class="col">
                                    <div class="form-group">
                                        <label>Bandar</label>
                                        <input type="text" class="form-control form-control-lg" name="city" value="<?php echo e(old('city', $address->city)); ?>" required>
                                    </div>
                                </div>

                                <div class="col">
                                    <div class="form-group">
                                        <label>Poskod</label>
                                        <input type="number" class="form-control form-control-lg" name="postcode" value="<?php echo e(old('postcode', $address->postcode)); ?>" required>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col">
                                    <label>Bukti Kerosakkan</label>
                                    
                                    <!-- Display existing image if it exists -->
                                    <?php if($booking->proof_damage): ?>
                                        <div>
                                            <img src="<?php echo e(asset('storage/' . $booking->proof_damage)); ?>" alt="Proof of Damage" style="max-width: 200px; max-height: 200px; margin-bottom: 10px;">
                                        </div>
                                    <?php endif; ?>
                                    
                                    <!-- File input to upload a new image -->
                                    <input type="file" class="form-control form-control-lg" name="proof_damage">
                                </div>
                            </div>

                            <div class="row">
                                <div class="col">
                                    <div class="form-group">
                                        <label>Catatan</label>
                                        <textarea class="form-control form-control-lg" rows="3" name="remark"><?php echo e(old('remark', $booking->remark)); ?></textarea>
                                    </div>
                                </div>
                            </div>
                    
                            <div class="row">
                                <div class="button-row d-flex mt-4 col-12">
                                    <button onclick="window.location.href='<?php echo e(route('booking.index')); ?>'" class="btn bg-gradient-light mb-0 js-btn-prev" type="button" title="Kembali">Kembali</button>
                                    <button class="btn btn-warning ms-auto mb-0 text-black" type="submit" title="Simpan">Simpan</button>
                                </div>
                            </div>
                        </form>
                    </div>
                    
                </div>
            </div>
        </div>


    </section>

    <!--   Core JS Files   -->
    <script src="<?php echo e(asset('assets/js/core/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/core/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/perfect-scrollbar.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/smooth-scrollbar.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/datatables.js')); ?>"></script>

    <!-- Kanban scripts -->
    <script src="<?php echo e(asset('assets/js/plugins/dragula/dragula.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/jkanban/jkanban.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/multistep-form.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/choices.min.js')); ?>"></script>

    <!-- Kanban scripts -->
    <script src="<?php echo e(asset('assets/js/plugins/dragula/dragula.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/jkanban/jkanban.js')); ?>"></script>

    <script>
        var win = navigator.platform.indexOf('Win') > -1;
        if (win && document.querySelector('#sidenav-scrollbar')) {
            var options = {
                damping: '0.5'
            }
            Scrollbar.init(document.querySelector('#sidenav-scrollbar'), options);
        }
    </script>

    

    
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const dateInputs = ['date', 'alt_date'];

            // Get today's date in YYYY-MM-DD format
            const today = new Date();
            const year = today.getFullYear();
            const month = String(today.getMonth() + 1).padStart(2, '0'); // Months are 0-indexed
            const day = String(today.getDate()).padStart(2, '0');
            const todayFormatted = `${year}-${month}-${day}`;

            // Set the minimum date for each date input
            dateInputs.forEach(inputId => {
                const dateInput = document.getElementById(inputId);
                if (dateInput) {
                    dateInput.min = todayFormatted;
                }
            });
        });
    </script>

    
    <script>
        const fetchAvailableSlots = (date, selectElement, preselectedTime = '') => {
            if (!date) {
                selectElement.innerHTML = `<option value="">Pilih Masa</option>`;
                return;
            }
    
            fetch(`/bookings/available-slots?date=${date}`)
                .then(response => {
                    if (!response.ok) throw new Error('Failed to fetch time slots');
                    return response.json();
                })
                .then(data => {
                    const { timeSlots } = data;
                    selectElement.innerHTML = ''; // Clear existing options
    
                    // Add default "Pilih Masa" option
                    const defaultOption = document.createElement('option');
                    defaultOption.value = '';
                    defaultOption.textContent = 'Pilih Masa';
                    selectElement.appendChild(defaultOption);
    
                    // Add the preselected time if not part of the fetched slots
                    if (preselectedTime && !timeSlots.some(slot => slot.time === preselectedTime)) {
                        const preselectedOption = document.createElement('option');
                        preselectedOption.value = preselectedTime;
                        preselectedOption.textContent = preselectedTime;
                        preselectedOption.selected = true;
                        selectElement.appendChild(preselectedOption);
                    }
    
                    // Populate dropdown with available slots
                    timeSlots.forEach(slot => {
                        const option = document.createElement('option');
                        option.value = slot.time;
                        option.textContent = slot.time;
                        option.disabled = !slot.is_available;
                        if (slot.time === preselectedTime) {
                            option.selected = true;
                        }
                        selectElement.appendChild(option);
                    });
                })
                .catch(error => {
                    console.error('Error fetching time slots:', error);
                    selectElement.innerHTML = `<option value="">Error loading slots</option>`;
                });
        };
    
        document.addEventListener('DOMContentLoaded', function () {
            const dateInput = document.getElementById('date');
            const altDateInput = document.getElementById('alt_date');
            const timeSelect = document.getElementById('time');
            const altTimeSelect = document.getElementById('alt_time');
            const form = document.querySelector('form');
    
            // Fetch available slots on date change
            dateInput.addEventListener('change', () => {
                fetchAvailableSlots(dateInput.value, timeSelect, '<?php echo e(old('time', $booking->time->format('H:i') ?? '')); ?>');
            });
    
            altDateInput.addEventListener('change', () => {
                fetchAvailableSlots(altDateInput.value, altTimeSelect, '<?php echo e(old('alt_time', $booking->alt_time->format('H:i') ?? '')); ?>');
            });
    
            // Load initial time slots for pre-filled dates
            if (dateInput.value) {
                fetchAvailableSlots(dateInput.value, timeSelect, '<?php echo e(old('time', $booking->time->format('H:i') ?? '')); ?>');
            }
    
            if (altDateInput.value) {
                fetchAvailableSlots(altDateInput.value, altTimeSelect, '<?php echo e(old('alt_time', $booking->alt_time->format('H:i') ?? '')); ?>');
            }

            const validateTimes = () => {
                if (
                    dateInput.value === altDateInput.value &&
                    timeSelect.value &&
                    altTimeSelect.value &&
                    timeSelect.value === altTimeSelect.value
                ) {
                    // alert('Masa dan masa alternatif tidak boleh sama jika tarikh adalah sama.');
                    return false;
                }
                return true;
            };

            form.addEventListener('submit', function (event) {
                if (!validateTimes()) {
                    event.preventDefault(); // Prevent form submission
                }
            });

        });
    </script>
    

    <!-- Control Center for Soft Dashboard: parallax effects, scripts for the example pages etc -->
    <script src="<?php echo e(asset('assets/js/soft-ui-dashboard.min.js?v=1.0.3')); ?>"></script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\fatin\Downloads\Degree UMPSA\MyTukang\resources\views/booking/edit.blade.php ENDPATH**/ ?>