<?php $__env->startSection('title', 'Invois'); ?>

<?php $__env->startSection('content'); ?>

<style>
    @media print {
        .no-print {
            display: none; /* Hides buttons and other elements marked with this class */
        }

        body {
            margin: 0;
            padding: 0;
            background: white; /* Ensures clean background */
        }

        #printable-section {
            width: 100%;
        }
    }
</style>


    <!-- Page Title -->
    <div class="page-title" data-aos="fade" style="background-image: url(<?php echo e(asset('assets/img/page-title-bg.jpg')); ?>);">
        <div class="container position-relative">
            <h1 class="text-white">Invois</h1>
            <nav class="breadcrumbs">
                <ol>
                    <li><a href="/" style="color: #feb900">Laman Utama</a></li>
                    <li><a href="<?php echo e(route('booking.index')); ?>" style="color: #feb900">Servis > Senarai Tempahan</a></li>
                    <li class="current">Papar Invois</li>
                </ol>
            </nav>
        </div>
    </div><!-- End Page Title -->

    <!-- Section -->
    <section id="printable-section" style="background: #f6f9ff;">
        <div class="container-fluid py-4" style="width: 800px; padding:10px;">
            <!-- Invoice content here -->
            <div class="row">
                <div class="col-12">
                    <div class="card p-4">
                        <div class="card-body">
                            <!-- Invoice Details -->
                            <div class="row mt-4">
                                <div class="col-8">
                                    <address>
                                        <b>Yusof Abdullah</b><br>
                                        64, Lebuh Pendamar Indah 1<br>
                                        Taman Pendamar Indah<br>
                                        42000 Pelabuhan Klang, Selangor<br>
                                        <abbr title="Phone">Tel No:</abbr> (+60) 10-5235987
                                    </address>
                                </div>
                                <div class="col-4 mt-4">
                                    <h3 class="sitename">MyTukang<span style="color: #feb900">.</span></h3>
                                </div>
                            </div>
                            <hr>
                            <!-- Other invoice details -->
                            <div class="row mt-4">
                                <div class="col-sm-8">
                                    <p><b>Kepada:</b></p>
                                    <p>
                                        <?php echo e($booking->user->name); ?><br>
                                        <?php echo e($booking->address->address_line1); ?><br>
                                        <?php echo e($booking->address->address_line2); ?><br>
                                        <?php echo e($booking->address->postcode); ?> <?php echo e($booking->address->city); ?>

                                    </p>
                                </div>
                                <div class="col-sm-4">
                                    <p><b>Tarikh Invoice:</b></p>
                                    <p><?php echo e($invoice->created_at->format('d/m/Y')); ?></p>
                                    <p><b>No. Invois:</b></p>
                                    <p>#<?php echo e($invoice->id); ?></p>
                                </div>
                            </div>
                            <!-- Table -->
                            <div class="table-responsive">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Skop kerja</th>
                                            <th>Kuantiti</th>
                                            <th>Harga seunit</th>
                                            <th>Jumlah</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($index + 1); ?></td>
                                                <td><?php echo e($item['scope_of_work']); ?></td>
                                                <td><?php echo e($item['quantity']); ?></td>
                                                <td>RM <?php echo e(number_format($item['unit_price'], 2)); ?></td>
                                                <td>RM <?php echo e(number_format($item['total_price'], 2)); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                            <!-- Total -->
                            <div class="row">
                                <div class="col-8 text-end">
                                    <p><b>Jumlah Keseluruhan</b></p>
                                </div>
                                <div class="col-4 text-center">
                                    <p><b>RM <?php echo e(number_format($booking->total_payment, 2)); ?></b></p>
                                </div>
                            </div>
                            <!-- Buttons -->
                            <div class="no-print row mt-3">
                                <div class="button-row d-flex mt-4 col-12">
                                    <button onclick="history.back()" class="btn btn-secondary mb-0 js-btn-prev" type="button" title="Kembali">Kembali</button>
                                    <button class="btn btn-warning ms-auto mb-0 text-black" type="submit"  onclick="printInvoice()">Cetak</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    


    <!-- Print Script -->
    <script>
        function printInvoice() {
            // Trigger the browser's print dialog
            window.print();
        }
    </script>
    
    



    <!--   Core JS Files   -->
    <script src="<?php echo e(asset('assets/js/core/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/core/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/perfect-scrollbar.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/smooth-scrollbar.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/datatables.js')); ?>"></script>

    <!-- Kanban scripts -->
    <script src="<?php echo e(asset('assets/js/plugins/dragula/dragula.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/jkanban/jkanban.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/multistep-form.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/choices.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/sweetalert.min.js')); ?>"></script>


    <script>
        var win = navigator.platform.indexOf('Win') > -1;
        if (win && document.querySelector('#sidenav-scrollbar')) {
            var options = {
                damping: '0.5'
            }
            Scrollbar.init(document.querySelector('#sidenav-scrollbar'), options);
        }
    </script>

    <!-- Control Center for Soft Dashboard: parallax effects, scripts for the example pages etc -->
    <script src="<?php echo e(asset('assets/js/soft-ui-dashboard.min.js?v=1.0.3')); ?>"></script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\fatin\Downloads\Degree UMPSA\MyTukang\resources\views/invoice/show.blade.php ENDPATH**/ ?>