<?php $__env->startSection('title', 'Tempahan'); ?>

<?php $__env->startSection('content'); ?>

<!-- Nucleo Icons -->
<link href="<?php echo e(asset('assets/css/nucleo-icons.css')); ?>" rel="stylesheet" />
<link href="<?php echo e(asset('assets/css/nucleo-svg.css')); ?>" rel="stylesheet" />
<!-- Font Awesome Icons -->
<script src="https://kit.fontawesome.com/42d5adcbca.js" crossorigin="anonymous"></script>
<link href="<?php echo e(asset('assets/css/nucleo-svg.css')); ?>" rel="stylesheet" />

<!-- CSS Files -->
<link id="pagestyle" href="<?php echo e(asset('assets/css/soft-ui-dashboard.css?v=1.0.3')); ?>" rel="stylesheet" />


<!-- Page Title -->
<div class="page-title" data-aos="fade" style="background-image: url(<?php echo e(asset('assets/img/page-title-bg.jpg')); ?>);">
    <div class="container position-relative">
        <h1 class="text-white">Jejak Tempahan</h1>
        <nav class="breadcrumbs">
            <ol>
                <li><a href="/" style="color: #feb900">Laman Utama</a></li>
                <li><a href="<?php echo e(route('booking.index')); ?>" style="color: #feb900">Servis > Sejarah</a></li>
                <li class="current">Jejak Tempahan</li>
            </ol>
        </nav>
    </div>
</div><!-- End Page Title -->

<style>
    .timeline {
        position: relative;
        padding: 20px 0;
        margin: 20px 0;
        margin-left: 30px;
        /* Align the timeline to the left */
    }

    /* Timeline Line */
    .timeline::before {
        content: '';
        position: absolute;
        left: 10px;
        top: 0;
        width: 2px;
        background-color: #ddd;
        height: 100%;
    }

    .timeline-item {
        display: flex;
        align-items: center;
        margin-bottom: 20px;
        position: relative;
    }

    /* Timeline Icon */
    .timeline-icon {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        display: flex;
        justify-content: center;
        align-items: center;
        font-size: 20px;
        background-color: #fff;
        border: 2px solid #ddd;
        z-index: 1;
        position: absolute;
        left: -20px;
    }

    .timeline-content {
        flex: 1;
        padding: 10px;
        background: #f8f9fa;
        border-radius: 5px;
        margin-left: 50px;
    }

    .timeline-content h5 {
        margin-bottom: 5px;
        font-size: 1rem;
    }

    .timeline-item .text-muted {
        font-size: 0.85rem;
    }

    @media (max-width: 768px) {
        .timeline-item {
            flex-direction: column;
            align-items: flex-start;
        }

        .timeline-icon {
            margin-bottom: 10px;
            position: relative;
            left: 0;
        }

        .timeline-content {
            margin-left: 0;
        }

        .sitename,
        .info,
        .detail,
        .issue {
            font-size: 18px;
        }
    }
</style>

<!-- Progress Section -->
<section style="background: #f6f9ff; padding: 50px 0;">
    <div class="container center-container">
        <div class="row justify-content-center w-100">
            <div class="card m-4 medium-card" style="border: 1px solid #8c8c8c; border-radius: 8px;">
                <div class="card-header pb-0 p-3">
                    <div class="row mt-2">
                        <div class="col-9 m-2">
                            <p class="mb-3">No. Tempahan: <b>#<?php echo e($booking->id); ?></b></p>

                            <?php
                            $statusFailed = ['Tolak', 'Belum Bayar', 'Pembayaran Tidak Selesai', 'Pembayaran Gagal'];
                            $statusColor = in_array($booking->status, $statusFailed) ? 'red' : 'green';
                            ?>

                            <h3 class="mt-4" style="color: <?php echo e($statusColor); ?>"><?php echo e($booking->status); ?></h3>
                            <p><?php echo e($booking->date->format('l, F j, Y')); ?></p>

                        </div>
                        <div class="col-2 mt-4">
                            <h3 class="sitename">MyTukang<span style="color: #feb900">.</span></h3>
                        </div>
                    </div>
                </div>

                <hr>

                <div class="card-body p-4">
                    <!-- Collapsible Section -->
                    <button class="btn btn-link p-0 d-flex justify-content-between align-items-center" type="button" data-bs-toggle="collapse" data-bs-target="#collapseDetails" aria-expanded="false" aria-controls="collapseDetails" style="font-size: 1rem; color: black; width: 100%;">
                        <span>Lihat Butiran Aliran Kerja</span>
                        <i class="bi bi-chevron-down" id="collapseIcon"></i>
                    </button>
                    <div class="collapse" id="collapseDetails">
                        <div class="mt-3" style="font-size: 1rem; color: black;">
                            <p>Berikut ialah butiran aliran kerja untuk tempahan anda...</p>

                            <!-- Vertical Timeline Section -->
                            <div class="timeline">
                                <?php $__currentLoopData = $filteredWorkflow; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $step): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="timeline-item">
                                    <div class="timeline-icon bg-<?php echo e($step['status']); ?> text-white">
                                        <i class="bi <?php echo e($step['icon']); ?>"></i>
                                    </div>
                                    <div class="timeline-content">
                                        <h5><?php echo e($step['title']); ?></h5>
                                        <p>
                                            <?php echo $step['description']; ?>

                                            <?php if(isset($step['link']) && isset($step['link_text'])): ?>
                                            <br><a href="<?php echo e($step['link']); ?>" style="color: blue;"><?php echo e($step['link_text']); ?></a>
                                            <?php endif; ?>
                                        </p>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                            <!-- End of Vertical Timeline Section -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


<!--   Core JS Files   -->
<script src="<?php echo e(asset('assets/js/core/popper.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/core/bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/plugins/perfect-scrollbar.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/plugins/smooth-scrollbar.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/plugins/datatables.js')); ?>"></script>

<!-- Kanban scripts -->
<script src="<?php echo e(asset('assets/js/plugins/dragula/dragula.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/plugins/jkanban/jkanban.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/plugins/multistep-form.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/plugins/choices.min.js')); ?>"></script>

<!-- Kanban scripts -->
<script src="<?php echo e(asset('assets/js/plugins/dragula/dragula.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/plugins/jkanban/jkanban.js')); ?>"></script>

<!-- Bootstrap JS and Popper.js (required for collapsible functionality) -->
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.js"></script>

<script>
    // JavaScript for toggle icon behavior and collapse functionality
    const collapseButton = document.querySelector('[data-bs-toggle="collapse"]');
    const collapseIcon = document.getElementById("collapseIcon");

    collapseButton.addEventListener("click", function() {
        if (collapseIcon.classList.contains("bi-chevron-down")) {
            collapseIcon.classList.remove("bi-chevron-down");
            collapseIcon.classList.add("bi-chevron-up");
        } else {
            collapseIcon.classList.remove("bi-chevron-up");
            collapseIcon.classList.add("bi-chevron-down");
        }
    });
</script>

<script>
    var win = navigator.platform.indexOf('Win') > -1;
    if (win && document.querySelector('#sidenav-scrollbar')) {
        var options = {
            damping: '0.5'
        }
        Scrollbar.init(document.querySelector('#sidenav-scrollbar'), options);
    }
</script>


<!-- Control Center for Soft Dashboard: parallax effects, scripts for the example pages etc -->
<script src="<?php echo e(asset('assets/js/soft-ui-dashboard.min.js?v=1.0.3')); ?>"></script>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\fatin\Downloads\Degree UMPSA\MyTukang\resources\views/booking/progress.blade.php ENDPATH**/ ?>