<?php $__env->startSection('title', 'Tempahan'); ?>

<?php $__env->startSection('content'); ?>

    <!-- Nucleo Icons -->
    <link href="<?php echo e(asset('assets/css/nucleo-icons.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('aassets/css/nucleo-svg.css')); ?>" rel="stylesheet" />
    <!-- Font Awesome Icons -->
    <script src="https://kit.fontawesome.com/42d5adcbca.js" crossorigin="anonymous"></script>
    <link href="<?php echo e(asset('assets/css/nucleo-svg.css')); ?>" rel="stylesheet" />
    <!-- CSS Files -->
    <link id="pagestyle" href="<?php echo e(asset('assets/css/soft-ui-dashboard.css?v=1.0.3')); ?>" rel="stylesheet" />

    <style>
        .nav-tabs .nav-link {
            color: #fbc400;
            background-color: transparent;
            border: 1px solid transparent;
            transition: 0.3s;
        }

        .nav-tabs .nav-link:hover {
            color: black;
        }

        .nav-tabs .nav-link.active {
            color: black;
            background-color: white;
        }

        /* .table-flush {
            border-collapse: collapse;
            width: 100%;
            margin-bottom: 1rem;
            color: #212529;
            background-color: #fff;
        }
        .thead-light th {
            background-color: #f6f9ff;
            color: #333;
        } */


    </style>


    <!-- Page Title -->
    <div class="page-title" data-aos="fade" style="background-image: url(<?php echo e(asset('assets/img/page-title-bg.jpg')); ?>);">
        <div class="container position-relative">
            <h1 class="text-white">Senarai Tempahan</h1>
            <nav class="breadcrumbs">
                <ol>
                    <li><a href="<?php echo e(route('user.homepage')); ?>" style="color: #feb900">Laman Utama</a></li>
                    <li class="current">Servis > Senarai Tempahan</li>
                </ol>
            </nav>
        </div>
    </div><!-- End Page Title -->

    <!-- Alert -->
    <!-- <?php if(session('success')): ?>
        <div class="alert alert-success" role="alert" style="all: unset; display: block; background-color: #d4edda; color: #155724; padding: 1rem; border: 1px solid #c3e6cb; border-radius: 0.25rem;">
            <?php echo e(session('success')); ?>

        </div>
    <?php elseif(session('error')): ?>
        <div class="alert alert-danger" role="alert" style="all: unset; display: block; background-color: #f8d7da; color: #721c24; padding: 1rem; border: 1px solid #f5c6cb; border-radius: 0.25rem;">
            <?php echo e(session('error')); ?>

        </div>
    <?php endif; ?> -->


    <!-- Starter Section Section -->
    <section id="starter-section" class="starter-section section" style="background: #f6f9ff;">
        <div class="container py-4">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card">
                        <!-- Card Header with Tabs -->
                        <div class="card-header pb-0">
                            <ul class="nav nav-tabs" id="bookingTabs" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link active" id="current-bookings-tab" data-bs-toggle="tab" href="#current-bookings" role="tab" aria-controls="current-bookings" aria-selected="true">
                                        Tempahan Semasa
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" id="history-bookings-tab" data-bs-toggle="tab" href="#history-bookings" role="tab" aria-controls="history-bookings" aria-selected="false">
                                        Sejarah Tempahan
                                    </a>
                                </li>
                            </ul>
                        </div>

                        <div class="card-body p-3">
                            <!-- Tab Content -->
                            <div class="tab-content" id="bookingTabsContent">
                                <!-- Current Bookings -->
                                <div class="tab-pane fade show active" id="current-bookings" role="tabpanel" aria-labelledby="current-bookings-tab">
                                        <div class="table-responsive">
                                            <table class="table table-flush" id="current-bookings-table">
                                                <thead class="thead-light">
                                                    <tr>
                                                        <th class="text-center" style="width: 5%;">No.</th>
                                                        <th style="width: 25%;">Servis</th>
                                                        <th style="width: 15%;">Tarikh</th>
                                                        <th style="width: 15%;">Status</th>
                                                        <th style="width: 30%;">Catatan</th>
                                                        <th style="width: 10%;">Tindakan</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $__currentLoopData = $currentBookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                    <?php
                                                        // Define the statuses that should show the Jejak Tempahan button
                                                        $statusesWithJejakTempahan = [
                                                            'Lulus', 
                                                            'Sebut Harga', 
                                                            'Tolak',
                                                            'Menunggu Sebut Harga', 
                                                            'Sebut Harga Baru',
                                                            'Belum Bayar',
                                                            'Pembayaran Berjaya',
                                                            'Pembayarn Tidak Selesai',
                                                            'Pembayaran Gagal',
                                                            'Kerja Dalam Proses',
                                                            'Selesai',
                                                        ];
                                                    ?>

                                                        <tr>
                                                            <td class="text-center"><?php echo e($index + 1); ?></td>
                                                            <td><?php echo e($booking->subService->name ?? 'N/A'); ?></td>
                                                            <td><?php echo e($booking->created_at ? $booking->created_at->format('d/m/Y') : '-'); ?></td>
                                                            <td>
                                                                <?php if($booking->status == 'Hantar'): ?>
                                                                    <span class="badge badge-warning badge-sm"><?php echo e($booking->status); ?></span>
                                                                <?php elseif($booking->status == 'Gagal'): ?>
                                                                    <span class="badge badge-danger badge-sm"><?php echo e($booking->status); ?></span>
                                                                <?php else: ?>
                                                                    <span class="badge badge-success badge-sm">Lulus</span>
                                                                <?php endif; ?>
                                            
                                                            </td>
                                                            <td><?php echo e($booking->reject_reason ?? '-'); ?></td>
                                                            <td class="text-left">

                                                                <?php if($booking->status == "Hantar"): ?>
                                                                    <a href="<?php echo e(route('booking.show', $booking->id)); ?>" data-bs-toggle="tooltip" data-bs-original-title="Papar">
                                                                        <i class="fas fa-eye text-dark"></i>
                                                                    </a>
                                                                    <a href="<?php echo e(route('booking.edit', $booking->id)); ?>" class="mx-3" data-bs-toggle="tooltip" data-bs-original-title="Kemaskini">
                                                                        <i class="fas fa-edit text-dark"></i>
                                                                    </a>
                                                                    <a href="#" data-bs-toggle="tooltip" data-bs-original-title="Padam"
                                                                        onclick="soft.showSwal('warning-message-and-confirmation', <?php echo e($booking->id); ?>)">
                                                                        <i class="fas fa-trash text-dark"></i>
                                                                    </a>
                                                                <?php elseif($booking->status == "Gagal"): ?>
                                                                    <a href="<?php echo e(route('booking.show', $booking->id)); ?>" data-bs-toggle="tooltip" data-bs-original-title="Papar">
                                                                        <i class="fas fa-eye text-dark"></i>
                                                                    </a>
                                                                    <a href="#" class="disabled-link mx-3" data-bs-toggle="tooltip">
                                                                        <i class="fas fa-edit text-secondary"></i>
                                                                    </a>
                                                                    <a href="#" class="disabled-link" data-bs-toggle="tooltip">
                                                                        <i class="fas fa-trash text-secondary"></i>
                                                                    </a>
                                                                <?php else: ?>
                                                                    <button type="button" class="btn btn-outline-dark" onclick="window.location.href='<?php echo e(route('booking.progress', $booking->id)); ?>'">
                                                                        Jejak Tempahan &nbsp;&nbsp;
                                                                        <i class="fas fa-chevron-right"></i>
                                                                    </button>
                                                                <?php endif; ?>

                                                               
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </div>
                                </div>
    
                                <!-- Booking History -->
                                <div class="tab-pane fade" id="history-bookings" role="tabpanel" aria-labelledby="history-bookings-tab">
                                    <div class="table-responsive">
                                        <table class="table table-flush" id="history-bookings-table">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th class="text-center" style="width: 5%;">No.</th>
                                                    <th style="width: 25%;">Servis</th>
                                                    <th style="width: 15%;">Tarikh</th>
                                                    <th style="width: 15%;">Status</th>
                                                    <th style="width: 30%;">Catatan</th>
                                                    <th style="width: 10%;">Tindakan</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $historyBookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td class="text-center"><?php echo e($index + 1); ?></td>
                                                        <td><?php echo e($booking->subService->name ?? 'N/A'); ?></td>
                                                        <td><?php echo e($booking->created_at ? $booking->created_at->format('d/m/Y') : '-'); ?></td>
                                                        <td>
                                                            <span class="badge badge-success badge-sm">
                                                                <?php echo e($booking->status); ?>

                                                            </span>
                                                        </td>
                                                        <td><?php echo e($booking->remark ?? '-'); ?></td>
                                                        <td class="text-center">
                                                            <button type="button" class="btn btn-outline-dark" onclick="window.location.href='<?php echo e(route('booking.progress', $booking->id)); ?>'">
                                                                Jejak Tempahan &nbsp;&nbsp;
                                                                <i class="fas fa-chevron-right"></i>
                                                            </button>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                            <tfoot>
                                                <br>
                                            </tfoot>
                                        </table>
                                    </div>
                                </div> <!-- end div history tab -->
                            </div>
                        </div> <!-- end card body -->
                    </div> <!-- end card -->
                </div>
            </div>
        </div>
    </section>
    
    
    


    <!--   Core JS Files   -->
    <script src="<?php echo e(asset('assets/js/core/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/core/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/perfect-scrollbar.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/smooth-scrollbar.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/datatables.js')); ?>"></script>

    <!-- Kanban scripts -->
    <script src="<?php echo e(asset('assets/js/plugins/dragula/dragula.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/jkanban/jkanban.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/multistep-form.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/choices.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/sweetalert.min.js')); ?>"></script>

    <script>
        $(function() {
            $('[data-bs-toggle="tooltip"]').tooltip()
        })
    </script>

    
    <script>

        // Initialize DataTable for Current Bookings
        if (document.getElementById('current-bookings-table')) {
            const currentBookingsTable = new simpleDatatables.DataTable("#current-bookings-table", {
                searchable: true,
                fixedHeight: true,
                perPage: 7
            });
        }

        // Initialize DataTable for Booking History
        if (document.getElementById('history-bookings-table')) {
            const historyBookingsTable = new simpleDatatables.DataTable("#history-bookings-table", {
                searchable: true,
                fixedHeight: true,
                perPage: 7
            });
        }

    </script>

    
    <script>
        const soft = {
            showSwal: function(type, bookingId) {
                if (type === 'warning-message-and-confirmation') {
                    Swal.fire({
                        title: 'Adakah anda pasti?',
                        text: "Anda tidak dapat mengembalikan data ini!",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'Ya, padam!',
                        cancelButtonText: 'Batal',
                        buttonsStyling: false,
                        customClass: {
                            confirmButton: 'btn btn-danger m-3',
                            cancelButton: 'btn btn-secondary m-3'
                        }
                    }).then((result) => {
                        if (result.isConfirmed) {
                            // Make the delete request
                            const form = document.createElement('form');
                            form.method = 'POST';
                            form.action = `/tempahanServis/hapus/${bookingId}`; // Updated URL
    
                            // Add CSRF token
                            const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
                            const csrfInput = document.createElement('input');
                            csrfInput.type = 'hidden';
                            csrfInput.name = '_token';
                            csrfInput.value = csrfToken;
                            form.appendChild(csrfInput);
    
                            // Add method override for DELETE
                            const methodInput = document.createElement('input');
                            methodInput.type = 'hidden';
                            methodInput.name = '_method';
                            methodInput.value = 'DELETE';
                            form.appendChild(methodInput);
    
                            document.body.appendChild(form);
                            form.submit(); // Submit the form
                        }
                    });
                }
            }
        };
    </script>    

    <script>
        var win = navigator.platform.indexOf('Win') > -1;
        if (win && document.querySelector('#sidenav-scrollbar')) {
            var options = {
                damping: '0.5'
            }
            Scrollbar.init(document.querySelector('#sidenav-scrollbar'), options);
        }
    </script>
        
    
    <!-- Kanban scripts -->
    <script src="<?php echo e(asset('assets/js/plugins/dragula/dragula.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/jkanban/jkanban.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/datatables.js')); ?>"></script>
  
    <!-- Control Center for Soft Dashboard: parallax effects, scripts for the example pages etc -->
    <script src="<?php echo e(asset('assets/js/soft-ui-dashboard.min.js?v=1.0.3')); ?>"></script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\fatin\Downloads\Degree UMPSA\MyTukang\resources\views/booking/index.blade.php ENDPATH**/ ?>