<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\BookingController;
use App\Http\Controllers\ForgotPasswordController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\QuotationController;
use App\Http\Controllers\ScheduleController;
use App\Http\Controllers\ServiceController;
use App\Http\Controllers\ToyyibpayController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

//Homeowner

// Route::get('/', function () {
//     return view('homepage');
// });

// Public route for homepage (landing page)
Route::middleware(['guest'])->get('/', [HomeController::class, 'index'])->name('homepage');

// Define a GET logout route to handle direct navigation to /logout
// Route::get('/logout', function () {
//     auth()->logout();
//     return redirect('/'); // Redirect to the homepage or any other desired route
// })->name('logout.get');


Route::controller(AuthController::class)->group(function () {

    Route::get('register', 'register')->name('register'); //display signup form
    Route::post('register', 'registerSave')->name('register.save'); //save user info

    Route::get('login', 'login')->name('login'); //display login form
    Route::post('login', 'loginAction')->name('login.action'); //save user info

    Route::post('logout', [AuthController::class, 'logout'])->middleware('auth')->name('logout');
});

// Forgot Password Routes
Route::get('forgot-password', [ForgotPasswordController::class, 'showForgotPasswordForm'])->name('password.request');
Route::post('forgot-password', [ForgotPasswordController::class, 'sendResetLink'])->name('password.email');
Route::get('reset-password/{token}', [ForgotPasswordController::class, 'showResetPasswordForm'])->name('password.reset');
Route::post('reset-password', [ForgotPasswordController::class, 'resetPassword'])->name('password.update');

// Customer Authorization
Route::middleware(['auth', 'user-access:user'])->group(function () {

    Route::get('/home', [HomeController::class, 'userHome'])->name('user.homepage');
    Route::get('/profil', [HomeController::class, 'profile'])->name('user.profile');
    Route::post('/profil/kemaskini-imej', [HomeController::class, 'updateProfileImage'])->name('profile.updateProfileImage');
    Route::post('/profil/kemaskini-maklumat', [HomeController::class, 'updateInfo'])->name('profile.updateInfo');
    Route::put('/profil/tukar-kata-laluan', [HomeController::class, 'changePassword'])->name('profile.changePassword');
    Route::delete('/profil/padam-akaun', [HomeController::class, 'deleteAccount'])->name('profile.deleteAccount');


    //Manage Booking
    Route::get('/tempahanServis', [BookingController::class, 'create'])->name('booking.create');
    Route::get('bookings/available-slots', [BookingController::class, 'getAvailableSlots']);
    Route::post('/tempahanServis/tambah', [BookingController::class, 'store'])->name('booking.store');

    Route::get('/senaraiTempahan', [BookingController::class, 'index'])->name('booking.index');

    Route::get('/tempahanServis/kemaskini/{id}', [BookingController::class, 'edit'])->name('booking.edit');
    Route::put('/tempahanServis/kemaskini/{id}', [BookingController::class, 'update'])->name('booking.update');

    Route::get('/tempahanServis/papar/{id}', [BookingController::class, 'show'])->name('booking.show');

    Route::delete('/tempahanServis/hapus/{booking}', [BookingController::class, 'destroy'])->name('booking.destroy');

    Route::get('/tempahServis/jejakTempahan/{id}', [BookingController::class, 'progress'])->name('booking.progress');

    //Manage Quotation
    Route::get('/tempahanSebutHarga/papar/{id}', [QuotationController::class, 'show'])->name('quotation.show');
    Route::post('/tempahanSebutHarga/tolak/{id}/', [QuotationController::class, 'reject'])->name('quotation.reject');
    Route::get('/tempahanSebutHarga/terima/{id}/', [QuotationController::class, 'accept'])->name('quotation.accept');

    //Manage Payment
    Route::get('/bayaran/{id}', [PaymentController::class, 'pay'])->name('payment.pay');
    Route::get('/pengesahan/{id}', [PaymentController::class, 'show'])->name('payment.display');


    //ToyyibPay
    Route::get('/pembayaran/papar', [ToyyibpayController::class, 'getBankFPX'])->name('payment.show');
    Route::get('/pembayaran/{bookingId}/{quotationId}', [ToyyibpayController::class, 'createPayment'])->name('payment.create');
    Route::get('/pembayaran/return', [ToyyibpayController::class, 'return'])->name('payment.return');
    Route::post('/pembayaran/callback', [ToyyibpayController::class, 'callback'])->name('payment.callback');

    //Manage Invoice
    Route::get('/paparInvois/{id}', [InvoiceController::class, 'show'])->name('invoice.show');
});


// Admin Authorization
Route::middleware(['auth', 'user-access:admin'])->group(function () {

    Route::get('/admin', [HomeController::class, 'adminHome'])->name('admin.homepage');

    //Manage Service
    Route::get('/servis', [ServiceController::class, 'index'])->name('service.index');
    Route::get('/servis/tambah', [ServiceController::class, 'create'])->name('service.create');
    Route::post('/servis/tambah', [ServiceController::class, 'store'])->name('service.store');
    Route::get('/servis/kemaskini/{service}', [ServiceController::class, 'edit'])->name('service.edit');
    Route::put('/servis/kemaskini/{service}', [ServiceController::class, 'update'])->name('service.update');
    Route::get('/servis/papar/{service}', [ServiceController::class, 'show'])->name('service.show');
    Route::delete('/servis/padam/{service}', [ServiceController::class, 'destroy'])->name('service.destroy');

    //Manage Booking
    Route::get('/tempahServis', [BookingController::class, 'list'])->name('booking.list');
    Route::get('/tempahServis/papar/{id}', [BookingController::class, 'showViewPage'])->name('booking.view');
    Route::get('/tempahServis/terima/{id}', [BookingController::class, 'showApprovalPage'])->name('booking.approve');
    Route::post('/tempahServis/terima/{id}', [BookingController::class, 'approve'])->name('booking.approve.submit');
    Route::post('/tempahServis/tolak/{id}', [BookingController::class, 'reject'])->name('booking.reject');

    //Manage Quotation
    Route::get('/sebutHargaList', [QuotationController::class, 'index'])->name('quotation.list');
    Route::get('/sebutHarga/tambah/{id}', [QuotationController::class, 'create'])->name('quotation.create');
    Route::post('/sebutHarga/tambah/{id}', [QuotationController::class, 'store'])->name('quotation.store');
    Route::get('/sebutHarga/papar/{id}', [QuotationController::class, 'view'])->name('quotation.view');
    Route::get('/sebutHarga/kemaskini/{id}', [QuotationController::class, 'edit'])->name('quotation.editData');
    Route::post('/sebutHarga/kemaskini/{id}', [QuotationController::class, 'update'])->name('quotation.updateData');

    //Manage Payment
    Route::get('/senaraiBayaran', [PaymentController::class, 'index'])->name('payment.index');
    Route::post('/senaraiBayaran/{id}', [PaymentController::class, 'update'])->name('payment.update');

    //Manage Invoice
    Route::get('/invois', [InvoiceController::class, 'index'])->name('invoice.index');
    Route::post('/invois/{id}', [InvoiceController::class, 'create'])->name('invoice.create');
    Route::get('/invois/papar{id}', [InvoiceController::class, 'display'])->name('invoice.display');

});


// Owner
Route::middleware(['auth', 'user-access:owner'])->group(function () {

    Route::get('/owner', [HomeController::class, 'ownerHome'])->name('owner.homepage');

    //Manage Service
    Route::get('/senaraiServis', [ServiceController::class, 'list'])->name('service.list');

    Route::get('/senaraiServis/kemaskini/{service}', [ServiceController::class, 'editList'])->name('service.editList');
    Route::put('/senaraiServis/kemaskini/{service}', [ServiceController::class, 'updateList'])->name('service.updateList');

    Route::get('/senaraiServis/papar/{service}', [ServiceController::class, 'showList'])->name('service.showList');

    Route::delete('/senaraiServis/padam/{service}', [ServiceController::class, 'delete'])->name('service.delete');

    //Manage Booking
    Route::get('/servisTempahan', [BookingController::class, 'custList'])->name('booking.owner');
    Route::get('/servisTempahan/papar/{id}', [BookingController::class, 'showCust'])->name('booking.display');

    //Manage Quotation
    Route::get('/sebutHargaData', [QuotationController::class, 'index'])->name('quotation.index');
    Route::get('/sebutHargaData/papar/{id}', [QuotationController::class, 'view'])->name('quotation.notify');
    // Route::get('/sebutHargaData/papar/{id}', [QuotationController::class, 'notify'])->name('quotation.notify');
    Route::get('/sebutHargaData/kemaskini/{id}', [QuotationController::class, 'edit'])->name('quotation.edit');
    Route::post('/sebutHargaData/kemaskini/{id}', [QuotationController::class, 'update'])->name('quotation.update');

    //Manage Payment
    Route::get('/pembayaran', [PaymentController::class, 'index'])->name('payment.list');
    Route::post('/pembayaran/{id}', [PaymentController::class, 'update'])->name('payment.edit');

    //Manage Invoice
    Route::get('/senaraiInvois', [InvoiceController::class, 'index'])->name('invoice.list');
    Route::post('/senaraiInvois/{id}', [InvoiceController::class, 'create'])->name('invoice.add');
    Route::get('/senaraiInvois/papar/{id}', [InvoiceController::class, 'display'])->name('invoice.view');

    //Manage Schedule
    Route::get('/jadualKerja', [ScheduleController::class, 'index'])->name('schedule.index');
    Route::get('/get-bookings', [ScheduleController::class, 'getBookings'])->name('bookings.get');

});


