@extends('layouts.base')

@section('title', 'Pengesahan Pembayaran')

@section('content')

<style>

    @media(max-width: 567px) {
        .mobile {
            padding-top: 40px;
        }
    }
</style>


<!-- Page Title -->
<div class="page-title" data-aos="fade" style="background-image: url({{ asset('assets/img/page-title-bg.jpg') }});">
    <div class="container position-relative">
        <h1 class="text-white">Pengesahan Pembayaran</h1>
        <nav class="breadcrumbs">
            <ol>
                <li><a href="/" style="color: #feb900">Laman Utama</a></li>
                <li><a href="{{ route('booking.index') }}" style="color: #feb900">Servis > Senarai Tempahan</a></li>
                <li class="current">Pengesahan Pembayaran</li>
            </ol>
        </nav>
    </div>
</div><!-- End Page Title -->

<section style="background: #f6f9ff;">

    <!-- Success Alert -->
    <!-- @if(session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif -->

    <!-- Error Alert -->
    <!-- @if(session('error'))
        <div class="alert alert-danger">
            {{ session('error') }}
        </div>
    @endif -->

    <div class="container center-container">
        <div class="mb-3" style="background: #fff; padding: 40px 30px; border-radius: 12px; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1); text-align: center; max-width: 500px; margin: 0 auto;">
            <div class="bg-light">
                <h3 class="sitename mb-3">MyTukang<span style="color: #feb900">.</span></h3>
            </div>
            @if($payment->status === 'successful')
            <h1 class="text-success mx-2" style="font-size: 2.5rem; ">{{$payment->booking->status}}!</h1>
            @elseif($payment->status === 'failed')
            <h1 class="text-danger mx-2" style="font-size: 2.5rem; ">{{$payment->booking->status}}!</h1>
            @else
            <h1 class="text-warning mx-2" style="font-size: 2.5rem; ">{{$payment->booking->status}}!</h1>
            @endif
            <p style="font-size: 1rem; line-height: 1.6; color: #555;">Pembayaran tempahan anda untuk perkhidmatan pembaikan rumah  
                @if($payment->status === 'succesful')
                telah berjaya
                @elseif($payment->status === 'failed')
                tidak berjaya. Sila lakukan pembayaran semula
                @else
                belum selesai. Sila lakukan pembayaran dengan segera
                .</p>
                @endif
            <div style="margin: 20px 0; background: #f9f9f9; padding: 15px; border-radius: 8px; border: 1px solid #ddd; text-align: left; font-size: 0.95rem;">
                <p style="margin-bottom: 10px;"><strong>ID Tempahan:</strong> {{$payment->booking->id}}</p>
                <p style="margin-bottom: 10px;"><strong>Kod Bil:</strong> #{{$payment->bill_code}}</p>
                <p style="margin-bottom: 10px;"><strong>Tarikh Perkhidmatan:</strong> {{$payment->booking->approved_date->format('d/m/Y')}}</p>
                <p style="margin-bottom: 10px;"><strong>Masa Perkhidmatan:</strong> {{$payment->booking->approved_time->format('H:i')}}</p>
                <p style="margin-bottom: 10px;"><strong>Nama Servis:</strong> {{$payment->booking->subService->name}}</p>
            </div>
            <p style="font-size: 1rem; line-height: 1.6; color: #555;">Anda akan menerima emel dengan semua butiran tidak lama lagi. Kami menantikan peluang untuk berkhidmat kepada anda!</p>
            @if($payment->status === 'pending' || $payment->status === 'failed')
            <a class="bg-secondary" href="{{ route('payment.create', ['bookingId' => $payment->booking->id, 'quotationId' => $payment->booking->quotation->id])}}" style="display: inline-block; margin-top: 20px; padding: 10px 20px;  color: #fff; text-decoration: none; font-weight: 500; border-radius: 5px; transition: background 0.3s;">Membuat Pembayaran Semula</a>
            @else
            <a class="bg-secondary" href="{{route('booking.progress', ['id' => $payment->booking->id])}}" style="display: inline-block; margin-top: 20px; padding: 10px 20px;  color: #fff; text-decoration: none; font-weight: 500; border-radius: 5px; transition: background 0.3s;">Kembali ke Laman Utama</a>
            @endif
        </div>
    </div>

</section>

<script>
    var win = navigator.platform.indexOf('Win') > -1;
    if (win && document.querySelector('#sidenav-scrollbar')) {
        var options = {
            damping: '0.5'
        }
        Scrollbar.init(document.querySelector('#sidenav-scrollbar'), options);
    }
</script>

<!-- Control Center for Soft Dashboard: parallax effects, scripts for the example pages etc -->
<script src="{{ asset('assets/js/soft-ui-dashboard.min.js?v=1.0.3') }}"></script>

@endsection
