@extends('layouts.base')

@section('title', 'Pembayaran')

@section('content')

<style>
    

    .green{
        color: rgb(15, 207, 143);
        font-weight: 680;
    }

    @media(max-width:567px){
        .mobile{
            padding-top: 40px;
        }
    }
</style>

 <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" rel="stylesheet">
 <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">



    <!-- Page Title -->
    <div class="page-title" data-aos="fade" style="background-image: url({{ asset('assets/img/page-title-bg.jpg') }});">
        <div class="container position-relative">
            <h1 class="text-white">Pembayaran</h1>
            <nav class="breadcrumbs">
                <ol>
                    <li><a href="/" style="color: #feb900">Laman Utama</a></li>
                    <li><a href="{{ route('booking.index') }}" style="color: #feb900">Servis > Senarai Tempahan</a></li>
                    <li class="current">Pembayaran</li>
                </ol>
            </nav>
        </div>
    </div><!-- End Page Title -->

    <!-- Section -->
    {{-- <section style="background: #f6f9ff; padding: 40px 0;">
        <div class="container rounded bg-white">
            <div class="row justify-content-center pb-5">
                <div class="col-md-6">
                    <div class="card shadow-sm border-0">
                        <!-- Header -->
                        <div class="card-header bg-light text-center">
                            <h3 class="sitename">MyTukang<span style="color: #feb900">.</span></h3>
                        </div>
                        
                        <!-- Body -->
                        <div class="card-body p-4">
                            <!-- Booking Details -->
                            <div class="mb-4">
                                <h5 class="text-secondary">Butiran Tempahan</h5>
                                <div class="table-responsive">
                                    <table class="table table-borderless">
                                        <tr>
                                            <th style="width: 30%;">Nama</th>
                                            <td>{{ $booking->user->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>Perkhidmatan</th>
                                            <td>{{ $booking->service->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>Sub-Perkhidmatan</th>
                                            <td>{{ $booking->subService->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>Alamat</th>
                                            <td>
                                                {{ $booking->address->address_line1 }}, <br>
                                                {{ $booking->address->address_line2 }}, <br>
                                                {{ $booking->address->postcode }} {{ $booking->city }}
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>Unit</th>
                                            <td>{{ $booking->unit }}</td>
                                        </tr>
                                        <tr>
                                            <th>Jumlah Bayaran</th>
                                            <td>
                                                <span class="text-success fw-bold">
                                                    RM {{ number_format($booking->total_payment, 2) }}
                                                </span>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>

                            <!-- Quotation Details -->
                            <div class="mb-4">
                                <h5 class="text-secondary">Butiran Sebut Harga</h5>
                                <div class="table-responsive">
                                    <table class="table table-striped">
                                        <thead class="bg-light">
                                            <tr>
                                                <th>#</th>
                                                <th>Skop Kerja</th>
                                                <th>Kuantiti</th>
                                                <th>Harga Seunit (RM)</th>
                                                <th>Jumlah (RM)</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @if (!empty($quotationItems))
                                                @foreach ($quotationItems as $index => $item)
                                                    <tr>
                                                        <td>{{ $index + 1 }}</td>
                                                        <td>{{ $item->scope_of_work }}</td>
                                                        <td>{{ $item->quantity }}</td>
                                                        <td>{{ number_format($item->unit_price, 2) }}</td>
                                                        <td>{{ number_format($item->total_price, 2) }}</td>
                                                    </tr>
                                                @endforeach
                                            @else
                                                <tr>
                                                    <td colspan="5" class="text-center">Tiada maklumat sebut harga tersedia.</td>
                                                </tr>
                                            @endif
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <!-- Total Amount -->
                            <div class="text-end">
                                <h5>Jumlah Keseluruhan: 
                                    <span class="text-primary">RM {{ number_format($booking->total_payment, 2) }}</span>
                                </h5>
                            </div>

                            <!-- Payment Button -->
                            <div class="text-center mt-4">
                                <button class="btn btn-lg btn-success px-5" onclick="handlePayment()">
                                    <i class="fas fa-credit-card"></i> Buat Pembayaran
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Order Recap Section -->
                <div class="col-md-4 offset-md-1">
                    <div class="bg-light rounded p-4">
                        <h5 class="text-center">Recap Pesanan</h5>
                        <div class="d-flex justify-content-between py-2">
                            <span>Jumlah Kontrak</span>
                            <span>RM {{ number_format($booking->total_payment, 2) }}</span>
                        </div>
                        <div class="d-flex justify-content-between py-2">
                            <span>Diskaun</span>
                            <span>- RM 0.00</span>
                        </div>
                        <div class="d-flex justify-content-between border-top pt-2 mt-2">
                            <strong>Jumlah Akhir</strong>
                            <strong class="text-primary">RM {{ number_format($booking->total_payment, 2) }}</strong>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section> --}}

    <section style="background: #f6f9ff;">
        <div class="container rounded bg-white">
            <div class="row d-flex justify-content-center pb-5">
                <div class="col-sm-5 col-md-5 ml-1">
                    <div class="py-4 d-flex flex-row">
                        <h3 class="sitename">MyTukang<span style="color: #feb900">.</span></h3>
                    </div>
                    <h4 class="green">RM {{$quotation->booking->total_payment}}</h4>
                    <h4>{{$quotation->booking->subService->name}}</h4>
            
                    <hr>

                    <div class="pt-2">
                        <div class="d-flex">
                        <p><b>No. Tempahan:</b> #{{$quotation->booking->id}}</p>
                        </div>
                        <div class="d-flex">
                            <div><p><b>Servis:</b> {{$quotation->booking->service->name}}</div>
                            <div class="ml-auto p-2"><p class="text-primary"></div>
                        </div>
                        <p>
                            Ini adalah jumlah bayaran yang perlu dibuat bagi memulakan proses kerja pembaikan agar dapat dijalankan. 
                            Sila pastikan untuk menyelesaikan bayaran ini bagi mengelakkan sebarang kelewatan dalam proses pembaikan rumah anda.
                        </p>
                        <div>
                            <input type="button" value="Teruskan ke Pembayaran" class="btn btn-warning btn-block" onclick="window.location.href='{{ route('payment.create', ['bookingId' => $quotation->booking->id, 'quotationId' => $quotation->id])}}';">
                        </div>
                    </div>
                </div>
                <div class="col-sm-3 col-md-4 offset-md-1 mobile">
                    <div class="py-4 d-flex justify-content-end">
                        <h6><a href="{{route('booking.progress', ['id' => $quotation->booking->id])}}">Kembali ke Jejak Tempahan</a></h6>
                    </div>
                    <div class="bg-light rounded d-flex flex-column">
                        <div class="p-2 ml-3">
                            <h4 class="text-center">Senarai Harga</h4>
                        </div>
                    
                        @if (!empty($items))
                            @foreach ($items as $index => $item)
                                <div class="p-2 d-flex">
                                    <div class="col-8"><h6>{{ $item['scope_of_work'] }}</h6></div>
                                    <div class="ml-auto">{{ $item['quantity'] }} qty</div>
                                </div>
                                <div class="p-2 d-flex">
                                    <div class="col-8">Harga seunit</div>
                                    <div class="ml-auto">RM {{ number_format($item['unit_price'], 2) }}</div>
                                </div>
                                <div class="p-2 d-flex">
                                    <div class="col-8">Jumlah</div>
                                    <div class="ml-auto">RM {{ number_format($item['total_price'], 2) }}</div>
                                </div>
                                <div class="border-top px-4 mx-3"></div>
                            @endforeach
                        @else
                            <div class="p-2 text-center">
                                <p>Tiada item sebut harga tersedia.</p>
                            </div>
                        @endif
                    
                        <div class="p-2 d-flex pt-3">
                            <div class="col-8"><b>Total Keseluruhan</b></div>
                            <div class="ml-auto"><b class="green">RM {{ number_format($quotation->booking->total_payment, 2) }}</b></div>
                        </div>
                    </div>
                    
                </div>        
            </div>
        </div>
    
    </section>

    <script>
        var win = navigator.platform.indexOf('Win') > -1;
        if (win && document.querySelector('#sidenav-scrollbar')) {
            var options = {
                damping: '0.5'
            }
            Scrollbar.init(document.querySelector('#sidenav-scrollbar'), options);
        }
    </script>

    <!-- Control Center for Soft Dashboard: parallax effects, scripts for the example pages etc -->
    <script src="{{ asset('assets/js/soft-ui-dashboard.min.js?v=1.0.3') }}"></script>


@endsection
