<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">

    <title>@yield('title', 'MyTukang')</title>

    <meta name="csrf-token" content="{{ csrf_token() }}">

    <meta content="" name="description">
    <meta content="" name="keywords">

    <!-- bootstrap css -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">

    <!-- Favicons -->
    <link rel="icon" href="{{ asset('assets/img/favicon.png') }} ">
    <link rel="apple-touch-ico" href="{{ asset('assets/img/apple-touch-icon.png') }} ">

    <!-- Fonts and Icons -->
    <link href="https://fonts.googleapis.com" rel="preconnect">
    <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&family=Open+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;0,800;1,300;1,400;1,500;1,600;1,700;1,800&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
        rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">



    <!-- Vendor CSS Files -->
    <link rel="stylesheet" href="{{ asset('assets/vendor/bootstrap/css/bootstrap.min.css') }} ">
    <link rel="stylesheet" href="{{ asset('assets/vendor/bootstrap-icons/bootstrap-icons.css') }} ">
    <link rel="stylesheet" href="{{ asset('assets/vendor/aos/aos.css') }} ">
    <link rel="stylesheet" href="{{ asset('assets/vendor/glightbox/css/glightbox.min.css') }} ">
    <link rel="stylesheet" href="{{ asset('assets/vendor/swiper/swiper-bundle.min.css') }} ">

    <!-- Main CSS File -->
    <link rel="stylesheet" href="{{ asset('assets/css/main.css') }} ">

    <style>
        /* Logout Button */
        .dropdown ul li form button {
            background: none;
            border: none;
            padding: 0;
            font: inherit;
            text-align: left;
            display: block;
            width: 100%;
        }

        .dropdown ul li form button:hover {
            color: #feb900;
            /* Same hover color as other dropdown items */
        }


        /* Profile Menu */
        .profile-menu {
            display: flex;
            align-items: center;
            cursor: pointer;
        }

        .profile-menu .profile-image {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            margin-right: 8px;
        }

        .profile-menu i.toggle-dropdown {
            margin-left: 5px;
        }

        /* Mobile Toggle */
        .mobile-nav-toggle {
            display: none;
            font-size: 24px;
            cursor: pointer;
        }

        @media (max-width: 768px) {
            .mobile-nav-toggle {
                display: block;
            }

            .navmenu ul {
                display: none;
                flex-direction: column;
            }

            .navmenu ul li {
                margin: 10px 0;
            }

            .mobile-nav-toggle.active+.navmenu ul {
                display: flex;
            }
        }
    </style>

</head>

<body class="index-page">

    <header id="header" class="header d-flex align-items-center fixed-top">
        <div class="container-fluid container-xl position-relative d-flex align-items-center justify-content-between">

            <a href="/" class="logo d-flex align-items-center">
                <!-- Uncomment the line below if you also wish to use an image logo -->
                <!-- <img src="assets/img/logo.png" alt=""> -->
                <h1 class="sitename">MyTukang</h1> <span style="color: #feb900">.</span>
            </a>

            <nav id="navmenu" class="navmenu">
                <ul>
                    <li><a href="{{ route('user.homepage') }}" class="active">Laman Utama</a></li>
                    <li><a href="#services">Servis Kami</a></li>
                    <li><a href="#projects">Projek</a></li>
                    {{-- <li><a href="#testimonials">Testimoni</a></li> --}}
                    <li class="dropdown">
                        <a href="#"><span>Servis</span> <i class="bi bi-chevron-down toggle-dropdown"></i></a>
                        <ul>
                            <li><a href="{{ route('booking.create') }}">Tempah Sekarang</a></li>
                            <li><a href="{{ route('booking.index') }}">Senarai Tempahan</a></li>
                        </ul>
                    </li>

                    {{-- Check if the user is logged in --}}
                    @auth
                    <li class="dropdown">
                        <a href="#" class="profile-menu">
                            <img src="{{ auth()->user()->profile_image ? asset('uploads/profile_images/' . auth()->user()->profile_image) : asset('assets/img/profile.png') }}"
                                alt="Profile" class="profile-image">

                            <i class="bi bi-chevron-down toggle-dropdown"></i>
                        </a>
                        <ul>
                            <li><a href="{{ route('user.profile') }}"
                                    class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Profil</a></li>
                            <li>
                                <form method="POST" action="{{ route('logout') }}" class="block px-4 py-2">
                                    @csrf
                                    <button type="submit"
                                        class="text-sm text-gray-700 hover:bg-gray-100 w-full text-left">
                                        Log Keluar
                                    </button>
                                </form>
                            </li>
                        </ul>
                    </li>
                    @else
                    {{-- Show login and register links if the user is not logged in --}}
                    <li><a href="{{ route('login') }}" class="font-semibold">Log Masuk</a></li>
                    @if (Route::has('register'))
                    <li><a href="{{ route('register') }}" class="font-semibold">Daftar Masuk</a></li>
                    @endif
                    @endauth
                </ul>
                <i class="mobile-nav-toggle d-xl-none bi bi-list"></i>
            </nav>


        </div>
    </header>

    <main class="main">

        @yield('content')

    </main>

    <footer id="footer" class="footer bg-dark text-light py-5">
        <div class="container footer-top">
            <div class="row gy-4">
                <!-- About Section -->
                <div class="col-lg-4 col-md-6 footer-about">
                    <a href="index.html" class="logo d-flex align-items-center mb-3">
                        <h2 class="sitename text-warning">MyTukang</h2>
                    </a>
                    <p>Taman Pendamar Indah, <br> 42000 Pelabuhan Klang</p>
                    <p class="mt-3">
                        <strong>Telefon:</strong> <span>+60 118765213</span><br>
                        <strong>Emel:</strong> <span>info@mytukang.com</span>
                    </p>
                </div>

                <!-- Useful Links Section -->
                <div class="col-lg-2 col-md-3 footer-links">
                    <h4 class="text-warning">Pautan Berguna</h4>
                    <ul class="list-unstyled">
                        <li><a href="#" class="text-light text-decoration-none">Laman Utama</a></li>
                        <li><a href="#" class="text-light text-decoration-none">Tentang Kami</a></li>
                        <li><a href="#" class="text-light text-decoration-none">Servis Kami</a></li>
                        <!-- <li><a href="#" class="text-light text-decoration-none">Tempahan Sekarang</a></li> -->
                        <li><a href="#" class="text-light text-decoration-none">Senarai Tempahan</a></li>
                        <li><a href="#" class="text-light text-decoration-none">Profil</a></li>
                    </ul>
                </div>

                <!-- Social Media Section -->
                <div class="col-lg-3 col-md-6 footer-links">
                    <h4 class="text-warning">Ikuti Kami</h4>
                    <div class="d-flex align-items-center">
                        <a href="#" class="btn btn-warning me-2 rounded-circle">
                            <i class="fab fa-facebook-f"></i>
                        </a>
                        <a href="#" class="btn btn-warning me-2 rounded-circle">
                            <i class="fab fa-twitter"></i>
                        </a>
                        <a href="#" class="btn btn-warning me-2 rounded-circle">
                            <i class="fab fa-instagram"></i>
                        </a>
                        <a href="#" class="btn btn-warning rounded-circle">
                            <i class="fab fa-linkedin-in"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Footer Bottom -->
        <div class="container text-center mt-4">
            <p class="mb-0">
                © <span class="text-warning">2025</span>
                <strong class="px-1 sitename text-warning">MyTukang</strong>
                <span>Hak Cipta Terpelihara.</span>
            </p>
        </div>
    </footer>


    <!-- Scroll Top -->
    <a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center"><i
            class="bi bi-arrow-up-short"></i></a>

    <!-- Preloader -->
    <div id="preloader"></div>

    <!-- SweetAlert2 -->
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <!-- Vendor JS Files -->
    <script src="{{ asset('assets/vendor/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('assets/vendor/php-email-form/validate.js') }}"></script>
    <script src="{{ asset('assets/vendor/aos/aos.js') }}"></script>
    <script src="{{ asset('assets/vendor/glightbox/js/glightbox.min.js') }}"></script>
    <script src="{{ asset('assets/vendor/imagesloaded/imagesloaded.pkgd.min.js') }}"></script>
    <script src="{{ asset('assets/vendor/isotope-layout/isotope.pkgd.min.js') }}"></script>
    <script src="{{ asset('assets/vendor/swiper/swiper-bundle.min.js') }}"></script>
    <script src="{{ asset('assets/vendor/purecounter/purecounter_vanilla.js') }}"></script>

    <!-- Main JS File -->
    <script src="{{ asset('assets/js/main.js') }}"></script>


</body>

@if(session('success'))
<script>
    if (!sessionStorage.getItem('shownToast')) {
        Swal.fire({
            toast: true,
            position: 'top-end',
            icon: 'success',
            title: "{{ session('success') }}",
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
        });
        sessionStorage.setItem('shownToast', 'true');
    }
</script>
@endif

@if(session('error'))
<script>
    Swal.fire({
        toast: true,
        position: 'top-end',
        icon: 'error',
        title: "{{ session('error') }}",
        showConfirmButton: false,
        timer: 3000,
        timerProgressBar: true,
    });
</script>
@endif

@if($errors->any())
<script>
    Swal.fire({
        toast: true,
        position: 'top-end',
        icon: 'error',
        title: 'Sila semak dan betulkan input yang tidak sah.',
        showConfirmButton: false,
        timer: 3000,
        timerProgressBar: true,
    });
</script>
@endif

@if($errors->has('alt_time'))
<script>
    Swal.fire({
        toast: true,
        position: 'top-end',
        icon: 'error',
        title: "{{ $errors->first('alt_time') }}",
        showConfirmButton: false,
        timer: 3000,
        timerProgressBar: true,
    });
</script>
@endif

@if(session('info'))
<script>
    Swal.fire({
        toast: true,
        position: 'top-end',
        icon: 'info',
        title: "{{ session('info') }}",
        showConfirmButton: false,
        timer: 3000,
        timerProgressBar: true,
    });
</script>
@endif

@if(session('warning'))
<script>
    Swal.fire({
        toast: true,
        position: 'top-end',
        icon: 'warning',
        title: "{{ session('warning') }}",
        showConfirmButton: false,
        timer: 3000,
        timerProgressBar: true,
    });
</script>
@endif

<script>
    // Clear the toast flag when navigating away from the page
    window.addEventListener('beforeunload', function () {
        sessionStorage.removeItem('shownToast');
    });
</script>


</html>