@extends('layouts.base')

@section('title', 'Laman Utama')

@section('content')


<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">

<!-- Hero Section -->
<section id="hero" class="hero section">
5.
    <div class="info d-flex align-items-center">
      <div class="container">
        <div class="row justify-content-center" data-aos="fade-up" data-aos-delay="100">
          <div class="col-lg-6 text-center">
            <h2 class="">MyTukang<span style="color: #feb900">.</span> Sedia Membantu</h2>
            <p>Selamat datang ke MyTukang! Kami di sini untuk membantu anda dengan perkhidmatan membaiki rumah yang pantas dan berkualiti. Tempah sekarang dan nikmati kemudahan perkhidmatan yang mudah dan efisien.</p>
            <a href="{{route('booking.create')}}" class="btn-get-started">Tempah Sekarang</a>
          </div>
        </div>
      </div>
    </div>

    <div id="hero-carousel" class="carousel slide" data-bs-ride="carousel" data-bs-interval="5000">

      <div class="carousel-item">
        <img src="{{ asset('assets/img/hero-carousel/hero-carousel-1.jpg') }}" alt="">
      </div>

      <div class="carousel-item active">
        <img src="{{ asset('assets/img/hero-carousel/hero-carousel-2.jpg') }}" alt="">
      </div>

      <div class="carousel-item">
        <img src="{{ asset('assets/img/hero-carousel/hero-carousel-3.jpg') }}" alt="">
      </div>

      <div class="carousel-item">
        <img src="{{ asset('assets/img/hero-carousel/hero-carousel-4.jpg') }}" alt="">
      </div>

      <div class="carousel-item">
        <img src="{{ asset('assets/img/hero-carousel/hero-carousel-5.jpg') }}" alt="">
      </div>

      <a class="carousel-control-prev" href="#hero-carousel" role="button" data-bs-slide="prev">
        <span class="carousel-control-prev-icon bi bi-chevron-left" aria-hidden="true"></span>
      </a>

      <a class="carousel-control-next" href="#hero-carousel" role="button" data-bs-slide="next">
        <span class="carousel-control-next-icon bi bi-chevron-right" aria-hidden="true"></span>
      </a>

    </div>

  </section><!-- /Hero Section -->



  <!-- Services Section -->
  <section id="services" class="services section">
    <!-- Section Title -->
    <div class="container section-title" data-aos="fade-up">
      <h2>Servis Kami</h2>
      <p>Kami menyediakan servis berkualiti untuk memenuhi keperluan anda, daripada pembaikan hingga pemasangan.</p>
    </div><!-- End Section Title -->

    <div class="container">
      <div class="row gy-4">
        <!-- Service Item: Elektrik -->
        <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="100">
          <div class="service-item position-relative">
            <div class="icon">
              <i class="fa-solid fa-plug"></i>
            </div>
            <h3>Pembaikan dan Pemasangan Elektrik</h3>
            <p>Kami menyediakan perkhidmatan pembaikan dan pemasangan elektrik untuk memastikan sistem elektrik anda berfungsi dengan cekap dan selamat.</p>
            <a href="#" class="readmore stretched-link" data-bs-toggle="modal" data-bs-target="#modalElektrik">Baca lebih lanjut <i class="bi bi-arrow-right"></i></a>
          </div>
        </div><!-- End Service Item -->

        <!-- Service Item: Paip -->
        <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="200">
          <div class="service-item position-relative">
            <div class="icon">
              <i class="fa-solid fa-wrench"></i>
            </div>
            <h3>Pembaikan dan Pemasangan Paip</h3>
            <p>Kami menyediakan perkhidmatan pembaikan dan pemasangan paip untuk memastikan sistem saliran anda berfungsi dengan baik.</p>
            <a href="#" class="readmore stretched-link" data-bs-toggle="modal" data-bs-target="#modalPaip">Baca lebih lanjut <i class="bi bi-arrow-right"></i></a>
          </div>
        </div><!-- End Service Item -->

        <!-- Service Item: Pintu -->
        <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="300">
          <div class="service-item position-relative">
            <div class="icon">
              <i class="fa-solid fa-door-open"></i>
            </div>
            <h3>Pembaikan dan Pemasangan Pintu</h3>
            <p>Kami menyediakan perkhidmatan pembaikan dan pemasangan pintu untuk memastikan pintu anda kukuh dan berfungsi dengan sempurna.</p>
            <a href="#" class="readmore stretched-link" data-bs-toggle="modal" data-bs-target="#modalPintu">Baca lebih lanjut <i class="bi bi-arrow-right"></i></a>
          </div>
        </div><!-- End Service Item -->
      </div>
    </div>

    <!-- Modal for Elektrik -->
    <div class="modal fade" id="modalElektrik" tabindex="-1" aria-labelledby="modalElektrikLabel" aria-hidden="true">
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="modalElektrikLabel">Pembaikan dan Pemasangan Elektrik</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <ul>
              <li>Pendawaian lampu</li>
              <li>Pendawaian kipas</li>
              <li>Pendawaian soket plug</li>
              <li>Pemasangan lampu</li>
              <li>Pemasangan kipas</li>
              <li>Pemasangan water heater</li>
              <li>Pemasangan plug</li>
              <li>Pemasangan suis</li>
              <li>Naik taraf suis</li>
            </ul>
          </div>
        </div>
      </div>
    </div>

    <!-- Modal for Paip -->
    <div class="modal fade" id="modalPaip" tabindex="-1" aria-labelledby="modalPaipLabel" aria-hidden="true">
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="modalPaipLabel">Pembaikan dan Pemasangan Paip</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <ul>
              <li>Pembaikan paip bocor</li>
              <li>Pembaikan paip tersumbat</li>
              <li>Pembaikan sinki</li>
              <li>Pembaikan tandas tersumbat</li>
              <li>Pembaikan kepala paip & injap</li>
            </ul>
          </div>
        </div>
      </div>
    </div>

    <!-- Modal for Pintu -->
    <div class="modal fade" id="modalPintu" tabindex="-1" aria-labelledby="modalPintuLabel" aria-hidden="true">
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="modalPintuLabel">Pembaikan dan Pemasangan Pintu</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <ul>
              <li>Pembaikan engsel pintu</li>
              <li>Pembaikan pemegang pintu</li>
              <li>Penyesuaian bingkai pintu</li>
              <li>Pemasangan pintu baru (kayu, besi, PVC)</li>
            </ul>
          </div>
        </div>
      </div>
    </div>

  </section><!-- End Services Section -->


  <!-- Projects Section -->
  <section id="projects" class="projects section">

    <!-- Section Title -->
    <div class="container section-title" data-aos="fade-up">
      <h2 class="">Projek Kami</h2>
      <p>Pelbagai projek berkualiti tinggi yang telah kami jayakan untuk memenuhi keperluan pelanggan.</p>
    </div><!-- End Section Title -->


    <div class="container">

      <div class="isotope-layout" data-default-filter="*" data-layout="masonry" data-sort="original-order">

        <ul class="portfolio-filters isotope-filters" data-aos="fade-up" data-aos-delay="100">
          <li data-filter="*" class="filter-active">Semua</li>
          <li data-filter=".filter-remodeling">Elektrik</li>
          <li data-filter=".filter-construction">Baiki Paip</li>
          <li data-filter=".filter-repairs">Baiki Pintu</li>
          {{-- <li data-filter=".filter-design">Design</li> --}}
        </ul><!-- End Portfolio Filters -->

        <div class="row gy-4 isotope-container" data-aos="fade-up" data-aos-delay="200">

          <div class="col-lg-4 col-md-6 portfolio-item isotope-item filter-remodeling">
            <div class="portfolio-content h-100">
              <img src="assets/img/projects/remodeling-1.jpg" class="img-fluid" alt="">
              <div class="portfolio-info">
                <h4>App 1</h4>
                {{-- <p>Lorem ipsum, dolor sit amet consectetur</p> --}}
                <a href="assets/img/projects/remodeling-1.jpg" title="App 1" data-gallery="portfolio-gallery-app" class="glightbox preview-link"><i class="bi bi-zoom-in"></i></a>
                <a href="project-details.html" title="More Details" class="details-link"><i class="bi bi-link-45deg"></i></a>
              </div>
            </div>
          </div><!-- End Portfolio Item -->

          <div class="col-lg-4 col-md-6 portfolio-item isotope-item filter-construction">
            <div class="portfolio-content h-100">
              <img src="assets/img/projects/construction-1.jpg" class="img-fluid" alt="">
              <div class="portfolio-info">
                <h4>Product 1</h4>
                {{-- <p>Lorem ipsum, dolor sit amet consectetur</p> --}}
                <a href="assets/img/projects/construction-1.jpg" title="Product 1" data-gallery="portfolio-gallery-product" class="glightbox preview-link"><i class="bi bi-zoom-in"></i></a>
                <a href="project-details.html" title="More Details" class="details-link"><i class="bi bi-link-45deg"></i></a>
              </div>
            </div>
          </div><!-- End Portfolio Item -->

          <div class="col-lg-4 col-md-6 portfolio-item isotope-item filter-repairs">
            <div class="portfolio-content h-100">
              <img src="assets/img/projects/repairs-1.jpg" class="img-fluid" alt="">
              <div class="portfolio-info">
                <h4>Branding 1</h4>
                {{-- <p>Lorem ipsum, dolor sit amet consectetur</p> --}}
                <a href="assets/img/projects/repairs-1.jpg" title="Branding 1" data-gallery="portfolio-gallery-branding" class="glightbox preview-link"><i class="bi bi-zoom-in"></i></a>
                <a href="project-details.html" title="More Details" class="details-link"><i class="bi bi-link-45deg"></i></a>
              </div>
            </div>
          </div><!-- End Portfolio Item -->

          <div class="col-lg-4 col-md-6 portfolio-item isotope-item filter-design">
            <div class="portfolio-content h-100">
              <img src="assets/img/projects/design-1.jpg" class="img-fluid" alt="">
              <div class="portfolio-info">
                <h4>Books 1</h4>
                {{-- <p>Lorem ipsum, dolor sit amet consectetur</p> --}}
                <a href="assets/img/projects/design-1.jpg" title="Branding 1" data-gallery="portfolio-gallery-book" class="glightbox preview-link"><i class="bi bi-zoom-in"></i></a>
                <a href="project-details.html" title="More Details" class="details-link"><i class="bi bi-link-45deg"></i></a>
              </div>
            </div>
          </div><!-- End Portfolio Item -->

          <div class="col-lg-4 col-md-6 portfolio-item isotope-item filter-remodeling">
            <div class="portfolio-content h-100">
              <img src="assets/img/projects/remodeling-2.jpg" class="img-fluid" alt="">
              <div class="portfolio-info">
                <h4>App 2</h4>
                {{-- <p>Lorem ipsum, dolor sit amet consectetur</p> --}}
                <a href="assets/img/projects/remodeling-2.jpg" title="App 2" data-gallery="portfolio-gallery-app" class="glightbox preview-link"><i class="bi bi-zoom-in"></i></a>
                <a href="project-details.html" title="More Details" class="details-link"><i class="bi bi-link-45deg"></i></a>
              </div>
            </div>
          </div><!-- End Portfolio Item -->

          <div class="col-lg-4 col-md-6 portfolio-item isotope-item filter-construction">
            <div class="portfolio-content h-100">
              <img src="assets/img/projects/construction-2.jpg" class="img-fluid" alt="">
              <div class="portfolio-info">
                <h4>Product 2</h4>
                {{-- <p>Lorem ipsum, dolor sit amet consectetur</p> --}}
                <a href="assets/img/projects/construction-2.jpg" title="Product 2" data-gallery="portfolio-gallery-product" class="glightbox preview-link"><i class="bi bi-zoom-in"></i></a>
                <a href="project-details.html" title="More Details" class="details-link"><i class="bi bi-link-45deg"></i></a>
              </div>
            </div>
          </div><!-- End Portfolio Item -->

          <div class="col-lg-4 col-md-6 portfolio-item isotope-item filter-repairs">
            <div class="portfolio-content h-100">
              <img src="assets/img/projects/repairs-2.jpg" class="img-fluid" alt="">
              <div class="portfolio-info">
                <h4>Branding 2</h4>
                {{-- <p>Lorem ipsum, dolor sit amet consectetur</p> --}}
                <a href="assets/img/projects/repairs-2.jpg" title="Branding 2" data-gallery="portfolio-gallery-branding" class="glightbox preview-link"><i class="bi bi-zoom-in"></i></a>
                <a href="project-details.html" title="More Details" class="details-link"><i class="bi bi-link-45deg"></i></a>
              </div>
            </div>
          </div><!-- End Portfolio Item -->

          <div class="col-lg-4 col-md-6 portfolio-item isotope-item filter-design">
            <div class="portfolio-content h-100">
              <img src="assets/img/projects/design-2.jpg" class="img-fluid" alt="">
              <div class="portfolio-info">
                <h4>Books 2</h4>
                {{-- <p>Lorem ipsum, dolor sit amet consectetur</p> --}}
                <a href="assets/img/projects/design-2.jpg" title="Branding 2" data-gallery="portfolio-gallery-book" class="glightbox preview-link"><i class="bi bi-zoom-in"></i></a>
                <a href="project-details.html" title="More Details" class="details-link"><i class="bi bi-link-45deg"></i></a>
              </div>
            </div>
          </div><!-- End Portfolio Item -->

          <div class="col-lg-4 col-md-6 portfolio-item isotope-item filter-remodeling">
            <div class="portfolio-content h-100">
              <img src="assets/img/projects/remodeling-3.jpg" class="img-fluid" alt="">
              <div class="portfolio-info">
                <h4>App 3</h4>
                {{-- <p>Lorem ipsum, dolor sit amet consectetur</p> --}}
                <a href="assets/img/projects/remodeling-3.jpg" title="App 3" data-gallery="portfolio-gallery-app" class="glightbox preview-link"><i class="bi bi-zoom-in"></i></a>
                <a href="project-details.html" title="More Details" class="details-link"><i class="bi bi-link-45deg"></i></a>
              </div>
            </div>
          </div><!-- End Portfolio Item -->

          <div class="col-lg-4 col-md-6 portfolio-item isotope-item filter-construction">
            <div class="portfolio-content h-100">
              <img src="assets/img/projects/construction-3.jpg" class="img-fluid" alt="">
              <div class="portfolio-info">
                <h4>Product 3</h4>
                {{-- <p>Lorem ipsum, dolor sit amet consectetur</p> --}}
                <a href="assets/img/projects/construction-3.jpg" title="Product 3" data-gallery="portfolio-gallery-product" class="glightbox preview-link"><i class="bi bi-zoom-in"></i></a>
                <a href="project-details.html" title="More Details" class="details-link"><i class="bi bi-link-45deg"></i></a>
              </div>
            </div>
          </div><!-- End Portfolio Item -->

          <div class="col-lg-4 col-md-6 portfolio-item isotope-item filter-repairs">
            <div class="portfolio-content h-100">
              <img src="assets/img/projects/repairs-3.jpg" class="img-fluid" alt="">
              <div class="portfolio-info">
                <h4>Branding 3</h4>
                {{-- <p>Lorem ipsum, dolor sit amet consectetur</p> --}}
                <a href="assets/img/projects/repairs-3.jpg" title="Branding 2" data-gallery="portfolio-gallery-branding" class="glightbox preview-link"><i class="bi bi-zoom-in"></i></a>
                <a href="project-details.html" title="More Details" class="details-link"><i class="bi bi-link-45deg"></i></a>
              </div>
            </div>
          </div><!-- End Portfolio Item -->

          <div class="col-lg-4 col-md-6 portfolio-item isotope-item filter-design">
            <div class="portfolio-content h-100">
              <img src="assets/img/projects/design-3.jpg" class="img-fluid" alt="">
              <div class="portfolio-info">
                <h4>Books 3</h4>
                {{-- <p>Lorem ipsum, dolor sit amet consectetur</p> --}}
                <a href="assets/img/projects/design-3.jpg" title="Branding 3" data-gallery="portfolio-gallery-book" class="glightbox preview-link"><i class="bi bi-zoom-in"></i></a>
                <a href="project-details.html" title="More Details" class="details-link"><i class="bi bi-link-45deg"></i></a>
              </div>
            </div>
          </div><!-- End Portfolio Item -->

        </div><!-- End Portfolio Container -->

      </div>

    </div>

  </section><!-- /Projects Section -->

  
@endsection