<!DOCTYPE html>
<html lang="">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>@yield('title', 'Log Masuk')</title>

  <!-- CSRF Token -->
  {{-- <meta name="csrf-token" content="{{ csrf_token() }}"> --}}

  <!-- bootstrap css -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet"
    integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">

  {{-- tab image --}}

  <!-- Favicons -->
  <link rel="icon" href="{{ asset('assets/img/favicon.png') }} ">
  <link rel="apple-touch-ico" href="{{ asset('assets/img/apple-touch-icon.png') }} ">

  <!-- Fonts and Icons -->
  <link href="https://fonts.googleapis.com" rel="preconnect">
  <script src="https://kit.fontawesome.com/42d5adcbca.js" crossorigin="anonymous"></script>
  <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&family=Open+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;0,800;1,300;1,400;1,500;1,600;1,700;1,800&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
    rel="stylesheet">

  <!-- Main CSS File -->
  <link id="pagestyle" href=" {{ asset('assets/css/soft-ui-dashboard.css?v=1.0.3') }} " rel="stylesheet">

</head>

<body class="">
  <main class="main-content  mt-0">
    <section>
      <div class="page-header min-vh-100">
        <div class="container">
          <div class="row">
            <div class="col-xl-4 col-lg-5 col-md-7 d-flex flex-column mx-lg-0 mx-auto">
              <div class="card card-plain">
                <div class="card-header pb-0 text-start">
                  <h4 class="font-weight-bolder">Log Masuk</h4>
                  <p class="mb-0">Masukkan emel dan kata laluan anda untuk log masuk</p>
                </div>
                <div class="card-body">
                  <form method="POST" action="{{ route('login.action') }}">
                    @csrf
                    @if ($errors->any())
                    <div class="alert alert-danger" role="alert">
                      <strong class="fw-bold">Error!</strong>
                      <ul>
                        @foreach ($errors->all() as $error)
                        <li><span>{{ $error }}</span></li>
                        @endforeach
                      </ul>
                    </div>
                    @endif

                    <div class="mb-3">
                      <input id="email" type="email" class="form-control form-control-lg" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus placeholder="Email">
                      @error('email')
                      <span class="invalid-feedback" role="alert">
                        <strong>{{ $message }}</strong>
                      </span>
                      @enderror
                    </div>

                    <div class="mb-3">
                      <input type="password" class="form-control form-control-lg" name="password" required autocomplete="current-password" placeholder="Kata Laluan">
                      @error('password')
                      <span class="invalid-feedback" role="alert">
                        <strong>{{ $message }}</strong>
                      </span>
                      @enderror
                    </div>

                    <!-- <div class="row">
                      <div class="form-check" style="padding-left: 2.73em">
                        <input class="form-check-input" type="checkbox" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>
                        <label class="form-check-label" for="remember">Ingat Saya</label>
                      </div>
                    </div> -->

                    <div class="text-center mb-4">
                      <button type="submit" class="btn btn-lg bg-gradient-warning btn-lg w-100 mt-4 mb-0">Log Masuk</button>
                      <a style="color: gray; font-size:12px;" href="{{ route('password.request') }}">
                        Lupa Kata Laluan?
                      </a>
                    </div>

                    <div class="card-footer text-center pt-0 px-lg-2 px-1">
                      <p class="mb-4 text-sm mx-auto">
                        Tidak mempunyai akaun?
                        <a href="{{ route('register') }}" class="text-warning font-weight-bold">Daftar Masuk</a>
                      </p>
                    </div>
                  </form>
                </div>


              </div>
            </div>
            <div class="col-6 d-lg-flex d-none h-100 my-auto pe-0 position-absolute top-0 end-0 text-center justify-content-center flex-column">
              <div class="position-relative bg-gradient-warning h-100 m-3 px-7 border-radius-lg d-flex flex-column justify-content-center">
                <img src="{{asset('assets/img/pattern-lines.svg') }}" alt="pattern-lines" class="position-absolute opacity-4 start-0">
                <div class="position-relative">
                  <img class="max-width-300 w-100 position-relative z-index-2" src="{{ asset ('assets/img/repair.png') }}" alt="chat-img">
                </div>
                <h4 class="mt-3 text-white font-weight-bolder"><i>"Home is where we should feel secure and comfortable."</i></h4>
                <p class="text-white">- Catherine Pulsifer -</p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </main>
  <!--   Core JS Files   -->

  <script src="{{ asset('assets/js/core/popper.min.js')}}"></script>
  <script src="{{ asset('assets/js/core/bootstrap.min.js')}}"></script>
  <script src="{{ asset('assets/js/plugins/perfect-scrollbar.min.js')}}"></script>
  <script src="{{ asset('assets/js/plugins/smooth-scrollbar.min.js')}}"></script>

  <!-- Kanban scripts -->
  <script src="{{ asset('assets/js/plugins/dragula/dragula.min.js')}}"></script>
  <script src="{{ asset ('assets/js/plugins/jkanban/jkanban.js')}}"></script>
  <script>
    var win = navigator.platform.indexOf('Win') > -1;
    if (win && document.querySelector('#sidenav-scrollbar')) {
      var options = {
        damping: '0.5'
      }
      Scrollbar.init(document.querySelector('#sidenav-scrollbar'), options);
    }
  </script>

  <!-- Github buttons -->
  <script async defer src="https://buttons.github.io/buttons.js"></script>
  <!-- Control Center for Soft Dashboard: parallax effects, scripts for the example pages etc -->
  <script src="{{asset('assets/js/soft-ui-dashboard.min.js?v=1.0.3')}}"></script>
</body>

<!-- Add SweetAlert2 -->
<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<!-- Show success message -->
@if(session('success'))
<script>
  Swal.fire({
    toast: true,
    position: 'top-end',
    icon: 'success',
    title: "{{ session('success') }}",
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
  });
</script>
@endif

<!-- Show error message -->
@if(session('error'))
<script>
  Swal.fire({
    toast: true,
    position: 'top-end',
    icon: 'error',
    title: "{{ session('error') }}",
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
  });
</script>
@endif

<!-- Show Laravel validation errors (as a general error toast) -->
@if ($errors->any())
<script>
  Swal.fire({
    toast: true,
    position: 'top-end',
    icon: 'error',
    title: "Sila semak dan betulkan input yang salah.",
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
  });
</script>
@endif


</html>