@extends('layouts.baseAdmin')

@section('title', 'Sebut Harga')

@section('content')

<style>
    .no-outline{
        border: none;
        outline: none;
    }
</style>

    <!-- Navbar -->
    <nav class="navbar navbar-main navbar-expand-lg position-sticky mt-4 top-1 px-0 mx-4 shadow-none border-radius-xl z-index-sticky"
        id="navbarBlur" data-scroll="true">
        <div class="container-fluid py-1 px-3">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb bg-transparent mb-0 pb-0 pt-1 px-0 me-sm-6 me-5">
                    <li class="breadcrumb-item text-sm">
                        <a class="opacity-3 text-dark" href="javascript:;">
                            <svg width="12px" height="12px" class="mb-1" viewBox="0 0 45 40" version="1.1"
                                xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                                <title>shop </title>
                                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                    <g transform="translate(-1716.000000, -439.000000)" fill="#252f40" fill-rule="nonzero">
                                        <g transform="translate(1716.000000, 291.000000)">
                                            <g transform="translate(0.000000, 148.000000)">
                                                <path
                                                    d="M46.7199583,10.7414583 L40.8449583,0.949791667 C40.4909749,0.360605034 39.8540131,0 39.1666667,0 L7.83333333,0 C7.1459869,0 6.50902508,0.360605034 6.15504167,0.949791667 L0.280041667,10.7414583 C0.0969176761,11.0460037 -1.23209662e-05,11.3946378 -1.23209662e-05,11.75 C-0.00758042603,16.0663731 3.48367543,19.5725301 7.80004167,19.5833333 L7.81570833,19.5833333 C9.75003686,19.5882688 11.6168794,18.8726691 13.0522917,17.5760417 C16.0171492,20.2556967 20.5292675,20.2556967 23.494125,17.5760417 C26.4604562,20.2616016 30.9794188,20.2616016 33.94575,17.5760417 C36.2421905,19.6477597 39.5441143,20.1708521 42.3684437,18.9103691 C45.1927731,17.649886 47.0084685,14.8428276 47.0000295,11.75 C47.0000295,11.3946378 46.9030823,11.0460037 46.7199583,10.7414583 Z">
                                                </path>
                                                <path
                                                    d="M39.198,22.4912623 C37.3776246,22.4928106 35.5817531,22.0149171 33.951625,21.0951667 L33.92225,21.1107282 C31.1430221,22.6838032 27.9255001,22.9318916 24.9844167,21.7998837 C24.4750389,21.605469 23.9777983,21.3722567 23.4960833,21.1018359 L23.4745417,21.1129513 C20.6961809,22.6871153 17.4786145,22.9344611 14.5386667,21.7998837 C14.029926,21.6054643 13.533337,21.3722507 13.0522917,21.1018359 C11.4250962,22.0190609 9.63246555,22.4947009 7.81570833,22.4912623 C7.16510551,22.4842162 6.51607673,22.4173045 5.875,22.2911849 L5.875,44.7220845 C5.875,45.9498589 6.7517757,46.9451667 7.83333333,46.9451667 L19.5833333,46.9451667 L19.5833333,33.6066734 L27.4166667,33.6066734 L27.4166667,46.9451667 L39.1666667,46.9451667 C40.2482243,46.9451667 41.125,45.9498589 41.125,44.7220845 L41.125,22.2822926 C40.4887822,22.4116582 39.8442868,22.4815492 39.198,22.4912623 Z">
                                                </path>
                                            </g>
                                        </g>
                                    </g>
                                </g>
                            </svg>
                        </a>
                    </li>
                    <li class="breadcrumb-item text-sm"><a class="opacity-5 text-dark"
                            href="{{ route('quotation.list') }}">Sebut Harga</a></li>
                    <li class="breadcrumb-item text-sm text-dark active" aria-current="page">Menjana Sebut Harga</li>
                </ol>
                <h6 class="font-weight-bolder mb-0">Menjana Sebut Harga</h6>
            </nav>
            <div class="sidenav-toggler sidenav-toggler-inner d-xl-block d-none ">
                <a href="javascript:;" class="nav-link text-body p-0">
                    <div class="sidenav-toggler-inner">
                        <i class="sidenav-toggler-line"></i>
                        <i class="sidenav-toggler-line"></i>
                        <i class="sidenav-toggler-line"></i>
                    </div>
                </a>
            </div>
            <div class="collapse navbar-collapse mt-sm-0 mt-2 me-md-0 me-sm-4" id="navbar">
                <div class="ms-md-auto pe-md-3 d-flex align-items-center">
                    <div class="input-group">
                        <span class="input-group-text text-body"><i class="fas fa-search" aria-hidden="true"></i></span>
                        <input type="text" class="form-control" placeholder="Type here...">
                    </div>
                </div>
                <ul class="navbar-nav  justify-content-end">
                    <li class="nav-item d-flex align-items-center">
                        <form action="{{ route('logout') }}" method="POST" style="display:inline;">
                            @csrf
                            <button type="submit" class="nav-link text-body font-weight-bold px-0"
                                style="background: none; border: none;">
                                <i class="fa fa-user me-sm-1"></i>
                                <span class="d-sm-inline d-none">Log Keluar</span>
                            </button>
                        </form>
                    </li>
                    <li class="nav-item d-xl-none ps-3 d-flex align-items-center">
                        <a href="javascript:;" class="nav-link text-body p-0" id="iconNavbarSidenav">
                            <div class="sidenav-toggler-inner">
                                <i class="sidenav-toggler-line"></i>
                                <i class="sidenav-toggler-line"></i>
                                <i class="sidenav-toggler-line"></i>
                            </div>
                        </a>
                    </li>
                    <li class="nav-item px-3 d-flex align-items-center">
                        <a href="javascript:;" class="nav-link text-body p-0">
                            <i class="fa fa-cog fixed-plugin-button-nav cursor-pointer"></i>
                        </a>
                    </li>
                    <li class="nav-item dropdown pe-2 d-flex align-items-center">
                        <a href="javascript:;" class="nav-link text-body p-0" id="dropdownMenuButton"
                            data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="fa fa-bell cursor-pointer"></i>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end px-2 py-3 me-sm-n4" aria-labelledby="dropdownMenuButton">
                            <li class="mb-2">
                                <a class="dropdown-item border-radius-md" href="javascript:;">
                                    <div class="d-flex py-1">
                                        <div class="my-auto">
                                            <img src="{{asset('assets/img/team-2.jpg')}}" class="avatar avatar-sm  me-3 "
                                                alt="user image">
                                        </div>
                                        <div class="d-flex flex-column justify-content-center">
                                            <h6 class="text-sm font-weight-normal mb-1">
                                                <span class="font-weight-bold">New message</span> from Laur
                                            </h6>
                                            <p class="text-xs text-secondary mb-0">
                                                <i class="fa fa-clock me-1"></i>
                                                13 minutes ago
                                            </p>
                                        </div>
                                    </div>
                                </a>
                            </li>
                            <li class="mb-2">
                                <a class="dropdown-item border-radius-md" href="javascript:;">
                                    <div class="d-flex py-1">
                                        <div class="my-auto">
                                            <img src="{{asset('assets/img/small-logos/logo-spotify.svg')}}"
                                                class="avatar avatar-sm bg-gradient-dark  me-3 " alt="logo spotify">
                                        </div>
                                        <div class="d-flex flex-column justify-content-center">
                                            <h6 class="text-sm font-weight-normal mb-1">
                                                <span class="font-weight-bold">New album</span> by Travis Scott
                                            </h6>
                                            <p class="text-xs text-secondary mb-0">
                                                <i class="fa fa-clock me-1"></i>
                                                1 day
                                            </p>
                                        </div>
                                    </div>
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item border-radius-md" href="javascript:;">
                                    <div class="d-flex py-1">
                                        <div class="avatar avatar-sm bg-gradient-secondary  me-3  my-auto">
                                            <svg width="12px" height="12px" viewBox="0 0 43 36" version="1.1"
                                                xmlns="http://www.w3.org/2000/svg"
                                                xmlns:xlink="http://www.w3.org/1999/xlink">
                                                <title>credit-card</title>
                                                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                    <g transform="translate(-2169.000000, -745.000000)" fill="#FFFFFF"
                                                        fill-rule="nonzero">
                                                        <g transform="translate(1716.000000, 291.000000)">
                                                            <g transform="translate(453.000000, 454.000000)">
                                                                <path class="color-background"
                                                                    d="M43,10.7482083 L43,3.58333333 C43,1.60354167 41.3964583,0 39.4166667,0 L3.58333333,0 C1.60354167,0 0,1.60354167 0,3.58333333 L0,10.7482083 L43,10.7482083 Z"
                                                                    opacity="0.593633743"></path>
                                                                <path class="color-background"
                                                                    d="M0,16.125 L0,32.25 C0,34.2297917 1.60354167,35.8333333 3.58333333,35.8333333 L39.4166667,35.8333333 C41.3964583,35.8333333 43,34.2297917 43,32.25 L43,16.125 L0,16.125 Z M19.7083333,26.875 L7.16666667,26.875 L7.16666667,23.2916667 L19.7083333,23.2916667 L19.7083333,26.875 Z M35.8333333,26.875 L28.6666667,26.875 L28.6666667,23.2916667 L35.8333333,23.2916667 L35.8333333,26.875 Z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                </g>
                                            </svg>
                                        </div>
                                        <div class="d-flex flex-column justify-content-center">
                                            <h6 class="text-sm font-weight-normal mb-1">
                                                Payment successfully completed
                                            </h6>
                                            <p class="text-xs text-secondary mb-0">
                                                <i class="fa fa-clock me-1"></i>
                                                2 days
                                            </p>
                                        </div>
                                    </div>
                                </a>
                            </li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    <!-- End Navbar -->

    <!-- Section -->
    <section style="background: #f6f9ff;">

        <div class="container-fluid py-4 w-100">

            <div class="row">
                <div class="col-12">
                    <div class="card p-4">
                        <div class="card-body">

                            <!-- Quotation Detail-->
                            <div class="row mt-4">
                                <div class="col-8">
                                    <address>
                                        <b>Yusof Abdullah</b> <br>
                                        64, Lebuh Pendamar Indah 1<br>
                                        Taman Pendamar Indah<br>
                                        42000 Pelabuhan Klang, Selangor<br>
                                        <abbr title="Phone">Tel No:</abbr> (+60) 10-5235987
                                    </address>
                                </div>

                                <div class="col-4 mt-4">
                                    <h3 class="sitename">MyTukang<span style="color: #feb900">.</span></h3>
                                </div>
                            </div>

                            <!-- Horizontal line -->
                            <hr>

                            <!-- end row -->

                            <div class="row mt-4">
                                <div class="col-sm-7">
                                    <p><b>Kepada:</b></p>
                                    <div class="form-group">
                                        <!-- Name -->
                                        <input type="text" class="no-outline" id="name" name="name" value="{{ $booking->user->name ?? '' }}"> <br>
                                        
                                        <!-- Address Line 1 -->
                                        <input type="text" class="no-outline" id="address_line1" name="address_line1" value="{{ $booking->address->address_line1 ?? '' }}"> <br>
                                        
                                        <!-- Address Line 2 -->
                                        <input type="text" class="no-outline" id="address_line2" name="address_line2" value="{{ $booking->address->address_line2 ?? '' }}"> <br>
                                        
                                        <!-- Postcode and City in a single line -->
                                        <div class="d-flex">
                                            <input type="text" class="no-outline me-1" id="postcode" name="postcode" value="{{ $booking->address->postcode ?? '' }}" style="width: 50px;">
                                            <input type="text" class="no-outline" id="city" name="city" value="{{ $booking->address->city ?? '' }}" style="flex: 1;">
                                        </div>
                                    </div>
                                </div> <!-- end col-->
                            
                                <div class="col-sm-5">
                                    <div class="float-sm-right">
                                        <div class="form-group">
                                            <p style="color: grey; font-size:14px;"><b>Tarikh Sebut Harga:</b></p>
                                            <input type="date" class="form-control" id="date" name="date" value="{{ now()->toDateString() }}" readonly>
                                        </div>
                                        <div class="form-group">
                                            <p style="color: grey; font-size:14px;"><b>No. Tempahan:</b></p>
                                            <div class="d-flex align-items-center">
                                                <input type="text" class="form-control me-2" id="booking_id" name="booking_id" value="#{{ $booking->id }}" readonly>
                                                <!-- Icon trigger for modal -->
                                                <i class="fas fa-info-circle text-info" style="cursor: pointer;" data-bs-toggle="modal" data-bs-target="#bookingDetailsModal"></i>
                                            </div>
                                        </div>                                                                                
                                    </div>
                                </div> <!-- end col-->
                            </div>
                        
                            <!-- end row -->

                            <form action="{{ route('quotation.store', ['id' => $booking->id]) }}" method="POST">
                                @csrf
                                <div class="row">
                                    <div class="col-12">
                                        <div class="table-responsive">
                                            <table class="table" id="quotation-table">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>Skop Kerja</th>
                                                        <th>Kuantiti</th>
                                                        <th>Harga Seunit</th>
                                                        <th>Jumlah</th>
                                                        <th>Tindakan</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <!-- Default Row with Dropdown and Price Display -->
                                                    <tr data-index="1">
                                                        <td>1</td>
                                                        <td>
                                                            <input type="text" name="scope_of_work[]" class="form-control" value="{{ $subService->name }}" readonly>
                                                        </td>
                                                        <td><input type="number" name="quantity[]" class="form-control" value="1" oninput="calculateTotal()" required></td>
                                                        <td><input type="number" step="0.01" name="unit_price[]" class="form-control" value="{{ $subService->price }}" readonly></td>
                                                        <td><input type="number" step="0.01" name="total_price[]" class="form-control" readonly></td>
                                                        <td>
                                                            <a href="javascript:void(0);" onclick="deleteRow(1)" style="font-size: 12px; display: flex; justify-content: center; align-items: center;">
                                                                <i class="fas fa-trash mt-2"></i>
                                                            </a>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <div class="text-start">
                                                            <button type="button" id="add-manual-row" class="btn btn-secondary mt-2">Tambah Baris</button>
                                                        </div>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            
                                <!-- Total Amount -->
                                <div class="row">
                                    <div class="col-6"></div>
                                    <div class="col-6 text-right">
                                        <label><b>Jumlah Keseluruhan:</b></label>
                                        <input type="text" name="total_amount" id="total_amount" class="form-control" readonly>
                                    </div>
                                </div>
                            
                                <!-- Action Buttons -->
                                <div class="row">
                                    <div class="button-row d-flex justify-content-between mt-4 col-12">
                                        <button type="button" onclick="history.back()" class="btn bg-gradient-light">Kembali</button>
                                        <button type="submit" class="btn btn-warning">Hantar</button>
                                    </div>
                                </div>
                            </form>                            
                            
                            <!-- end buttons -->
                        </div> <!-- end card-body-->
                    </div> <!-- end card -->
                </div> <!-- end col-->
            </div>
            <!-- end row -->

        </div>

        <!-- Booking Details Modal -->
        <div class="modal fade" id="bookingDetailsModal" tabindex="-1" aria-labelledby="bookingDetailsModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="bookingDetailsModalLabel">Maklumat Tempahan</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <!-- Booking Details -->
                        <div class="mb-3">
                            <p><strong>Nama Pelanggan:</strong> {{ $booking->user->name }}</p>
                            <p><strong>Servis:</strong> {{ $booking->service->name }}</p>
                            <p><strong>Sub Servis:</strong> {{ $booking->subService->name }}</p>
                            <p><strong>Mempunyai Alat Ganti?:</strong> {{ $booking->parts }}</p>
                            <p><strong>Unit:</strong> {{ $booking->unit }}</p>
                            <p><strong>Tarikh Tempahan:</strong> {{ $booking->approved_date->format('d-m-Y') }}</p>
                            <p><strong>Masa Tempahan:</strong> {{ $booking->approved_time->format('H:i') }}</p>
                            <p><strong>Catatan:</strong> {{ $booking->remark }}</p>
                        </div>

                        <!-- Images Section -->
                        @if($booking->proof_damage)
                            <div class="mb-3">
                                <strong>Bukti Kerosakan:</strong>
                                <div>
                                    <img src="{{ asset('storage/' . $booking->proof_damage) }}" alt="Proof of Damage" class="img-fluid" style="max-height: 200px; object-fit: cover;">
                                </div>
                            </div>
                        @endif
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                    </div>
                </div>
            </div>
        </div>



    </section>


    <!--   Core JS Files   -->
    <script src="{{asset('assets/js/core/popper.min.js')}}"></script>
    <script src="{{asset('assets/js/core/bootstrap.min.js')}}"></script>
    <script src="{{asset('assets/js/plugins/perfect-scrollbar.min.js')}}"></script>
    <script src="{{asset('assets/js/plugins/smooth-scrollbar.min.js')}}"></script>
    <script src="{{asset('assets/js/plugins/datatables.js')}}"></script>

    <!-- Kanban scripts -->
    <script src="{{asset('assets/js/plugins/dragula/dragula.min.js')}}"></script>
    <script src="{{asset('assets/js/plugins/jkanban/jkanban.js')}}"></script>
    <script src="{{asset('assets/js/plugins/multistep-form.js')}}"></script>
    <script src="{{asset('assets/js/plugins/choices.min.js')}}"></script>
    <script src="{{asset('assets/js/plugins/sweetalert.min.js')}}"></script>

    
    <!-- Add new row and display price -->
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const tableBody = document.querySelector('#quotation-table tbody');
            let rowIndex = 2; // Start with index 2 since the first row is already added
        
            // Function to add a row with manual input for the scope of work
            function addManualRow() {
                const row = document.createElement('tr');
                row.dataset.index = rowIndex;
        
                row.innerHTML = `
                    <td>${rowIndex}</td>
                    <td>
                        <input type="text" name="scope_of_work[]" class="form-control" placeholder="Masukkan Skop Kerja" required>
                    </td>
                    <td><input type="number" name="quantity[]" class="form-control" value="1" oninput="calculateTotal()" required></td>
                    <td><input type="number" step="0.01" name="unit_price[]" class="form-control" oninput="calculateTotal()" required></td>
                    <td><input type="number" step="0.01" name="total_price[]" class="form-control" readonly required></td>
                    <td>
                        <a href="javascript:void(0);" onclick="deleteRow(${rowIndex})" style="font-size: 12px; display: flex; justify-content: center; align-items: center;">
                            <i class="fas fa-trash mt-2"></i>
                        </a>
                    </td>
                `;
        
                tableBody.appendChild(row);
                rowIndex++;
            }
        
            // Function to delete a row
            window.deleteRow = function (index) {
                const row = document.querySelector(`tr[data-index="${index}"]`);
                if (row) {
                    row.remove();
                    calculateTotal();
                }
            };
        
            // Add event listener to the "Tambah Skop Manual" button
            document.getElementById('add-manual-row').addEventListener('click', addManualRow);
        
            // Calculate total for the first row and all subsequent rows
            calculateTotal();
        });
    
        // Function to calculate total for the row and update grand total
        function calculateTotal() {
            let totalAmount = 0;
        
            document.querySelectorAll('tr[data-index]').forEach(function(row) {
                const quantityField = row.querySelector('[name="quantity[]"]');
                const unitPriceField = row.querySelector('[name="unit_price[]"]');
                const totalPriceField = row.querySelector('[name="total_price[]"]');
        
                // Ensure valid numeric values for quantity and unit price
                const quantity = parseFloat(quantityField.value) || 0;
                const unitPrice = parseFloat(unitPriceField.value) || 0;
        
                // Calculate row total
                const totalPrice = quantity * unitPrice;
                totalPriceField.value = totalPrice.toFixed(2);
        
                // Add to grand total
                totalAmount += totalPrice;
            });
        
            // Display the grand total
            document.getElementById('total_amount').value = totalAmount.toFixed(2);
        }
    </script>

    <script>
        var win = navigator.platform.indexOf('Win') > -1;
        if (win && document.querySelector('#sidenav-scrollbar')) {
            var options = {
                damping: '0.5'
            }
            Scrollbar.init(document.querySelector('#sidenav-scrollbar'), options);
        }
    </script>

    <!-- Control Center for Soft Dashboard: parallax effects, scripts for the example pages etc -->
    <script src="{{asset('assets/js/soft-ui-dashboard.min.js?v=1.0.3')}}"></script>


@endsection
