<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        DB::table('users')->insert([
            [
                'name' => 'Admin', //1
                'email' => 'admin@gmail.com',
                'phoneNum' => '0',
                'password' => Hash::make('password'), // Hashed password
                'role' => 1, // Admin
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Owner', //2
                'email' => 'owner@gmail.com',
                'phoneNum' => '0',
                'password' => Hash::make('password'), // Hashed password
                'role' => 2, // Owner
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Siti Khadijah', //3
                'email' => 'user@gmail.com',
                'phoneNum' => '01122334455',
                'password' => Hash::make('password'), // Hashed password
                'role' => 0, // User
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Ahmad Abdul', //4
                'email' => 'ahmad@gmail.com',
                'phoneNum' => '0107654332',
                'password' => Hash::make('password'), // Hashed password
                'role' => 0, // User
                'created_at' => now(),
                'updated_at' => now(),
            ],

            [
                'name' => 'Fatin Faiqah', //5
                'email' => 'fatin.faiqah01@gmail.com',
                'phoneNum' => '0107654332',
                'password' => Hash::make('password'), // Hashed password
                'role' => 0, // User
                'created_at' => now(),
                'updated_at' => now(),
            ],

            [
                'name' => 'Mohammad Amir', //6
                'email' => 'amir@gmail.com',
                'phoneNum' => '0124563123',
                'password' => Hash::make('password'), // Hashed password
                'role' => 0, // User
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Syed Danial', //7
                'email' => 'syed@gmail.com',
                'phoneNum' => '0109876543',
                'password' => Hash::make('password'), // Hashed password
                'role' => 0, // User
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
        
    }
}
