<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class BookingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        DB::table('bookings')->insert([
            [
                'user_id' => 3, // Assuming a user with ID 1 exists
                'service_id' => 1, // Assuming a service with ID 1 exists
                'sub_service_id' => 4, // Assuming a sub-service with ID 2 exists
                'address_id' => 1,
                'parts' => 'Tidak',
                'unit' => 3,
                'date' => '2025-01-20',
                'time' => '10:00',
                'alt_date' => '2025-01-24',
                'alt_time' => '14:00',
                'remark' => 'Rosak dan minta datang baiki',
                'status' => 'Hantar',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'user_id' => 5, // Assuming a user with ID 2 exists
                'service_id' => 1, // Assuming a service with ID 2 exists
                'sub_service_id' => 7, // Assuming a sub-service with ID 8 exists
                'address_id' => 2,
                'parts' => 'Tidak',
                'unit' => 1,
                'date' => '2025-01-16',
                'time' => '09:00',
                'alt_date' => '2025-01-20',
                'alt_time' => '16:00',
                'remark' => 'Perlu dibaiki kerana dah rosak',
                'status' => 'Hantar',
                'created_at' => now(),
                'updated_at' => now(),
            ],

            [
                'user_id' => 3, // Assuming a user with ID 1 exists
                'service_id' => 2, // Assuming a service with ID 2 exists
                'sub_service_id' => 13, // Assuming a sub-service with ID 2 exists
                'address_id' => 1,
                'parts' => 'Ya',
                'unit' => 2,
                'date' => '2025-01-22',
                'time' => '10:00',
                'alt_date' => '2025-01-24',
                'alt_time' => '16:00',
                'remark' => 'Barang rosak',
                'status' => 'Hantar',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'user_id' => 4,
                'service_id' => 3, 
                'sub_service_id' => 15,
                'address_id' => 2,
                'parts' => 'Ya',
                'unit' => 1,
                'date' => '2025-01-16',
                'time' => '10:00',
                'alt_date' => '2025-01-17',
                'alt_time' => '16:00',
                'remark' => 'Tolong datang baiki',
                'status' => 'Hantar',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'user_id' => 6,
                'service_id' => 2, 
                'sub_service_id' => 11,
                'address_id' => 3,
                'parts' => 'Tidak',
                'unit' => 1,
                'date' => '2025-01-13',
                'time' => '12:00',
                'alt_date' => '2025-01-17',
                'alt_time' => '16:00',
                'remark' => 'Sinki Tersumbat',
                'status' => 'Hantar',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'user_id' => 7,
                'service_id' => 3, 
                'sub_service_id' => 19,
                'address_id' => 5,
                'parts' => 'Tidak',
                'unit' => 1,
                'date' => '2025-01-15',
                'time' => '12:00',
                'alt_date' => '2025-01-19',
                'alt_time' => '16:00',
                'remark' => 'Sinki Tersumbat',
                'status' => 'Hantar',
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
    }
}
