<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('booking_id')->constrained()->onDelete('cascade');
            $table->string('bill_code'); // ToyyibPay bill code
            $table->decimal('amount', 10, 2)->default(0.00); // Payment amount
            $table->enum('status', ['successful', 'failed', 'pending']); // Payment status (successful, pending, failed)
            $table->string('reason')->nullable(); // Reason for failure (if any)
            $table->timestamp('transaction_time')->nullable(); // Timestamp for the transaction
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payments');
    }
};
