<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SubService extends Model
{
    use HasFactory;

    protected $fillable = ['service_id', 'name', 'price', 'estimate_price'];

    public function service()
    {
        return $this->belongsTo(Service::class); //child to Service
    }

    public function bookings()
    {
        return $this->hasMany(Booking::class, 'sub_service_id');
    }
}
