<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Payment extends Model
{
    use HasFactory;

    protected $fillable = [
        'booking_id',
        'bill_code',
        'amount',
        'status',
        'reason',
        'transaction_time',
    ];

    protected $casts = [
        'transaction_time' => 'datetime:Y-m-d H:i:s',
    ];

    // Define the relationship with the Booking model
    public function booking()
    {
        return $this->belongsTo(Booking::class);
    }

}
