<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Booking extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'service_id',
        'sub_service_id',
        'address_id',
        'parts',
        'unit',
        'date',
        'time',
        'alt_date',
        'alt_time',
        'remark',
        'proof_damage',
        'approved_datetime', // Optional: Use if storing combined datetime
        'approved_date',     // Use if storing date separately
        'approved_time',     // Use if storing time separately
        'reject_reason',
        'status',
        'rejection_reason',
        'total_payment',
    ];


    protected $casts = [
        'date' => 'datetime:Y-m-d',
        'alt_date' => 'datetime:Y-m-d',
        'time' => 'datetime:H:i',
        'alt_time' => 'datetime:H:i',
        'approved_date' => 'datetime:Y-m-d',
        'approved_time' => 'datetime:H:i',
    ];

    public function address()
    {
        return $this->belongsTo(Address::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function service()
    {
        return $this->belongsTo(Service::class);
    }

    public function subService()
    {
        return $this->belongsTo(SubService::class, 'sub_service_id');
    }

    public function quotation()
    {
        return $this->hasOne(Quotation::class, 'booking_id');
    }

    public function payments()
    {
        return $this->hasMany(Payment::class);
    }
    


}
