(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('universal-cookie'), require('react')) :
    typeof define === 'function' && define.amd ? define(['exports', 'universal-cookie', 'react'], factory) :
    (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.ReactCookie = {}, global.UniversalCookie, global.React));
})(this, (function (exports, Cookies, React) { 'use strict';

    function _interopNamespaceDefault(e) {
        var n = Object.create(null);
        if (e) {
            Object.keys(e).forEach(function (k) {
                if (k !== 'default') {
                    var d = Object.getOwnPropertyDescriptor(e, k);
                    Object.defineProperty(n, k, d.get ? d : {
                        enumerable: true,
                        get: function () { return e[k]; }
                    });
                }
            });
        }
        n.default = e;
        return Object.freeze(n);
    }

    var React__namespace = /*#__PURE__*/_interopNamespaceDefault(React);

    const CookiesContext = React__namespace.createContext(new Cookies());
    const { Provider, Consumer } = CookiesContext;

    class CookiesProvider extends React__namespace.Component {
        constructor(props) {
            super(props);
            if (props.cookies) {
                this.cookies = props.cookies;
            }
            else {
                this.cookies = new Cookies(undefined, props.defaultSetOptions);
            }
        }
        render() {
            return React__namespace.createElement(Provider, { value: this.cookies }, this.props.children);
        }
    }

    /******************************************************************************
    Copyright (c) Microsoft Corporation.

    Permission to use, copy, modify, and/or distribute this software for any
    purpose with or without fee is hereby granted.

    THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
    REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
    AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
    INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
    LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
    OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
    PERFORMANCE OF THIS SOFTWARE.
    ***************************************************************************** */
    /* global Reflect, Promise, SuppressedError, Symbol */


    function __rest(s, e) {
        var t = {};
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
            t[p] = s[p];
        if (s != null && typeof Object.getOwnPropertySymbols === "function")
            for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
                if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                    t[p[i]] = s[p[i]];
            }
        return t;
    }

    typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
        var e = new Error(message);
        return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
    };

    function getDefaultExportFromCjs (x) {
    	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
    }

    var reactIs$1 = {exports: {}};

    var reactIs_development = {};

    /** @license React v16.13.1
     * react-is.development.js
     *
     * Copyright (c) Facebook, Inc. and its affiliates.
     *
     * This source code is licensed under the MIT license found in the
     * LICENSE file in the root directory of this source tree.
     */

    var hasRequiredReactIs_development;

    function requireReactIs_development () {
    	if (hasRequiredReactIs_development) return reactIs_development;
    	hasRequiredReactIs_development = 1;



    	{
    	  (function() {

    	// The Symbol used to tag the ReactElement-like types. If there is no native Symbol
    	// nor polyfill, then a plain number is used for performance.
    	var hasSymbol = typeof Symbol === 'function' && Symbol.for;
    	var REACT_ELEMENT_TYPE = hasSymbol ? Symbol.for('react.element') : 0xeac7;
    	var REACT_PORTAL_TYPE = hasSymbol ? Symbol.for('react.portal') : 0xeaca;
    	var REACT_FRAGMENT_TYPE = hasSymbol ? Symbol.for('react.fragment') : 0xeacb;
    	var REACT_STRICT_MODE_TYPE = hasSymbol ? Symbol.for('react.strict_mode') : 0xeacc;
    	var REACT_PROFILER_TYPE = hasSymbol ? Symbol.for('react.profiler') : 0xead2;
    	var REACT_PROVIDER_TYPE = hasSymbol ? Symbol.for('react.provider') : 0xeacd;
    	var REACT_CONTEXT_TYPE = hasSymbol ? Symbol.for('react.context') : 0xeace; // TODO: We don't use AsyncMode or ConcurrentMode anymore. They were temporary
    	// (unstable) APIs that have been removed. Can we remove the symbols?

    	var REACT_ASYNC_MODE_TYPE = hasSymbol ? Symbol.for('react.async_mode') : 0xeacf;
    	var REACT_CONCURRENT_MODE_TYPE = hasSymbol ? Symbol.for('react.concurrent_mode') : 0xeacf;
    	var REACT_FORWARD_REF_TYPE = hasSymbol ? Symbol.for('react.forward_ref') : 0xead0;
    	var REACT_SUSPENSE_TYPE = hasSymbol ? Symbol.for('react.suspense') : 0xead1;
    	var REACT_SUSPENSE_LIST_TYPE = hasSymbol ? Symbol.for('react.suspense_list') : 0xead8;
    	var REACT_MEMO_TYPE = hasSymbol ? Symbol.for('react.memo') : 0xead3;
    	var REACT_LAZY_TYPE = hasSymbol ? Symbol.for('react.lazy') : 0xead4;
    	var REACT_BLOCK_TYPE = hasSymbol ? Symbol.for('react.block') : 0xead9;
    	var REACT_FUNDAMENTAL_TYPE = hasSymbol ? Symbol.for('react.fundamental') : 0xead5;
    	var REACT_RESPONDER_TYPE = hasSymbol ? Symbol.for('react.responder') : 0xead6;
    	var REACT_SCOPE_TYPE = hasSymbol ? Symbol.for('react.scope') : 0xead7;

    	function isValidElementType(type) {
    	  return typeof type === 'string' || typeof type === 'function' || // Note: its typeof might be other than 'symbol' or 'number' if it's a polyfill.
    	  type === REACT_FRAGMENT_TYPE || type === REACT_CONCURRENT_MODE_TYPE || type === REACT_PROFILER_TYPE || type === REACT_STRICT_MODE_TYPE || type === REACT_SUSPENSE_TYPE || type === REACT_SUSPENSE_LIST_TYPE || typeof type === 'object' && type !== null && (type.$$typeof === REACT_LAZY_TYPE || type.$$typeof === REACT_MEMO_TYPE || type.$$typeof === REACT_PROVIDER_TYPE || type.$$typeof === REACT_CONTEXT_TYPE || type.$$typeof === REACT_FORWARD_REF_TYPE || type.$$typeof === REACT_FUNDAMENTAL_TYPE || type.$$typeof === REACT_RESPONDER_TYPE || type.$$typeof === REACT_SCOPE_TYPE || type.$$typeof === REACT_BLOCK_TYPE);
    	}

    	function typeOf(object) {
    	  if (typeof object === 'object' && object !== null) {
    	    var $$typeof = object.$$typeof;

    	    switch ($$typeof) {
    	      case REACT_ELEMENT_TYPE:
    	        var type = object.type;

    	        switch (type) {
    	          case REACT_ASYNC_MODE_TYPE:
    	          case REACT_CONCURRENT_MODE_TYPE:
    	          case REACT_FRAGMENT_TYPE:
    	          case REACT_PROFILER_TYPE:
    	          case REACT_STRICT_MODE_TYPE:
    	          case REACT_SUSPENSE_TYPE:
    	            return type;

    	          default:
    	            var $$typeofType = type && type.$$typeof;

    	            switch ($$typeofType) {
    	              case REACT_CONTEXT_TYPE:
    	              case REACT_FORWARD_REF_TYPE:
    	              case REACT_LAZY_TYPE:
    	              case REACT_MEMO_TYPE:
    	              case REACT_PROVIDER_TYPE:
    	                return $$typeofType;

    	              default:
    	                return $$typeof;
    	            }

    	        }

    	      case REACT_PORTAL_TYPE:
    	        return $$typeof;
    	    }
    	  }

    	  return undefined;
    	} // AsyncMode is deprecated along with isAsyncMode

    	var AsyncMode = REACT_ASYNC_MODE_TYPE;
    	var ConcurrentMode = REACT_CONCURRENT_MODE_TYPE;
    	var ContextConsumer = REACT_CONTEXT_TYPE;
    	var ContextProvider = REACT_PROVIDER_TYPE;
    	var Element = REACT_ELEMENT_TYPE;
    	var ForwardRef = REACT_FORWARD_REF_TYPE;
    	var Fragment = REACT_FRAGMENT_TYPE;
    	var Lazy = REACT_LAZY_TYPE;
    	var Memo = REACT_MEMO_TYPE;
    	var Portal = REACT_PORTAL_TYPE;
    	var Profiler = REACT_PROFILER_TYPE;
    	var StrictMode = REACT_STRICT_MODE_TYPE;
    	var Suspense = REACT_SUSPENSE_TYPE;
    	var hasWarnedAboutDeprecatedIsAsyncMode = false; // AsyncMode should be deprecated

    	function isAsyncMode(object) {
    	  {
    	    if (!hasWarnedAboutDeprecatedIsAsyncMode) {
    	      hasWarnedAboutDeprecatedIsAsyncMode = true; // Using console['warn'] to evade Babel and ESLint

    	      console['warn']('The ReactIs.isAsyncMode() alias has been deprecated, ' + 'and will be removed in React 17+. Update your code to use ' + 'ReactIs.isConcurrentMode() instead. It has the exact same API.');
    	    }
    	  }

    	  return isConcurrentMode(object) || typeOf(object) === REACT_ASYNC_MODE_TYPE;
    	}
    	function isConcurrentMode(object) {
    	  return typeOf(object) === REACT_CONCURRENT_MODE_TYPE;
    	}
    	function isContextConsumer(object) {
    	  return typeOf(object) === REACT_CONTEXT_TYPE;
    	}
    	function isContextProvider(object) {
    	  return typeOf(object) === REACT_PROVIDER_TYPE;
    	}
    	function isElement(object) {
    	  return typeof object === 'object' && object !== null && object.$$typeof === REACT_ELEMENT_TYPE;
    	}
    	function isForwardRef(object) {
    	  return typeOf(object) === REACT_FORWARD_REF_TYPE;
    	}
    	function isFragment(object) {
    	  return typeOf(object) === REACT_FRAGMENT_TYPE;
    	}
    	function isLazy(object) {
    	  return typeOf(object) === REACT_LAZY_TYPE;
    	}
    	function isMemo(object) {
    	  return typeOf(object) === REACT_MEMO_TYPE;
    	}
    	function isPortal(object) {
    	  return typeOf(object) === REACT_PORTAL_TYPE;
    	}
    	function isProfiler(object) {
    	  return typeOf(object) === REACT_PROFILER_TYPE;
    	}
    	function isStrictMode(object) {
    	  return typeOf(object) === REACT_STRICT_MODE_TYPE;
    	}
    	function isSuspense(object) {
    	  return typeOf(object) === REACT_SUSPENSE_TYPE;
    	}

    	reactIs_development.AsyncMode = AsyncMode;
    	reactIs_development.ConcurrentMode = ConcurrentMode;
    	reactIs_development.ContextConsumer = ContextConsumer;
    	reactIs_development.ContextProvider = ContextProvider;
    	reactIs_development.Element = Element;
    	reactIs_development.ForwardRef = ForwardRef;
    	reactIs_development.Fragment = Fragment;
    	reactIs_development.Lazy = Lazy;
    	reactIs_development.Memo = Memo;
    	reactIs_development.Portal = Portal;
    	reactIs_development.Profiler = Profiler;
    	reactIs_development.StrictMode = StrictMode;
    	reactIs_development.Suspense = Suspense;
    	reactIs_development.isAsyncMode = isAsyncMode;
    	reactIs_development.isConcurrentMode = isConcurrentMode;
    	reactIs_development.isContextConsumer = isContextConsumer;
    	reactIs_development.isContextProvider = isContextProvider;
    	reactIs_development.isElement = isElement;
    	reactIs_development.isForwardRef = isForwardRef;
    	reactIs_development.isFragment = isFragment;
    	reactIs_development.isLazy = isLazy;
    	reactIs_development.isMemo = isMemo;
    	reactIs_development.isPortal = isPortal;
    	reactIs_development.isProfiler = isProfiler;
    	reactIs_development.isStrictMode = isStrictMode;
    	reactIs_development.isSuspense = isSuspense;
    	reactIs_development.isValidElementType = isValidElementType;
    	reactIs_development.typeOf = typeOf;
    	  })();
    	}
    	return reactIs_development;
    }

    {
      reactIs$1.exports = requireReactIs_development();
    }

    var reactIsExports = reactIs$1.exports;

    var reactIs = reactIsExports;

    /**
     * Copyright 2015, Yahoo! Inc.
     * Copyrights licensed under the New BSD License. See the accompanying LICENSE file for terms.
     */
    var REACT_STATICS = {
      childContextTypes: true,
      contextType: true,
      contextTypes: true,
      defaultProps: true,
      displayName: true,
      getDefaultProps: true,
      getDerivedStateFromError: true,
      getDerivedStateFromProps: true,
      mixins: true,
      propTypes: true,
      type: true
    };
    var KNOWN_STATICS = {
      name: true,
      length: true,
      prototype: true,
      caller: true,
      callee: true,
      arguments: true,
      arity: true
    };
    var FORWARD_REF_STATICS = {
      '$$typeof': true,
      render: true,
      defaultProps: true,
      displayName: true,
      propTypes: true
    };
    var MEMO_STATICS = {
      '$$typeof': true,
      compare: true,
      defaultProps: true,
      displayName: true,
      propTypes: true,
      type: true
    };
    var TYPE_STATICS = {};
    TYPE_STATICS[reactIs.ForwardRef] = FORWARD_REF_STATICS;
    TYPE_STATICS[reactIs.Memo] = MEMO_STATICS;

    function getStatics(component) {
      // React v16.11 and below
      if (reactIs.isMemo(component)) {
        return MEMO_STATICS;
      } // React v16.12 and above


      return TYPE_STATICS[component['$$typeof']] || REACT_STATICS;
    }

    var defineProperty = Object.defineProperty;
    var getOwnPropertyNames = Object.getOwnPropertyNames;
    var getOwnPropertySymbols = Object.getOwnPropertySymbols;
    var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
    var getPrototypeOf = Object.getPrototypeOf;
    var objectPrototype = Object.prototype;
    function hoistNonReactStatics(targetComponent, sourceComponent, blacklist) {
      if (typeof sourceComponent !== 'string') {
        // don't hoist over string (html) components
        if (objectPrototype) {
          var inheritedComponent = getPrototypeOf(sourceComponent);

          if (inheritedComponent && inheritedComponent !== objectPrototype) {
            hoistNonReactStatics(targetComponent, inheritedComponent, blacklist);
          }
        }

        var keys = getOwnPropertyNames(sourceComponent);

        if (getOwnPropertySymbols) {
          keys = keys.concat(getOwnPropertySymbols(sourceComponent));
        }

        var targetStatics = getStatics(targetComponent);
        var sourceStatics = getStatics(sourceComponent);

        for (var i = 0; i < keys.length; ++i) {
          var key = keys[i];

          if (!KNOWN_STATICS[key] && !(blacklist && blacklist[key]) && !(sourceStatics && sourceStatics[key]) && !(targetStatics && targetStatics[key])) {
            var descriptor = getOwnPropertyDescriptor(sourceComponent, key);

            try {
              // Avoid failures from read-only properties
              defineProperty(targetComponent, key, descriptor);
            } catch (e) {}
          }
        }
      }

      return targetComponent;
    }

    var hoistNonReactStatics_cjs = hoistNonReactStatics;

    var hoistStatics = /*@__PURE__*/getDefaultExportFromCjs(hoistNonReactStatics_cjs);

    function withCookies(WrappedComponent) {
        // @ts-ignore
        const name = WrappedComponent.displayName || WrappedComponent.name;
        class CookieWrapper extends React__namespace.Component {
            constructor() {
                super(...arguments);
                this.onChange = () => {
                    // Make sure to update children with new values
                    this.forceUpdate();
                };
            }
            listen() {
                this.props.cookies.addChangeListener(this.onChange);
            }
            unlisten(cookies) {
                (cookies || this.props.cookies).removeChangeListener(this.onChange);
            }
            componentDidMount() {
                this.listen();
            }
            componentDidUpdate(prevProps) {
                if (prevProps.cookies !== this.props.cookies) {
                    this.unlisten(prevProps.cookies);
                    this.listen();
                }
            }
            componentWillUnmount() {
                this.unlisten();
            }
            render() {
                const _a = this.props, { forwardedRef, cookies } = _a, restProps = __rest(_a, ["forwardedRef", "cookies"]);
                const allCookies = cookies.getAll({ doNotUpdate: true });
                return (React__namespace.createElement(WrappedComponent, Object.assign({}, restProps, { ref: forwardedRef, cookies: cookies, allCookies: allCookies })));
            }
        }
        CookieWrapper.displayName = `withCookies(${name})`;
        CookieWrapper.WrappedComponent = WrappedComponent;
        const ForwardedComponent = React__namespace.forwardRef((props, ref) => {
            return (React__namespace.createElement(Consumer, null, (cookies) => (React__namespace.createElement(CookieWrapper, Object.assign({ cookies: cookies }, props, { forwardedRef: ref })))));
        });
        ForwardedComponent.displayName = CookieWrapper.displayName;
        ForwardedComponent.WrappedComponent = CookieWrapper.WrappedComponent;
        return hoistStatics(ForwardedComponent, WrappedComponent);
    }

    function isInBrowser() {
        return (typeof window !== 'undefined' &&
            typeof window.document !== 'undefined' &&
            typeof window.document.createElement !== 'undefined');
    }

    function useCookies(dependencies, options) {
        const cookies = React.useContext(CookiesContext);
        if (!cookies) {
            throw new Error('Missing <CookiesProvider>');
        }
        const defaultOptions = { doNotUpdate: true };
        const getOptions = Object.assign(Object.assign({}, defaultOptions), options);
        const [allCookies, setCookies] = React.useState(() => cookies.getAll(getOptions));
        if (isInBrowser()) {
            React.useLayoutEffect(() => {
                function onChange() {
                    const newCookies = cookies.getAll(getOptions);
                    if (shouldUpdate(dependencies || null, newCookies, allCookies)) {
                        setCookies(newCookies);
                    }
                }
                cookies.addChangeListener(onChange);
                return () => {
                    cookies.removeChangeListener(onChange);
                };
            }, [cookies, allCookies]);
        }
        const setCookie = React.useMemo(() => cookies.set.bind(cookies), [cookies]);
        const removeCookie = React.useMemo(() => cookies.remove.bind(cookies), [cookies]);
        const updateCookies = React.useMemo(() => cookies.update.bind(cookies), [cookies]);
        return [allCookies, setCookie, removeCookie, updateCookies];
    }
    function shouldUpdate(dependencies, newCookies, oldCookies) {
        if (!dependencies) {
            return true;
        }
        for (let dependency of dependencies) {
            if (newCookies[dependency] !== oldCookies[dependency]) {
                return true;
            }
        }
        return false;
    }

    exports.Cookies = Cookies;
    exports.CookiesProvider = CookiesProvider;
    exports.useCookies = useCookies;
    exports.withCookies = withCookies;

}));
