'use strict';

var Cookies = require('universal-cookie');
var React = require('react');
var hoistStatics = require('hoist-non-react-statics');

function _interopNamespaceDefault(e) {
    var n = Object.create(null);
    if (e) {
        Object.keys(e).forEach(function (k) {
            if (k !== 'default') {
                var d = Object.getOwnPropertyDescriptor(e, k);
                Object.defineProperty(n, k, d.get ? d : {
                    enumerable: true,
                    get: function () { return e[k]; }
                });
            }
        });
    }
    n.default = e;
    return Object.freeze(n);
}

var React__namespace = /*#__PURE__*/_interopNamespaceDefault(React);

const CookiesContext = React__namespace.createContext(new Cookies());
const { Provider, Consumer } = CookiesContext;

class CookiesProvider extends React__namespace.Component {
    constructor(props) {
        super(props);
        if (props.cookies) {
            this.cookies = props.cookies;
        }
        else {
            this.cookies = new Cookies(undefined, props.defaultSetOptions);
        }
    }
    render() {
        return React__namespace.createElement(Provider, { value: this.cookies }, this.props.children);
    }
}

function __rest(s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
}
typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
  var e = new Error(message);
  return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

function withCookies(WrappedComponent) {
    // @ts-ignore
    const name = WrappedComponent.displayName || WrappedComponent.name;
    class CookieWrapper extends React__namespace.Component {
        constructor() {
            super(...arguments);
            this.onChange = () => {
                // Make sure to update children with new values
                this.forceUpdate();
            };
        }
        listen() {
            this.props.cookies.addChangeListener(this.onChange);
        }
        unlisten(cookies) {
            (cookies || this.props.cookies).removeChangeListener(this.onChange);
        }
        componentDidMount() {
            this.listen();
        }
        componentDidUpdate(prevProps) {
            if (prevProps.cookies !== this.props.cookies) {
                this.unlisten(prevProps.cookies);
                this.listen();
            }
        }
        componentWillUnmount() {
            this.unlisten();
        }
        render() {
            const _a = this.props, { forwardedRef, cookies } = _a, restProps = __rest(_a, ["forwardedRef", "cookies"]);
            const allCookies = cookies.getAll({ doNotUpdate: true });
            return (React__namespace.createElement(WrappedComponent, Object.assign({}, restProps, { ref: forwardedRef, cookies: cookies, allCookies: allCookies })));
        }
    }
    CookieWrapper.displayName = `withCookies(${name})`;
    CookieWrapper.WrappedComponent = WrappedComponent;
    const ForwardedComponent = React__namespace.forwardRef((props, ref) => {
        return (React__namespace.createElement(Consumer, null, (cookies) => (React__namespace.createElement(CookieWrapper, Object.assign({ cookies: cookies }, props, { forwardedRef: ref })))));
    });
    ForwardedComponent.displayName = CookieWrapper.displayName;
    ForwardedComponent.WrappedComponent = CookieWrapper.WrappedComponent;
    return hoistStatics(ForwardedComponent, WrappedComponent);
}

function isInBrowser() {
    return (typeof window !== 'undefined' &&
        typeof window.document !== 'undefined' &&
        typeof window.document.createElement !== 'undefined');
}

function useCookies(dependencies, options) {
    const cookies = React.useContext(CookiesContext);
    if (!cookies) {
        throw new Error('Missing <CookiesProvider>');
    }
    const defaultOptions = { doNotUpdate: true };
    const getOptions = Object.assign(Object.assign({}, defaultOptions), options);
    const [allCookies, setCookies] = React.useState(() => cookies.getAll(getOptions));
    if (isInBrowser()) {
        React.useLayoutEffect(() => {
            function onChange() {
                const newCookies = cookies.getAll(getOptions);
                if (shouldUpdate(dependencies || null, newCookies, allCookies)) {
                    setCookies(newCookies);
                }
            }
            cookies.addChangeListener(onChange);
            return () => {
                cookies.removeChangeListener(onChange);
            };
        }, [cookies, allCookies]);
    }
    const setCookie = React.useMemo(() => cookies.set.bind(cookies), [cookies]);
    const removeCookie = React.useMemo(() => cookies.remove.bind(cookies), [cookies]);
    const updateCookies = React.useMemo(() => cookies.update.bind(cookies), [cookies]);
    return [allCookies, setCookie, removeCookie, updateCookies];
}
function shouldUpdate(dependencies, newCookies, oldCookies) {
    if (!dependencies) {
        return true;
    }
    for (let dependency of dependencies) {
        if (newCookies[dependency] !== oldCookies[dependency]) {
            return true;
        }
    }
    return false;
}

exports.Cookies = Cookies;
exports.CookiesProvider = CookiesProvider;
exports.useCookies = useCookies;
exports.withCookies = withCookies;
