<?php

use App\Http\Controllers\CustomerController;
use App\Http\Controllers\DamageController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\FarmController;
use App\Http\Controllers\PlantDetailController;
use App\Http\Controllers\FertilizerController;
use App\Http\Controllers\PestControlController;
use App\Http\Controllers\PlantationController;
use App\Http\Controllers\SaleController;
use App\Http\Controllers\HarvestController;
use App\Http\Controllers\FertilizerDetailController;
use App\Http\Controllers\PestControlDetailController;
use App\Http\Controllers\PriceController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('auth.login');
});




// Route::get('/dashboard', function () {
//     return view('dashboard');
// })->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware(['auth:sanctum', 'verified'])->group(function () {
    // Route::get('/dashboard', function () {
    //     return view('dashboard');
    // })->name('dashboard');
    Route::get('/admin/users/index', [UserController::class, 'index'])->name('admin.users.index');
    Route::get('/admin/users/create', [UserController::class, 'create'])->name('admin.users.create');
    Route::post('/admin/users', [UserController::class, 'store'])->name('admin.users.store');
    Route::delete('/admin/users/{id}', [UserController::class, 'destroy'])->name('admin.users.destroy');
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
});


Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
    Route::resource('plantation', PlantationController::class);
    Route::get('/schedule', [PlantationController::class, 'calendar'])->name('plantation.schedule');
    Route::patch('plantation/{id}/tanam', [PlantationController::class, 'tanam'])->name('plantation.tanam');
    Route::put('plantation/{id}/kemaskiniTanam', [PlantationController::class, 'kemaskiniTanam'])->name('plantation.kemaskiniTanam');
    Route::patch('plantation/{id}/tuai', [PlantationController::class, 'tuai'])->name('plantation.tuai');
    Route::put('plantation/{id}/kemaskiniTuai', [PlantationController::class, 'kemaskiniTuai'])->name('plantation.kemaskiniTuai');
    Route::get('/filter-users', [PlantationController::class, 'filterUsers']);
    Route::get('/check-date', [PlantationController::class, 'checkDate']);
    Route::resource('harvest', HarvestController::class);
    Route::get('/harvest/create/{id}', [HarvestController::class,'insert'])->name('harvest.insert');
    Route::get('/harvest/graph', [HarvestController::class, 'harvestGraph'])->name('harvest.graph');
    Route::resource('damage', DamageController::class);
    Route::patch('damage/{id}/aduan', [DamageController::class, 'aduan'])->name('damage.aduan');
    Route::put('damage/{id}/kemaskiniAduan', [DamageController::class, 'kemaskiniAduan'])->name('damage.kemaskiniAduan');
    Route::get('/damage/assign', [DamageController::class,'assign'])->name('damage.assign');
});

// Apply role middleware to restrict access (Tuan Kebun)
Route::middleware(['auth', 'role:Tuan_Kebun'])->group(function () {
    Route::resource('farm', FarmController::class);
    Route::resource('plant', PlantDetailController::class);
    Route::resource('fertilizer', FertilizerController::class);
    Route::resource('fertilizer-detail', FertilizerDetailController::class);
    Route::resource('pest', PestControlController::class);
    Route::resource('pest-detail', PestControlDetailController::class);
    Route::resource('customer', CustomerController::class);
    Route::resource('price', PriceController::class);
    Route::resource('sales', SaleController::class);
    Route::get('/sales/receipt/{id}', [SaleController::class, 'receipt'])->name('sales.receipt');
});







// temporary declare
// Route::get('/farm', [FarmController::class, 'index'])->name('farm.index');
// Route::get('/farm/create', [FarmController::class, 'create'])->name('farm.create');
// Route::get('/farm/edit', [FarmController::class, 'edit'])->name('farm.edit');
// Route::get('/farm/show', [FarmController::class, 'show'])->name('farm.show');

// Route::get('/plant', [PlantDetailController::class, 'index'])->name('plant.index');
// Route::get('/plant/create', [PlantDetailController::class, 'create'])->name('plant.create');
// Route::get('/plant/edit', [PlantDetailController::class, 'edit'])->name('plant.edit');

// Route::get('/fertilizer', [FertilizerController::class, 'index'])->name('fertilizer.index');
// Route::get('/fertilizer/create', [FertilizerController::class, 'create'])->name('fertilizer.create');
// Route::get('/fertilizer/edit', [FertilizerController::class, 'edit'])->name('fertilizer.edit');
// Route::get('/fertilizer/show', [FertilizerController::class, 'show'])->name('fertilizer.show');

// Route::get('/pest', [PestControlController::class, 'index'])->name('pest.index');
// Route::get('/pest/create', [PestControlController::class, 'create'])->name('pest.create');
// Route::get('/pest/edit', [PestControlController::class, 'edit'])->name('pest.edit');
// Route::get('/pest/show', [PestControlController::class, 'show'])->name('pest.show');


// Route::get('/plantation', [PlantationController::class, 'index'])->name('plantation.index');
// Route::get('/plantation/create', [PlantationController::class, 'create'])->name('plantation.create');
// Route::get('/plantation/edit', [PlantationController::class, 'edit'])->name('plantation.edit');
// Route::get('/plantation/show', [PlantationController::class, 'show'])->name('plantation.show');


// Route::get('/damage', [DamageReportController::class, 'index'])->name('damage.index');
// Route::get('/damage/create', [DamageReportController::class, 'create'])->name('damage.create');
// Route::get('/damage/edit', [DamageReportController::class, 'edit'])->name('damage.edit');
// Route::get('/damage/show', [DamageReportController::class, 'show'])->name('damage.show');
// Route::get('/damage/assign', [DamageReportController::class, 'assign'])->name('damage.assign');

// Route::get('/harvest', [HarvestController::class, 'index'])->name('harvest.index');
// Route::get('/harvest/create', [HarvestController::class, 'create'])->name('harvest.create');
// Route::get('/harvest/edit', [HarvestController::class, 'edit'])->name('harvest.edit');
// Route::get('/harvest/show', [HarvestController::class, 'show'])->name('harvest.show');

// Route::get('/sales', [SaleController::class, 'index'])->name('sales.index');
// Route::get('/sales/create', [SaleController::class, 'create'])->name('sales.create');
// Route::get('/sales/edit', [SaleController::class, 'edit'])->name('sales.edit');
// Route::get('/sales/show', [SaleController::class, 'show'])->name('sales.show');





// admin
Route::get('/admin-dashboard', function () {
    return view('admin/user/dashboard');
});
Route::get('/admin-create', function () {
    return view('admin/user/create');
});


//worker
Route::get('/worker-dashboard', function () {
    return view('worker/user/dashboard');
});

// Route::get('/worker-plantation-index', function () {
//     return view('worker/plantation/index');
// });

// Route::get('/worker-plantation-show', function () {
//     return view('worker/plantation/show');
// });

// Route::get('/worker-plantation-edit', function () {
//     return view('worker/plantation/edit');
// });

// Route::get('/worker-damage-index', function () {
//     return view('worker/damage/index');
// });

// Route::get('/worker-damage-create', function () {
//     return view('worker/damage/create');
// });

// Route::get('/worker-damage-show', function () {
//     return view('worker/damage/show');
// });

// Route::get('/worker-damage-edit', function () {
//     return view('worker/damage/edit');
// });

// Route::get('/worker-harvest-index', function () {
//     return view('worker/harvest/index');
// });

// Route::get('/worker-harvest-create', function () {
//     return view('worker/harvest/create');
// });

// Route::get('/worker-harvest-edit', function () {
//     return view('worker/harvest/edit');
// });

require __DIR__ . '/auth.php';
