
    <header>
        <h4 class="text-lg font-medium text-gray-900">
            {{ __('Kemaskini Kata Laluan') }}
        </h4>

        <p class="mt-1 text-sm text-gray-600">
            {{ __('Pastikan anda menggunakan kata laluan rawak kekal selamat.') }}
        </p>
    </header>

    
        <!-- Password Update Form -->
        <form method="post" action="{{ route('password.update') }}" class="mt-6 space-y-6">
            @csrf
            @method('put')
    
            <!-- Current Password Field -->
            <div class="form-group col-md-12">
                <label for="update_password_current_password" class="form-label">{{ __('Kata Laluan Semasa') }}</label>
                <input id="update_password_current_password" name="current_password" type="password" class="form-control" autocomplete="current-password" />
                @if ($errors->updatePassword->has('current_password'))
                    <div class="text-danger mt-2">
                        {{ $errors->updatePassword->first('current_password') }}
                    </div>
                @endif
            </div>
    
            <!-- New Password Field -->
            <div class="form-group col-md-12">
                <label for="update_password_password" class="form-label">{{ __('Kata Laluan Baru') }}</label>
                <input id="update_password_password" name="password" type="password" class="form-control" autocomplete="new-password" />
                @if ($errors->updatePassword->has('password'))
                    <div class="text-danger mt-2">
                        {{ $errors->updatePassword->first('password') }}
                    </div>
                @endif
            </div>
    
            <!-- Confirm Password Field -->
            <div class="form-group col-md-12">
                <label for="update_password_password_confirmation" class="form-label">{{ __('Sahkan Kata Laluan') }}</label>
                <input id="update_password_password_confirmation" name="password_confirmation" type="password" class="form-control" autocomplete="new-password" />
                @if ($errors->updatePassword->has('password_confirmation'))
                    <div class="text-danger mt-2">
                        {{ $errors->updatePassword->first('password_confirmation') }}
                    </div>
                @endif
            </div>
    
            <!-- Save Button -->
            <div class="form-group col-md-12">
                <button type="submit" class="btn btn-primary">{{ __('Kemaskini Kata Laluan') }}</button>
    
                @if (session('status') === 'password-updated')
                    <p
                        x-data="{ show: true }"
                        x-show="show"
                        x-transition
                        x-init="setTimeout(() => show = false, 2000)"
                        class="text-sm text-gray-600"
                    >{{ __('Saved.') }}</p>
                @endif
            </div>
        </form>
    

