@extends('layouts.base')

@section('content')

    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <h4 class="page-title">Rekod</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->

    {{-- <div class="row">
        <div class="col-12">
            <div class="card widget-inline">
                <div class="card-body p-0">
                    <div class="row no-gutters">
                        <div class="col">
                            <div class="card shadow-none m-0">
                                <div class="card-body text-center">
                                    <i class="dripicons-briefcase text-muted" style="font-size: 24px;"></i>
                                    <h3><span>29</span></h3>
                                    <p class="text-muted font-15 mb-0">Jumlah Racun</p>
                                </div>
                            </div>
                        </div>

                        <div class="col">
                            <div class="card shadow-none m-0 border-left">
                                <div class="card-body text-center">
                                    <i class="dripicons-checklist text-muted" style="font-size: 24px;"></i>
                                    <h3><span>715</span></h3>
                                    <p class="text-muted font-15 mb-0">Jenis Racun</p>
                                </div>
                            </div>
                        </div>
                    </div> <!-- end row -->
                </div>
            </div> <!-- end card-box-->
        </div> <!-- end col-->
    </div> --}}
    <!-- end row-->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <h4 class="header-title"> Kuantiti Racun</h4>
                        <a href="{{ route('pest.create') }}" class="btn btn-info btn-sm"
                            style="position: absolute; right:2%;">+Tambah Kuantiti Racun</a>
                        <br><br>
                    </div>


                    <table id="basic-datatable" class="table dt-responsive nowrap w-100">
                        <thead>
                            <tr>
                                <th>Bil</th>
                                <th>Nama</th>
                                <th>Pokok</th>
                                <th>Jenis Racun</th>
                                <th>Tindakan</th>
                            </tr>
                        </thead>


                        <tbody>
                            @foreach ($pestControls as $pestControl)
                            <tr>
                                <td>{{ $loop->index + 1 }}.</td>
                                <td>{{ $pestControl->pestControlDetail->pest_name }}</td>
                                <td>{{ $pestControl->plantDetail->plant_type }}</td>
                                <td>
                                    @if ($pestControl->pestControlDetail->pestCategory->name == 'Kumbang Perosak')
                                        <span class="badge badge-secondary">Kumbang Perosak</span>
                                    @elseif ($pestControl->pestControlDetail->pestCategory->name == 'Ulat Gulong')
                                        <span class="badge badge-warning">Ulat Gulong</span>
                                    @elseif ($pestControl->pestControlDetail->pestCategory->name == 'Lalat Buah')
                                        <span class="badge badge-info">Lalat Buah</span>
                                    @elseif ($pestControl->pestControlDetail->pestCategory->name == 'Penggorek Batang Pisang')
                                        <span class="badge badge-primary">Penggorek Batang Pisang</span>
                                        @elseif ($pestControl->pestControlDetail->pestCategory->name == 'Nematod')
                                        <span class="badge badge-light">Nematod</span>
                                    @endif
                                </td>
                                <td class="table-action">
                                    <a href="{{route('pest.show', $pestControl)}}" class="action-icon"> <i class="mdi mdi-eye-check text-primary"></i></a>
                                    <a href="{{route('pest.edit', $pestControl)}}" class="action-icon"> <i class="mdi mdi-file-document-edit text-info"></i></a>
                                    <a href="javascript: void(0);" class="action-icon" data-toggle="modal"
                                    data-target="#delete-modal-{{ $pestControl->id }}"
                                        data-id="{{ $pestControl->id }}"> <i class="mdi mdi-delete text-danger"></i></a>
                                </td>
                            </tr>
                               <!-- Delete modal -->
                               <div id="delete-modal-{{ $pestControl->id }}" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
                                <div class="modal-dialog ">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h4 class="modal-title" id="deleteModalLabel">Padam Maklumat Racun</h4>
                                            <button type="button" class="close" data-dismiss="modal"
                                                aria-hidden="true">×</button>
                                        </div>
                                        <div class="modal-body">
                                            <p>Adakah anda mahu memadam maklumat ini?</p>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-light btn-sm" data-dismiss="modal">
                                                Tidak, Batal
                                            </button>
                                            <form method="POST"
                                            action="{{ route('pest.destroy', $pestControl->id) }}">
                                            @csrf
                                            @method('DELETE')
                                            <input type="hidden" name="pest_id"
                                                value="{{ $pestControl->id }}">
                                            <button type="submit" class="btn btn-danger btn-sm">Betul,
                                                Padam</button>
                                        </form>
                                        </div>

                                    </div>
                                </div>
                            </div><!-- /.modal -->
                            @endforeach
                        </tbody>
                    </table>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>
    <!-- end row-->
@endsection
