    @extends('layouts.base')

    @section('content')
        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <h4 class="page-title">Rekod</h4>
                </div>
            </div>
        </div>
        <!-- end page title -->

        <div class="row">
            <div class="col-lg-6 col-xl-4">
                <div class="card widget-flat bg-success text-white">
                    <div class="card-body">
                        <div class="float-right">
                            <i class="dripicons-pamphlet widget-icon bg-white text-info"></i>
                        </div>
                        <h5 class="text-uppercase mt-0" title="Growth">Jumlah Kebun</h5>
                        <h3 class="mt-3 mb-3">{{ $totalFarms }} Kebun</h3>
                    </div>
                </div>
            </div> <!-- end col-->
            <div class="col-lg-6 col-xl-4">
                <div class="card widget-flat bg-primary text-white">
                    <div class="card-body">
                        <div class="float-right">
                            <i class="mdi mdi-clipboard-list-outline widget-icon bg-white text-primary"></i>
                        </div>
                        <h5 class="text-uppercase mt-0" title="Growth">Kategori Kebun</h5>
                        <h3 class="mt-3 mb-3">{{ $totalCategories }} Kebun</h3>
                    </div>
                </div>
            </div> <!-- end col-->
            <div class="col-lg-6 col-xl-4">
                <div class="card widget-flat bg-secondary text-white">
                    <div class="card-body">
                        <div class="float-right">
                            <i class="mdi mdi-pitchfork widget-icon bg-white text-secondary"></i>
                        </div>
                        <h5 class="text-uppercase mt-0" title="Growth">Tanaman Baru</h5>
                        <h3 class="mt-3 mb-3">{{ $totalFarmsWithPlantations }} Kebun</h3>
                    </div>
                </div>
            </div> <!-- end col-->
          
        </div>
        <!-- end row-->

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <h4 class="header-title">Kebun</h4>
                            <a href="{{ route('farm.create') }}" class="btn btn-primary btn-sm"
                                style="position: absolute; right:2%;">+Tambah Kebun</a>
                            <br><br>
                        </div>


                        <table id="basic-datatable" class="table dt-responsive nowrap w-100">
                            <thead>
                                <tr>
                                    <th>Bil</th>
                                    <th>Nama Kebun</th>
                                    <th>Saiz Kebun</th>
                                    <th>Kategori Kebun</th>
                                    {{-- <th>Jenis Kebun</th> --}}
                                    <th>Dokumen PDF</th>
                                    <th>Tindakan</th>
                                </tr>
                            </thead>


                            <tbody>
                                @foreach ($farms as $farm)
                                    <tr>
                                        <td>{{ $loop->index + 1 }}.</td>
                                        <td>{{ $farm->name }}</td>
                                        <td>{{ $farm->size }}</td>
                                        <td>
                                            @if ($farm->category->name == 'Kelapa')
                                                <span class="badge badge-warning">Kelapa</span>
                                            @elseif ($farm->category->name == 'Pisang')
                                                <span class="badge badge-info">Pisang</span>
                                            @else
                                                <span class="badge badge-secondary">{{ $farm->category->name }}</span>
                                                <!-- Default badge for other categories -->
                                            @endif
                                        </td>
                                        {{-- <td>{{ $farm->type }}</td> --}}
                                        <td><a href="{{ Storage::url($farm->pdf) }}" target="_blank">Lihat PDF</a></td>
                                        <td class="table-action">

                                            <a href="{{ route('farm.show', $farm) }}" class="action-icon"><i
                                                    class="mdi mdi-eye-check text-primary"></i></a>
                                            <a href="{{ route('farm.edit', $farm) }}" class="action-icon"> <i
                                                    class="mdi mdi-file-document-edit text-info"></i></a>
                                            <a href="javascript: void(0);" class="action-icon" data-toggle="modal"
                                                data-target="#delete-modal" data-id="{{ $farm->id }}"> <i
                                                    class="mdi mdi-delete text-danger"></i></a>
                                        </td>
                                    </tr>
                                @endforeach

                                <!-- Delete modal -->
                                <div id="delete-modal" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
                                    <div class="modal-dialog ">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title" id="deleteModalLabel">Padam Maklumat Kebun
                                                </h4>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-hidden="true">×</button>
                                            </div>
                                            <div class="modal-body">
                                                <p>Adakah anda mahu memadam maklumat ini?</p>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-light btn-sm" data-dismiss="modal">
                                                    Tidak, Batal
                                                </button>
                                                <form method="POST" action="{{ route('farm.destroy', $farm->id) }}">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger btn-sm">Betul,
                                                        Padam</button>
                                                </form>
                                            </div>

                                        </div>
                                    </div>
                                </div><!-- /.modal -->
                                {{-- <!-- View modal -->
                                    <div id="view-modal" class="modal fade" tabindex="-1" role="dialog"
                                        aria-hidden="true">
                                        <div class="modal-dialog ">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h4 class="modal-title" id="viewModalLabel">Maklumat Kebun</h4>
                                                    <button type="button" class="close" data-dismiss="modal"
                                                        aria-hidden="true">×</button>
                                                </div>
                                                <div class="modal-body">
                                                    <form>
                                                        <div class="form-row">
                                                            <div class="form-group col-md-8">
                                                                <label for="inputEmail4" class="col-form-label">Nama
                                                                    Kebun</label>
                                                                <input type="text" class="form-control" id="inputEmail4"
                                                                    placeholder="Kebun Gerobok Lama" readonly="">
                                                            </div>
                                                            <div class="form-group col-md-4 ">
                                                                <label for="inputEmail4" class="col-form-label">Saiz
                                                                    Kebun</label>
                                                                <input type="text" class="form-control" id="inputEmail4"
                                                                    placeholder="2.78 ha" readonly="">
                                                            </div>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="example-textarea">Alamat Kebun</label>
                                                            <textarea class="form-control" id="example-textarea" rows="5" placeholder="Mukim 123, Sungai Tawar"
                                                                readonly=""></textarea>
                                                        </div>
                                                        <div class="form-row">
                                                            <div class="form-group col-md-6">
                                                                <label for="inputState" class="col-form-label">Kategori
                                                                    Kebun</label>
                                                                <input type="text" class="form-control" id="inputEmail4"
                                                                    placeholder="Pisang" readonly="">
                                                            </div>
                                                            <div class="form-group col-md-6">
                                                                <label for="inputState" class="col-form-label">Jenis
                                                                    Kebun</label>
                                                                <input type="text" class="form-control"
                                                                    id="inputEmail4" placeholder="Terbuka"
                                                                    readonly="">
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-primary"
                                                        data-dismiss="modal">Tutup</button>
                                                </div>
                                            </div><!-- /.modal-content -->
                                        </div><!-- /.modal-dialog -->
                                    </div><!-- /.modal --> --}}

                            </tbody>
                        </table>
                    </div> <!-- end card body-->
                </div> <!-- end card -->
            </div><!-- end col-->
        </div>
        <!-- end row-->
    @endsection
