@extends('layouts.base')

@section('content')
    <div class="row">
        <div class="col-xl-4 col-lg-6">
            <div class="card widget-flat bg-info text-white">
                <div class="card-body">
                    <div class="float-right">
                        <i class="mdi mdi-pulse widget-icon bg-white text-info"></i>
                    </div>
                    <h5 class="text-uppercase mt-0" title="Growth">Jumlah Pengguna</h5>
                    <h3 class="mt-3 mb-3">+ 30.56%</h3>
                    <p class="mb-0">
                        <span class="badge badge-light-lighten mr-1">
                            <i class="mdi mdi-arrow-up-bold"></i> 4.87%</span>
                        <span class="text-nowrap">Since last month</span>
                    </p>
                </div>
            </div>
        </div> <!-- end col-->

        <div class="col-xl-4 col-lg-6">
            <div class="card widget-flat bg-success text-white">
                <div class="card-body">
                    <div class="float-right">
                        <i class="mdi mdi-pulse widget-icon bg-white text-success"></i>
                    </div>
                    <h5 class="text-uppercase mt-0" title="Growth">Jumlah Kebun</h5>
                    <h3 class="mt-3 mb-3">+ 30.56%</h3>
                    <p class="mb-0">
                        <span class="badge badge-light-lighten mr-1">
                            <i class="mdi mdi-arrow-up-bold"></i> 4.87%</span>
                        <span class="text-nowrap">Since last month</span>
                    </p>
                </div>
            </div>
        </div> <!-- end col-->

        <div class="col-xl-4 col-lg-6">
            <div class="card widget-flat bg-primary text-white">
                <div class="card-body">
                    <div class="float-right">
                        <i class="mdi mdi-pulse widget-icon bg-white text-primary"></i>
                    </div>
                    <h5 class="text-uppercase mt-0" title="Growth">Jumlah Baja</h5>
                    <h3 class="mt-3 mb-3">+ 30.56%</h3>
                    <p class="mb-0">
                        <span class="badge badge-light-lighten mr-1">
                            <i class="mdi mdi-arrow-up-bold"></i> 4.87%</span>
                        <span class="text-nowrap">Since last month</span>
                    </p>
                </div>
            </div>
        </div> <!-- end col-->



    </div>
    <!-- end row-->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <h4 class="header-title">Pengguna</h4>
                        <a href="{{ route('admin.users.create') }}" class="btn btn-primary btn-sm"
                            style="position: absolute; right:2%;">+Tambah
                            Pengguna</a>
                        <br><br>
                    </div>


                    <table id="basic-datatable" class="table dt-responsive nowrap w-100">
                        <thead>
                            <tr>
                                <th>No.</th>
                                <th>Nama Pengguna</th>
                                <th>Peranan</th>
                                <th>Tindakan</th>
                            </tr>
                        </thead>


                        <tbody>

                            @foreach ($users as $user)
                                @if ($user->role === 'Tuan_Kebun' || $user->role === 'Pekerja')
                                    <tr>
                                        <td>{{ $loop->index + 1 }}</td>
                                        <td>{{ $user->name }}</td>
                                        <td>
                                            @if ($user->job_type == 'Tiada')
                                                <span class="badge badge-primary">Tuan Kebun</span>
                                            @elseif ($user->job_type == 'Pengait')
                                                <span class="badge badge-info">Pengait</span>
                                            @elseif ($user->job_type == 'Pengopek')
                                                <span class="badge badge-warning">Pengopek</span>
                                            @elseif ($user->job_type == 'Penanam')
                                                <span class="badge badge-success">Penanam</span>
                                            @endif
                                        </td>

                                        <td class="table-action">
                                            <a href="javascript: void(0);" class="action-icon"data-toggle="modal"
                                                data-target="#view-modal-{{ $user->id }}"> <i
                                                    class="mdi mdi-eye-check text-primary"></i></a>
                                            <a href="javascript: void(0);" class="action-icon" data-toggle="modal"
                                                data-target="#delete-modal-{{$user->id}}" data-id="{{ $user->id }}"> <i class="mdi mdi-delete text-danger"></i></a>
                                        </td>
                                    </tr>
                                    <!-- View modal -->
                                    <div id="view-modal-{{$user->id}}" class="modal fade" tabindex="-1" role="dialog"
                                        aria-hidden="true">
                                        <div class="modal-dialog ">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h4 class="modal-title" id="viewModalLabel">Maklumat Pengguna</h4>
                                                    <button type="button" class="close" data-dismiss="modal"
                                                        aria-hidden="true">×</button>
                                                </div>
                                                <div class="modal-body">
                                                    <form>
                                                        <div class="form-row">
                                                            <div class="form-group col-md-6">
                                                                <label for="inputEmail4" class="col-form-label">Nama
                                                                    Pengguna</label>
                                                                <input type="text" class="form-control" id="inputEmail4"
                                                                    value="{{$user->name}}">
                                                            </div>
                                                            <div class="form-group col-md-6">
                                                                <label for="inputState"
                                                                    class="col-form-label">No Telefon</label>
                                                                <input type="text" class="form-control" id="inputEmail4"
                                                                    value="{{$user->phone}}">
                                                            </div>
                                                        </div>

                                                        <div class="form-group">
                                                            <label for="inputState" class="col-form-label">Jenis Pekerjaan</label>
                                                            <input type="text" class="form-control" id="inputEmail4"
                                                                value="{{$user->job_type}}">

                                                        </div>
                                                        <div class="form-group">
                                                            <label for="inputEmail4" class="col-form-label">Email</label>
                                                            <input type="email" class="form-control" id="inputEmail4"
                                                                value="{{$user->email}}">
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="inputEmail4" class="col-form-label">Alamat</label>
                                                            <textarea class="form-control" name="address" id="example-textarea" rows="5" required>{{ $user->address }}</textarea>
                                                        </div>

                                                    </form>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-primary"
                                                        data-dismiss="modal">Tutup</button>
                                                </div>
                                            </div><!-- /.modal-content -->
                                        </div><!-- /.modal-dialog -->
                                    </div><!-- /.modal -->

                                    <!-- Delete modal -->
                                    <div id="delete-modal-{{$user->id}}" class="modal fade" tabindex="-1" role="dialog"
                                        aria-hidden="true">
                                        <div class="modal-dialog ">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h4 class="modal-title" id="deleteModalLabel">Padam Maklumat Kebun
                                                    </h4>
                                                    <button type="button" class="close" data-dismiss="modal"
                                                        aria-hidden="true">×</button>
                                                </div>
                                                <div class="modal-body">
                                                    <p>Adakah anda mahu memadam maklumat ini?</p>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-light btn-sm"
                                                        data-dismiss="modal">
                                                        Tidak, Batal
                                                    </button>
                                                    <form method="POST" action="{{ route('admin.users.destroy', $user->id) }}" >
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-danger btn-sm">Betul,
                                                            Padam</button>
                                                    </form>
                                                </div>

                                            </div>
                                        </div>
                                    </div><!-- /.modal -->
                        </tbody>
                        @endif
                        @endforeach
                    </table>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>
    <!-- end row-->
@endsection
