<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PestControlDetail extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'category_id',
        'pest_category_id',
        'pest_name',
        'image',
    ];
    protected $dates = ['deleted_at'];

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    
    public function pestCategory()
    {
        return $this->belongsTo(PestCategory::class, 'pest_category_id');
    }

    public function pestControl()
    {
        return $this->hasMany(PestControl::class);
    }
}
