@extends('layouts.base')

@section('content')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">Pengurusan</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('farm.index') }}">Kebun</a></li>
                        <li class="breadcrumb-item active">Kemaskini Kebun</li>
                    </ol>
                </div>
                <h4 class="page-title">Pengurusan Kebun</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title">Kemaskini Kebun</h4>
                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                    <form action="{{ route('farm.update', $farm->id) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="form-row">
                            <div class="form-group col-md-8">
                                <label for="inputEmail4" class="col-form-label">Nama Kebun</label>
                                <input type="text" name="name" class="form-control" value="{{ $farm->name }}"
                                    required>
                            </div>
                            <div class="form-group col-md-4 ">
                                <label for="inputEmail4" class="col-form-label">Saiz Kebun</label>
                                <input type="number" name="size" class="form-control" value="{{ $farm->size }}"
                                min="1" max="5000" step="0.01" required>
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="inputState" class="col-form-label">Kategori Kebun</label>
                                <select id="plant_category" name="plant_category" class="form-control">
                                    <option value="">Sila Pilih</option>
                                    @foreach ($categories as $category)
                                        <option value="{{ $category->id }}" 
                                            {{ $category->id == $farm->category->id ? 'selected' : '' }}>
                                            {{ $category->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="inputState" class="col-form-label">Jenis Kebun</label>
                                <input type="text" name="type" class="form-control" value="{{ $farm->type }}"
                                    required>
                            </div>
                        </div>
                       

                           
                        <div class="form-group">
                            <label for="example-textarea">Alamat Kebun</label>
                            <textarea class="form-control" name="address" id="example-textarea" rows="5" required>{{ $farm->address }}</textarea>

                        </div>
                            <div class="form-group ">
                                <label for="pdf">Dokumen PDF (Pilihan)</label>
                                <input type="file" name="pdf" class="form-control">
                                <small class="form-text text-muted">Biarkan kosong jika anda tidak mahu menukar.</small>
                            </div>


                            <div class="text-center mt-2">
                                <button type="button" onclick="history.back()" class="btn btn-light mr-3">Batal</button>
                                <button type="submit" class="btn btn-info">Kemaskini</button>
                            </div>

                    </form>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>
    <!-- end row-->
@endsection
