<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sales', function (Blueprint $table) {
            $table->id();
            $table->foreignId('harvest_id')->nullable(); 
            $table->foreignId('customer_id')->nullable(); 
            $table->foreignId('price_id')->nullable(); 
            $table->integer('grade_a_sale')->default(0);
            $table->integer('grade_b_sale')->default(0); 
            $table->integer('grade_c_sale')->default(0); 
            $table->decimal('total_sale_grade_a', 8, 2)->nullable();
            $table->decimal('total_sale_grade_b', 8, 2)->nullable();
            $table->decimal('total_sale_grade_c', 8, 2)->nullable(); 
            $table->decimal('total_sale', 8, 2)->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sales');
    }
};
