<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title>Desa Grow Farm System</title>
    <!-- App favicon -->
    <link rel="shortcut icon" href="<?php echo e(asset('assets/images/favicon.ico')); ?>">

    <!-- App css -->
    <link href="<?php echo e(asset('assets/css/icons.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('assets/css/app.min.css')); ?>" rel="stylesheet" type="text/css" id="light-style">
    <link href="<?php echo e(asset('assets/css/app-dark.min.css')); ?>" rel="stylesheet" type="text/css" id="dark-style" />

    <!-- third party css fullcalendar -->
    <link href="<?php echo e(asset('assets/css/vendor/fullcalendar.min.css')); ?>" rel="stylesheet" type="text/css" />

    <!-- Flatpickr CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">

    <!-- Flatpickr JS -->
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>


</head>

<?php if(auth()->user()->role === 'Tuan_Kebun'): ?>

    <body class="loading"
        data-layout-config='{"leftSideBarTheme":"dark","layoutBoxed":false, "leftSidebarCondensed":false, "leftSidebarScrollable":false,"darkMode":false, "showRightSidebarOnStart": true}'>
    <?php elseif(auth()->user()->role === 'admin'): ?>

        <body class="loading"
            data-layout-config='{"leftSideBarTheme":"light","layoutBoxed":false, "leftSidebarCondensed":false, "leftSidebarScrollable":false,"darkMode":false, "showRightSidebarOnStart": true}'>
        <?php else: ?>

            <body class="loading"
                data-layout-config='{"leftSideBarTheme":"default","layoutBoxed":false, "leftSidebarCondensed":false, "leftSidebarScrollable":false,"darkMode":false, "showRightSidebarOnStart": true}'>
<?php endif; ?>
<!-- Begin page -->
<div class="wrapper">
    <!-- ========== Left Sidebar Start ========== -->
    <div class="left-side-menu">

        <!-- LOGO -->
        <a href="<?php echo e(route('dashboard')); ?>" class="logo text-center logo-light">
            <span class="logo-lg">
                <img src="<?php echo e(asset('assets/images/logo.png')); ?>" alt="" height="20">
            </span>
            <span class="logo-sm">
                <img src="<?php echo e(asset('assets/images/logo_sm.png')); ?>" alt="" height="16">
            </span>
        </a>

        <!-- LOGO -->
        <a href="<?php echo e(route('dashboard')); ?>" class="logo text-center logo-dark">
            <span class="logo-lg">
                <img src="<?php echo e(asset('assets/images/logo-dark.png')); ?>" alt="" height="20">
            </span>
            <span class="logo-sm">
                <img src="<?php echo e(asset('assets/images/logo_sm_dark.png')); ?>" alt="" height="16">
            </span>
        </a>

        <div class="h-100" id="left-side-menu-container" data-simplebar>

            <!--- Sidemenu -->
            <ul class="metismenu side-nav">

                <ul class="metismenu side-nav">

                    <li class="side-nav-title side-nav-item">Navigasi</li>
                    <li class="side-nav-item">
                        <a href="<?php echo e(route('dashboard')); ?>" class="side-nav-link">
                            <i class="uil-home-alt"></i>
                            <span>Laman Utama</span>
                        </a>
                    </li>
                    <li class="side-nav-item">
                        <a href="<?php echo e(route('plantation.schedule')); ?>" class="side-nav-link">
                            <i class=" uil-calendar-alt"></i>
                            <span>Jadual Bertugas </span>
                        </a>
                    </li>

                    <?php if(auth()->user()->role === 'admin'): ?>
                        <li class="side-nav-title side-nav-item">PENGURUSAN</li>
                        <li class="side-nav-item">
                            <a href="<?php echo e(route('admin.users.index')); ?>" class="side-nav-link">
                                <i class="dripicons-user"></i>
                                <span> Pengguna </span>
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if(auth()->user()->role === 'Tuan_Kebun'): ?>
                        <li class="side-nav-item">
                            <a href="javascript: void(0);" class="side-nav-link">
                                <i class="mdi mdi-home-assistant"></i>
                                <span> Pengurusan </span>
                                <span class="menu-arrow"></span>
                            </a>
                            <ul class="side-nav-second-level" aria-expanded="false">
                                <li>
                                    <a href="<?php echo e(route('farm.index')); ?>">Kebun</a>
                                </li>
                                <li>
                                    <a href="<?php echo e(route('fertilizer.index')); ?>">Baja</a>
                                </li>
                                <li>
                                    <a href="<?php echo e(route('pest.index')); ?>">Racun</a>
                                </li>
                            </ul>
                        </li>
                    <?php endif; ?>
                    <?php if(auth()->user()->role === 'Tuan_Kebun' || auth()->user()->role === 'Pekerja'): ?>
                    <li class="side-nav-title side-nav-item">PENGURUSAN</li>
                   
                    <li class="side-nav-item">
                        <a href="<?php echo e(route('plantation.index')); ?>" class="side-nav-link">
                            <i class="uil-trees"></i>
                            <span> Tanaman Semasa </span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if(auth()->user()->role === 'Tuan_Kebun' || auth()->user()->job_type === 'Pengait'): ?>
                    <li class="side-nav-title side-nav-item">HASIL</li>
                    <li class="side-nav-item">
                        <a href="<?php echo e(route('harvest.index')); ?>" class="side-nav-link">
                            <i class=" mdi mdi-pitchfork"></i>
                            <span>Hasil Kebun</span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if(auth()->user()->role === 'Tuan_Kebun'): ?>
                        <li class="side-nav-item">
                            <a href="<?php echo e(route('sales.index')); ?>" class="side-nav-link">
                                <i class=" uil-chart-pie-alt"></i>
                                <span>Hasil Jualan</span>
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if(auth()->user()->role === 'Tuan_Kebun' || auth()->user()->role === 'Pekerja'): ?>
                    <li class="side-nav-title side-nav-item">Lain-Lain</li>
                    <li class="side-nav-item">
                        <a href="<?php echo e(route('damage.index')); ?>" class="side-nav-link">
                            <i class="uil-comments-alt"></i>
                            <span>Aduan</span>
                        </a>
                    </li>
                    <?php endif; ?>



                </ul>
                <!-- End Sidebar -->

                <div class="clearfix"></div>

        </div>
        <!-- Sidebar -left -->

    </div>
    <!-- Left Sidebar End -->

    <!-- ============================================================== -->
    <!-- Start Page Content here -->
    <!-- ============================================================== -->

    <div class="content-page">
        <div class="content">
            <!-- Topbar Start -->
            <div class="navbar-custom">
                <ul class="list-unstyled topbar-right-menu float-right mb-0">
                    <li class="dropdown notification-list d-lg-none">
                        <a class="nav-link dropdown-toggle arrow-none" data-toggle="dropdown" href="#"
                            role="button" aria-haspopup="false" aria-expanded="false">
                            <i class="dripicons-search noti-icon"></i>
                        </a>
                        <div class="dropdown-menu dropdown-menu-animated dropdown-lg p-0">
                            <form class="p-3">
                                <input type="text" class="form-control" placeholder="Search ..."
                                    aria-label="Recipient's username">
                            </form>
                        </div>
                    </li>
                    <li class="dropdown notification-list">
                        <a class="nav-link dropdown-toggle arrow-none" data-toggle="dropdown" href="#"
                            role="button" aria-haspopup="false" aria-expanded="false">
                            <i class="dripicons-bell noti-icon"></i>
                            <span class="noti-icon-badge"></span>
                        </a>
                        <div class="dropdown-menu dropdown-menu-right dropdown-menu-animated dropdown-lg">

                            <!-- item-->
                            <div class="dropdown-item noti-title">
                                <h5 class="m-0">
                                    <span class="float-right">
                                        <a href="javascript: void(0);" class="text-dark">
                                            <small>Clear All</small>
                                        </a>
                                    </span>Notification
                                </h5>
                            </div>

                            <div style="max-height: 230px;" data-simplebar>
                                <!-- item-->
                                <a href="javascript:void(0);" class="dropdown-item notify-item">
                                    <div class="notify-icon bg-primary">
                                        <i class="mdi mdi-comment-account-outline"></i>
                                    </div>
                                    <p class="notify-details">Adam Bin Sulaiman tambah aduan
                                        <small class="text-muted">1 jam yang lalu</small>
                                    </p>
                                </a>

                                <!-- item-->
                                <a href="javascript:void(0);" class="dropdown-item notify-item">
                                    <div class="notify-icon bg-info">
                                        <i class="mdi mdi-account-plus"></i>
                                    </div>
                                    <p class="notify-details">Tanaman Baru Ditambah.
                                        <small class="text-muted">5 jam yang lalu</small>
                                    </p>
                                </a>

                                <!-- All-->
                                <a href="javascript:void(0);"
                                    class="dropdown-item text-center text-primary notify-item notify-all">
                                    View All
                                </a>

                            </div>
                        </div>
                    </li>
                    <?php if(auth()->user()->role === 'Tuan_Kebun'): ?>
                        <li class="dropdown notification-list">
                            <a class="nav-link dropdown-toggle arrow-none" data-toggle="dropdown" href="#"
                                role="button" aria-haspopup="false" aria-expanded="false">
                                <i class="dripicons-gear noti-icon"></i>
                                <div
                                    class="dropdown-menu dropdown-menu-right dropdown-menu-animated topbar-dropdown-menu profile-dropdown">
                                    <!-- item-->
                                    <div class=" dropdown-header noti-title">
                                        <h6 class="text-overflow m-0">TETAPAN</h6>
                                    </div>

                                    <!-- item-->
                                    <a href="<?php echo e(route('plant.index')); ?>" class="dropdown-item notify-item">
                                        <i class="mdi mdi-barley mr-1"></i>
                                        <span>Pokok</span>
                                    </a>

                                    <!-- item-->
                                    <a href="<?php echo e(route('fertilizer-detail.index')); ?>"
                                        class="dropdown-item notify-item">
                                        <i class="mdi mdi-bottle-tonic-plus mr-1"></i>
                                        <span>Baja</span>
                                    </a>
                                    <!-- item-->
                                    <a href="<?php echo e(route('pest-detail.index')); ?>" class="dropdown-item notify-item">
                                        <i class="mdi mdi-bug-outline mr-1"></i>
                                        <span>Racun</span>
                                    </a>
                                    <hr>
                                      <!-- item-->
                                      <a href="<?php echo e(route('price.index')); ?>" class="dropdown-item notify-item">
                                        <i class="mdi mdi-cash-usd-outline mr-1"></i>
                                        <span>Harga</span>
                                    </a>
                                    <a href="<?php echo e(route('customer.index')); ?>" class="dropdown-item notify-item">
                                        <i class="mdi mdi-account-multiple-plus mr-1"></i>
                                        <span>Pelanggan</span>
                                    </a>
                                </div>
                            </a>
                        </li>
                    <?php endif; ?>
                    <li class="dropdown notification-list">
                        <a class="nav-link dropdown-toggle nav-user arrow-none mr-0" data-toggle="dropdown"
                            href="#" role="button" aria-haspopup="false" aria-expanded="false">
                            <span class="account-user-avatar">
                                <img src="https://cdn.vectorstock.com/i/1000v/89/43/pk-logo-letter-monogram-slash-with-modern-vector-27868943.jpg" alt="user-image"
                                    class="rounded-circle">
                            </span>
                            <span>
                                <span class="account-user-name"><?php echo e(Auth::user()->name); ?> </span>
                                <?php if(auth()->user()->role === 'Tuan_Kebun'||auth()->user()->role === 'Admin'): ?>
                                <span class="account-position"><?php echo e(Auth::user()->role); ?></span>
                                <?php elseif(auth()->user()->role === 'Pekerja'): ?>
                                <span class="account-position"><?php echo e(Auth::user()->job_type); ?></span>
                                <?php endif; ?>
                            </span>
                        </a>
                        <div
                            class="dropdown-menu dropdown-menu-right dropdown-menu-animated topbar-dropdown-menu profile-dropdown">
                            <!-- item-->
                            <div class=" dropdown-header noti-title">
                                <h6 class="text-overflow m-0">Selamat Kembali !</h6>
                            </div>

                            <!-- item-->
                            <a href="<?php echo e(route('profile.edit')); ?>" class="dropdown-item notify-item">
                                <i class="mdi mdi-account-circle mr-1"></i>
                                <span><?php echo e(__('Profil')); ?></span>
                            </a>

                            <!-- item-->
                            <form method="POST" action="<?php echo e(route('logout')); ?>">
                                <?php echo csrf_field(); ?>
                                <a href="route('logout')"
                                    onclick="event.preventDefault();
                                                    this.closest('form').submit();"
                                    class="dropdown-item notify-item">
                                    <i class="mdi mdi-logout mr-1"></i>
                                    <span>Log Keluar</span>
                                </a>
                            </form>

                        </div>
                    </li>

                </ul>
                <button class="button-menu-mobile open-left disable-btn">
                    <i class="mdi mdi-menu"></i>
                </button>
            </div>

            <!-- end Topbar -->

            <!-- Start Content-->
            <div class="container-fluid">
                <br>
                <?php if(session('success')): ?>
                    <div class="alert alert-success">
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>

                <?php if(session('error')): ?>
                <div class="alert alert-danger">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>
                
                <?php echo $__env->yieldContent('content'); ?>
                <!-- Display success message -->


            </div> <!-- container -->

        </div> <!-- content -->

        <!-- Footer Start -->
        <footer class="footer">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 text-center">
                        <script>
                            document.write(new Date().getFullYear())
                        </script> © Hakmilik - Desa Grow Farm System
                    </div>
                </div>
            </div>
        </footer>
        <!-- end Footer -->

    </div>

    <!-- ============================================================== -->
    <!-- End Page content -->
    <!-- ============================================================== -->


</div>
<!-- END wrapper -->


<!-- bundle -->
<script src="<?php echo e(asset('assets/js/vendor.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/app.min.js')); ?>"></script>

<!-- third party js -->
<script src="<?php echo e(asset('assets/js/vendor/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/vendor/dataTables.bootstrap4.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/vendor/dataTables.responsive.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/vendor/responsive.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/vendor/dataTables.checkboxes.min.js')); ?>"></script>

<!-- demo app -->
<script src="<?php echo e(asset('assets/js/pages/demo.customers.js')); ?>"></script>

<!-- Datatables js -->
<script src="<?php echo e(asset('assets/js/vendor/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/vendor/dataTables.bootstrap4.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/vendor/dataTables.responsive.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/vendor/responsive.bootstrap4.min.js')); ?>"></script>

<!-- Datatables css -->
<link href="<?php echo e(asset('assets/css/vendor/dataTables.bootstrap4.css')); ?>" rel="stylesheet" type="text/css" />
<link href="<?php echo e(asset('assets/css/vendor/responsive.bootstrap4.css')); ?>" rel="stylesheet" type="text/css" />

<!-- Datatable Init js -->
<script src="<?php echo e(asset('assets/js/pages/demo.datatable-init.js')); ?>"></script>

<!-- Form Wizard -->
<script src="<?php echo e(asset('assets/js/pages/demo.form-wizard.js')); ?>"></script>

<!-- third party js -->
<script src="<?php echo e(asset('assets/js/vendor/jquery-ui.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/vendor/fullcalendar.min.js')); ?>"></script>
<!-- third party js ends -->

<!-- demo app -->
<script src="<?php echo e(asset('assets/js/pages/demo.calendar.js')); ?>"></script>
<!-- end demo js-->



</html>
<?php /**PATH C:\laragon\www\desa-grow-farm\resources\views/layouts/base.blade.php ENDPATH**/ ?>