

<?php $__env->startSection('content'); ?>
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <h4 class="page-title">Rekod</h4>
            </div>
        </div>
    </div>

    <?php if(auth()->user()->role === 'Tuan_Kebun'): ?>
        <div class="row">
            <div class="col-lg-6 col-xl-6">
                <div class="card widget-flat bg-info text-white">
                    <div class="card-body">
                        <div class="float-right">
                            <i class=" mdi mdi-basket-fill widget-icon bg-light text-info"></i>
                        </div>
                        <h5 class="text-uppercase mt-0" title="Growth">Jumlah Tuaian</h5>
                        <h3 class="mt-3 mb-3"><?php echo e($totalHarvests); ?> Kali</h3>
                    </div>
                </div>
            </div> <!-- end col-->

            <div class="col-lg-6 col-xl-6">
                <div class="card widget-flat bg-primary text-white">
                    <div class="card-body">
                        <div class="float-right">
                            <i class="mdi mdi-counter widget-icon bg-light text-primary"></i>
                        </div>
                        <h5 class="text-uppercase mt-0" title="Growth">Berat Tuaian </h5>
                        <h3 class="mt-3 mb-3"><?php echo e($totalOverallHarvest); ?> KG</h3>
                    </div>
                </div>
            </div> <!-- end col-->
        </div>
        <!-- end row-->
   



    <div class="row">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-body">
                    <!-- HTML -->
                    <h4 class="header-title">Graf Tuaian</h4>
                    <div id="chartdiv"></div>

                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>
    <!-- end row-->

    <?php endif; ?>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <h4 class="header-title">Laporan Tuaian</h4>
                    </div>

                    <table id="basic-datatable" class="table dt-responsive nowrap w-100">
                        <thead>
                            <tr>
                            <tr>
                                <th>Bil.</th>
                                <th>Kebun</th>
                                <th>Tarikh Tuaian</th>
                                <th>Ketegori Pokok</th>
                                <th>Nama Pokok</th>
                                <th>Status</th>
                                <th>Tindakan</th>
                            </tr>
                            </tr>
                        </thead>


                        <tbody>
                            <?php $__currentLoopData = $plantations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plantation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(
                                    $plantation->status === 'Tuai Hasil' ||
                                        ($plantation->harvest->status ?? null) === 'Kira Hasil' ||
                                        $plantation->status === 'Selesai'): ?>
                                    <tr>
                                        <td><?php echo e($loop->index + 1); ?></td>
                                        <td><?php echo e($plantation->farm->name); ?></td>
                                        <td><?php echo e($plantation->harvest_date); ?></td>
                                        <td>
                                            <?php if($plantation->farm->category->name == 'Kelapa'): ?>
                                                <span class="badge badge-warning">Kelapa</span>
                                            <?php else: ?>
                                                <span
                                                    class="badge badge-info"><?php echo e($plantation->farm->category->name); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($plantation->plantDetail->plant_type); ?></td>
                                        <td>
                                            <?php if(auth()->user()->role === 'Tuan_Kebun' && $plantation->status == 'Tuai Hasil'): ?>
                                                <span class="badge badge-success">Tuai Hasil</span>
                                            <?php elseif(auth()->user()->role === 'Tuan_Kebun' && $plantation->status == 'Selesai'): ?>
                                                <span class="badge badge-success">Selesai</span>
                                            <?php endif; ?>
                                            <?php if(auth()->user()->job_type === 'Pengait'): ?>
                                                
                                                <?php if($plantation->status == 'Tuai Hasil'): ?>
                                                    <span class="badge badge-warning">Tuai Hasil</span>
                                                <?php elseif(($plantation->harvest->status ?? null) == 'Kira Hasil'): ?>
                                                    <span class="badge badge-light">Kira Hasil</span>
                                                <?php elseif(($plantation->harvest->status ?? null) == 'Jual'): ?>
                                                    <span class="badge badge-danger">Jual</span>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </td>
                                        <td class="table-action">
                                            <a href="<?php echo e(route('harvest.show', $plantation->id)); ?>" class="action-icon"> <i
                                                    class="mdi mdi-eye-check text-primary"></i></a>
                                            <?php if(auth()->user()->job_type === 'Pengait' && $plantation->status === 'Tuai Hasil'): ?>
                                                <a href="<?php echo e(route('harvest.insert', $plantation->id)); ?>"
                                                    class="action-icon">
                                                    <i class="mdi mdi-plus-box text-info"></i></a>
                                            <?php endif; ?>

                                            <?php if(auth()->user()->job_type === 'Pengait' && ($plantation->harvest->status ?? null) === 'Kira Hasil'): ?>
                                                <a href="<?php echo e(route('harvest.edit', $plantation->id)); ?>" class="action-icon">
                                                    <i class="mdi mdi-square-edit-outline text-warning"></i>
                                                </a>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endif; ?>

                                <!-- Edit Hasil modal -->
                                <div id="edit-modal-<?php echo e($plantation->id); ?>" class="modal fade" tabindex="-1" role="dialog"
                                    aria-hidden="true">
                                    <div class="modal-dialog ">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title" id="editModalLabel">Kemaskini Hasil Tuai
                                                </h4>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-hidden="true">×</button>
                                            </div>
                                            <div class="modal-body">
                                                <form action="<?php echo e(route('harvest.update', $plantation->id)); ?>"
                                                    method="POST" enctype="multipart/form-data">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('PUT'); ?>
                                                    <div class="form-row">
                                                        <div class="form-group col-md-12">
                                                            <label for="inputState" class="col-form-label">Nama
                                                                Kebun</label>
                                                            <input type="text" name="plant_category" class="form-control"
                                                                value="<?php echo e($plantation->farm->name); ?>" readonly>
                                                        </div>

                                                        <div class="form-group col-md-6">
                                                            <label for="inputEmail4" class="col-form-label">Jenis
                                                                Pokok</label>
                                                            <input type="text" name="plant_type" class="form-control"
                                                                value="<?php echo e($plantation->farm->category->name); ?>" readonly>
                                                        </div>
                                                        <div class="form-group col-md-6">
                                                            <label for="inputEmail4" class="col-form-label">Nama
                                                                Pokok</label>
                                                            <input type="text" name="plant_type" class="form-control"
                                                                value="<?php echo e($plantation->plantDetail->plant_type); ?>"
                                                                readonly>
                                                        </div>
                                                        <div class="form-group col-md-6">
                                                            <label for="inputEmail4" class="col-form-label">Bilangan
                                                                Tanam</label>
                                                            <input type="text" name="plant_type" class="form-control"
                                                                value="<?php echo e($plantation->quantity_plant); ?> Batang" readonly>
                                                        </div>

                                                        <div class="form-group col-md-6">
                                                            <label for="inputEmail4" class="col-form-label">Tarikh
                                                                Penuaian</label>
                                                            <input type="text" name="plant_type" class="form-control"
                                                                value="<?php echo e($plantation->harvest_date); ?>" readonly>
                                                        </div>
                                                        <div class="form-group col-md-4">
                                                            <label for="inputEmail4" class="col-form-label">Gred
                                                                A</label>
                                                            <input type="text" name="plant_type" class="form-control"
                                                                value="<?php echo e($plantation->grade_a_quantity); ?>">
                                                        </div>
                                                        <div class="form-group col-md-4">
                                                            <label for="inputEmail4" class="col-form-label">Gred
                                                                B</label>
                                                            <input type="text" name="plant_type" class="form-control"
                                                                value="<?php echo e($plantation->grade_b_quantity); ?>">
                                                        </div>
                                                        <div class="form-group col-md-4">
                                                            <label for="inputEmail4" class="col-form-label">Gred
                                                                C</label>
                                                            <input type="text" name="plant_type" class="form-control"
                                                                value="<?php echo e($plantation->grade_c_quantity); ?>">
                                                        </div>

                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-light"
                                                            data-dismiss="modal">Batal</button>
                                                        <button type="submit" class="btn btn-primary">Kemaskini</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div><!-- /.modal-content -->
                                    </div><!-- /.modal-dialog -->
                                </div><!-- /.modal -->
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>

                    </table>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>
    <!-- end row-->

    <!-- Styles -->
    <style>
        #chartdiv {
            width: 100%;
            height: 300px;
        }
    </style>

    <!-- Resources -->
    <script src="https://cdn.amcharts.com/lib/5/index.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/xy.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/themes/Animated.js"></script>

    <!-- Chart Code -->
    <script>
        am5.ready(function() {
            // Initialize the root element for the chart
            var root = am5.Root.new("chartdiv");

            // Set animated theme
            root.setThemes([am5themes_Animated.new(root)]);

            // Create the main chart
            var chart = root.container.children.push(am5xy.XYChart.new(root, {
                panX: true,
                panY: true,
                wheelX: "panX",
                wheelY: "zoomX",
                pinchZoomX: true
            }));

            // Add a cursor to the chart
            var cursor = chart.set("cursor", am5xy.XYCursor.new(root, {
                behavior: "none",
            }));
            cursor.lineY.set("visible", false);

            // Process data passed from the server
            var data = [
                <?php $__currentLoopData = $chartData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    {
                        harvest_date: "<?php echo e($item['harvest_date']); ?>", // Keep as string for conversion
                        gred_a_quantity: <?php echo e($item['gred_a_quantity']); ?>,
                        gred_b_quantity: <?php echo e($item['gred_b_quantity']); ?>,
                        gred_c_quantity: <?php echo e($item['gred_c_quantity']); ?>,
                        gred_d_quantity: <?php echo e($item['gred_d_quantity']); ?>,
                    },
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            ];

            // Convert the `harvest_date` to a timestamp for use in the DateAxis
            data = data.map(item => ({
                ...item,
                harvest_date: Date.parse(item.harvest_date) // Ensure correct timestamp
            }));

            // Create X-Axis (DateAxis)
            var xAxis = chart.xAxes.push(am5xy.DateAxis.new(root, {
                baseInterval: {
                    timeUnit: "day",
                    count: 1
                },
                renderer: am5xy.AxisRendererX.new(root, {
                    minGridDistance: 70
                }),
                tooltip: am5.Tooltip.new(root, {})
            }));

            // Create Y-Axis (ValueAxis)
            var yAxis = chart.yAxes.push(am5xy.ValueAxis.new(root, {
                renderer: am5xy.AxisRendererY.new(root, {})
            }));

            // Function to create series for each data field
            function createSeries(name, field) {
                var series = chart.series.push(am5xy.LineSeries.new(root, {
                    name: name,
                    xAxis: xAxis,
                    yAxis: yAxis,
                    valueYField: field,
                    valueXField: "harvest_date",
                    tooltip: am5.Tooltip.new(root, {
                        pointerOrientation: "horizontal",
                        labelText: "[bold]{name}[/]\n{valueX.formatDate('yyyy-MM-dd')}: {valueY}"
                    })
                }));

                // Customize series appearance
                series.strokes.template.setAll({
                    strokeWidth: 2
                });

                // Set data for the series
                series.data.setAll(data);

                // Add animation
                series.appear(1000);
            }

            // Create series for each grade
            createSeries("Gred A ", "gred_a_quantity");
            createSeries("Gred B ", "gred_b_quantity");
            createSeries("Gred C", "gred_c_quantity");
            createSeries("Gred Tolak", "gred_d_quantity");

            // Add horizontal scrollbar
            chart.set("scrollbarX", am5.Scrollbar.new(root, {
                orientation: "horizontal"
            }));

            // Animate the chart on load
            chart.appear(1000, 100);
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\desa-grow-farm\resources\views/Harvest/index.blade.php ENDPATH**/ ?>