@extends('layouts.base')

@section('content')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">Baja & Racun</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('pest.index') }}">Racun</a></li>
                        <li class="breadcrumb-item active">Kemaskini Quantiti Racun</li>
                    </ol>
                </div>
                <h4 class="page-title">Maklumat Racun</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title">Sila Kemaskini Maklumat Dibawah.</h4> <br>
                    <div class="nav nav-pills nav-justified form-wizard-header mb-1 bg-info text-white"
                        style="padding-left:2%; padding-top:1%; padding-bottom:1%;">
                        <div class="row">
                            <!-- header plant detail -->
                            <div class="media">
                                <i class="uil uil-trees text-white font-weight-bold font-12 text-uppercase"></i> &nbsp;
                                <div class="media-body">
                                    <h5 class="mt-1 font-14">
                                        Maklumat Pokok
                                    </h5>
                                </div>
                            </div>
                            <!-- end header plant detail -->
                        </div> <!-- end row -->
                    </div>
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('pest.update', $pestControls->id) }}" method="POST"
                        enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="form-row">
                            <div class="form-group col-md-12">
                                <label for="inputState" class="col-form-label">Kategori Pokok</label>
                                <input type="text" name="plant_category" class="form-control"
                                    value="{{ $pestControls->plantDetail->category->name }}" readonly>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="inputNamaPokok" class="col-form-label">Nama Pokok</label>
                                <input type="text" name="plant_type" class="form-control"
                                    value="{{ $pestControls->plantDetail->plant_type }}" readonly>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="inputTempohKematangan" class="col-form-label">Tempoh Kematangan (Bulan) </label>
                                <input type="number" name="plant_maturity" class="form-control"
                                    value="{{ $pestControls->plantDetail->plant_maturity }}" readonly>
                            </div>
                        </div> <br>
                        <!-- Initial Maklumat Racun section -->
                        <div class="nav nav-pills nav-justified form-wizard-header mb-1 bg-info text-white"
                            style="padding-left:2%; padding-top:1%; padding-bottom:1%;">
                            <div class="row">
                                <!-- header plant detail -->
                                <div class="media">
                                    <i class="uil uil-trees text-white font-weight-bold font-12 text-uppercase"></i>
                                    &nbsp;
                                    <div class="media-body">
                                        <h5 class="mt-1 font-14 ">
                                            Maklumat Racun
                                        </h5>
                                    </div>
                                </div>
                                <!-- end header plant detail -->
                            </div> <!-- end row -->
                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="inputKategoriRacun" class="col-form-label">Jenis Racun</label>
                                <input type="text" name="pest_type" class="form-control"
                                    value="{{ $pestControls->pestControlDetail->pestCategory->name }}" readonly>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="inputNamaRacun" class="col-form-label">Nama Racun</label>
                                <input type="text" name="pest_name" class="form-control"
                                    value="{{ $pestControls->pestControlDetail->pest_name }}" readonly>
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="inputQuantitiRacun" class="col-form-label">Quantiti Racun</label>
                                <input type ="number" name="amount" class="form-control" id="inputQuantitiRacun"
                                    value="{{ $pestControls->amount }}" min="1" max="5000">
                            </div>
                            <div class="form-group col-md-6">
                                <label for="inputJenisKuantiti" class="col-form-label">Jenis Kuantiti</label>
                                <select id="amount_type" name="amount_type" class="form-control">
                                    <option value="">Sila Pilih</option>
                                    <option value="l/ha" {{ $pestControls->amount_type == 'l/ha' ? 'selected' : '' }}>l/ha
                                    </option>
                                    <option value="ml/ha" {{ $pestControls->amount_type == 'ml/ha' ? 'selected' : '' }}>
                                        ml/ha
                                    </option>
                                    <option value="kg/ha" {{ $pestControls->amount_type == 'kg/ha' ? 'selected' : '' }}>
                                        kg/ha
                                    </option>
                                    <option value="g/ha" {{ $pestControls->amount_type == 'g/ha' ? 'selected' : '' }}>
                                        g/ha
                                    </option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="example-textarea">Keterangan</label>
                            <textarea class="form-control" name="description" id="example-textarea" rows="5" required>{{ $pestControls->description }}</textarea>
                        </div>

                        <div class="text-center mt-2">
                            <button type="button" onclick="history.back()" class="btn btn-light mr-3">Batal</button>
                            <button type="submit" class="btn btn-info">Kemaskini</button>
                        </div>
                    </form>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>

@endsection
