@extends('layouts.base')

@section('content')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="worker-damage-index">Aduan</a></li>
                        <li class="breadcrumb-item active">Tambah Aduan</li>
                    </ol>
                </div>
                <h4 class="page-title">Pengurusan Aduan</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title">Tambah Aduan</h4>
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form role="form" method="POST" action="{{ route('damage.store') }}" enctype="multipart/form-data">
                        @csrf
                        <div class="form-group">
                            <label for="inputKategoriAduan" class="col-form-label">Jenis Aduan</label>
                            <select id="inputKategoriAduan" class="form-control" name="damage_category" required
                                onchange="updatePlantName()">
                                <option selected>Sila Pilih</option>
                                @foreach ($damageCategories as $category)
                                    <option value="{{ $category }}">{{ $category }}</option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Initial Maklumat Kebun section -->
                        <p class="text-muted font-14">Maklumat Kebun</p>
                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="inputKategoriTanaman" class="col-form-label">Lokasi Kebun</label>
                                <select id="inputKategoriTanaman" class="form-control" name="plantation_id" required
                                    onchange="updatePlantName()">
                                    <option selected>Sila Pilih</option>
                                   @foreach ($allFarms as $farm)
                                        <option value="{{ $farm->id }}">{{ $farm->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="inputNamaPokok" class="col-form-label">Nama Pokok</label>
                                <input type="text" id="inputNamaPokok" class="form-control" name="plant_type">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="project-overview">Keterangan Penyelesaian</label>
                            <textarea class="form-control" id="project-overview" name="damage_description" rows="5"
                                placeholder="Eg: Terdapat bintik-bintik merah di daun pokok."></textarea>
                        </div>
                        <div class="form-group">
                            <label for="example-fileinput">Muat Naik Gambar</label>
                            <input type="file" name="image" class="form-control" accept="image/">
                        </div>

                        <div class="text-center mt-2">
                            <button type="button" onclick="history.back()" class="btn btn-light mr-3">Batal</button>
                            <button type="submit" class="btn btn-primary">Simpan</button>
                        </div>
                    </form>
                </div> <!-- end card body-->
            </div> <!-- end card-->
        </div> <!-- end col-->
    </div>

    <script>
        const plantationsData = @json($plantations);

        function updatePlantName() {
            const plantationId = document.getElementById('inputKategoriTanaman').value;
            const plantNameField = document.getElementById('inputNamaPokok');

            // Find the selected plantation in the plantations data
            const selectedPlantation = plantationsData.find(plantation => plantation.id == plantationId);

            // Update the plant name field if a match is found
            if (selectedPlantation) {
                plantNameField.value = selectedPlantation.plant_detail?.plant_type || "Tidak diketahui";
            } else {
                plantNameField.value = ""; // Clear the field if no plantation is selected
            }
        }
    </script>

@endsection
