<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Sale extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'harvest_id',
        'customer_id',
        'price_id',
        'grade_a_sale',
        'grade_b_sale',
        'grade_c_sale',
        'total_sale_grade_a',
        'total_sale_grade_b',
        'total_sale_grade_c',
        'total_sale',
    ];

    protected $dates = ['deleted_at'];



    public function harvest()
    {
        return $this->belongsTo(Harvest::class);
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function price()
    {
        return $this->belongsTo(Price::class);
    }
}
